/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.scf;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.AbstractChromatogram;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.UnsupportedChromatogramFormatException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.SmallMap;

public class SCF
extends AbstractChromatogram {
    private byte[] privateData;
    private Properties comments = new Properties();
    private static final IntegerAlphabet.SubIntegerAlphabet PROBABILITY_ALPHABET = IntegerAlphabet.getSubAlphabet(0, 255);
    public static final Object PROB_NUC_A = "quality-a";
    public static final Object PROB_NUC_C = "quality-c";
    public static final Object PROB_NUC_G = "quality-g";
    public static final Object PROB_NUC_T = "quality-t";
    public static final Object PROB_SUBSTITUTION = "substitution-probability";
    public static final Object PROB_OVERCALL = "overcall-probability";
    public static final Object PROB_UNDERCALL = "undercall-probability";

    protected SCF() {
    }

    public static SCF create(File f) throws IOException, UnsupportedChromatogramFormatException {
        SCF out = new SCF();
        out.load(f);
        return out;
    }

    public static SCF create(InputStream in, long alreadyRead) throws IOException, UnsupportedChromatogramFormatException {
        SCF out = new SCF();
        out.load(in, alreadyRead);
        return out;
    }

    protected void load(File f) throws IOException, UnsupportedChromatogramFormatException {
        FileInputStream fin = new FileInputStream(f);
        this.load(fin, 0L);
    }

    protected void load(InputStream in, long initOffset) throws IOException, UnsupportedChromatogramFormatException {
        ParserFactory.parse(in, this, initOffset);
    }

    public Properties getComments() {
        return this.comments;
    }

    protected AbstractChromatogram reverseComplementInstance() {
        return new SCF();
    }

    public static IntegerAlphabet.SubIntegerAlphabet getProbabilityAlphabet() {
        return PROBABILITY_ALPHABET;
    }

    protected SymbolList reverseComplementBaseCallList(Object label) {
        if (label == PROB_SUBSTITUTION || label == PROB_OVERCALL || label == PROB_UNDERCALL) {
            return SymbolListViews.reverse(this.getBaseCalls().symbolListForLabel(label));
        }
        if (label == PROB_NUC_A) {
            return SymbolListViews.reverse(this.getBaseCalls().symbolListForLabel(PROB_NUC_T));
        }
        if (label == PROB_NUC_C) {
            return SymbolListViews.reverse(this.getBaseCalls().symbolListForLabel(PROB_NUC_G));
        }
        if (label == PROB_NUC_G) {
            return SymbolListViews.reverse(this.getBaseCalls().symbolListForLabel(PROB_NUC_C));
        }
        if (label == PROB_NUC_T) {
            return SymbolListViews.reverse(this.getBaseCalls().symbolListForLabel(PROB_NUC_A));
        }
        return super.reverseComplementBaseCallList(label);
    }

    static /* synthetic */ byte[] access$202(SCF x0, byte[] x1) {
        x0.privateData = x1;
        return x1;
    }

    private static class V2Parser
    extends Parser {
        V2Parser(DataInputStream din, SCF out, Parser.HeaderStruct header, long initOffset) throws IOException, UnsupportedChromatogramFormatException {
            super(din, out, header, initOffset);
        }

        protected void parseSamples() throws IOException {
            int i;
            int count = (int)this.header.samples;
            int[][] trace = new int[4][count];
            int[] maxVal = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
            if (this.header.sample_size == 1L) {
                for (i = 0; i < count; ++i) {
                    for (int n = 0; n < 4; ++n) {
                        trace[n][i] = this.din.readUnsignedByte();
                        maxVal[n] = Math.max(trace[n][i], maxVal[n]);
                        ++this.offset;
                    }
                }
            } else if (this.header.sample_size == 2L) {
                for (i = 0; i < count; ++i) {
                    for (int n = 0; n < 4; ++n) {
                        trace[n][i] = this.din.readUnsignedShort();
                        maxVal[n] = Math.max(trace[n][i], maxVal[n]);
                        this.offset += 2L;
                    }
                }
            }
            try {
                this.out.setTrace(DNATools.a(), trace[0], maxVal[0]);
                this.out.setTrace(DNATools.c(), trace[1], maxVal[1]);
                this.out.setTrace(DNATools.g(), trace[2], maxVal[2]);
                this.out.setTrace(DNATools.t(), trace[3], maxVal[3]);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen", ise);
            }
        }

        protected void parseBases() throws IOException, UnsupportedChromatogramFormatException {
            this.skipTo(this.header.bases_offset);
            int count = (int)this.header.bases;
            List[] probs = new ArrayList[7];
            for (int i = 0; i < probs.length; ++i) {
                probs[i] = new ArrayList(count);
            }
            ArrayList<Symbol> dna = new ArrayList<Symbol>(count);
            ArrayList<IntegerAlphabet.IntegerSymbol> offsets = new ArrayList<IntegerAlphabet.IntegerSymbol>(count);
            byte[] probTmp = new byte[7];
            for (int i = 0; i < count; ++i) {
                long tmp = 0xFFFFFFFF & this.din.readInt();
                this.offset += 4L;
                if (tmp > Integer.MAX_VALUE) {
                    throw new UnsupportedChromatogramFormatException("SCF contains a base with peak offset > 2147483647");
                }
                offsets.add(IntegerAlphabet.getInstance().getSymbol((int)tmp));
                this.din.read(probTmp, 0, 4);
                this.offset += 4L;
                try {
                    dna.add(this.decoder.decode(this.din.readByte()));
                    ++this.offset;
                }
                catch (IllegalSymbolException ise) {
                    ise.printStackTrace(System.err);
                    throw new UnsupportedChromatogramFormatException("Base call decoding failure");
                }
                this.din.read(probTmp, 4, 3);
                this.offset += 3L;
                try {
                    for (int p = 0; p < 7; ++p) {
                        probs[p].add(SCF.getProbabilityAlphabet().getSymbol(0xFF & probTmp[p]));
                    }
                    continue;
                }
                catch (IllegalSymbolException ise) {
                    throw new BioError("Can't happen unless getProbabilityAlphabet() has been misdefined.");
                }
            }
            this.createAndSetBaseCallAlignment(dna, offsets, probs);
        }
    }

    private static class V3Parser
    extends Parser {
        V3Parser(DataInputStream din, SCF out, Parser.HeaderStruct header, long initOffset) throws IOException, UnsupportedChromatogramFormatException {
            super(din, out, header, initOffset);
        }

        protected void parseSamples() throws IOException, UnsupportedChromatogramFormatException {
            this.skipTo(this.header.samples_offset);
            int count = (int)this.header.samples;
            int[][] trace = new int[4][count];
            int[] maxVal = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
            for (int n = 0; n < 4; ++n) {
                this.readSamplesInto(trace[n]);
            }
            int[] p_sample1 = new int[]{0, 0, 0, 0};
            int[] p_sample2 = new int[]{0, 0, 0, 0};
            for (int n = 0; n < 4; ++n) {
                for (int i = 1; i < trace[n].length; ++i) {
                    int n2 = n;
                    p_sample1[n2] = p_sample1[n2] + trace[n][i];
                    trace[n][i] = p_sample1[n] + p_sample2[n];
                    p_sample2[n] = trace[n][i];
                    maxVal[n] = Math.max(maxVal[n], trace[n][i]);
                }
            }
            try {
                this.out.setTrace(DNATools.a(), trace[0], maxVal[0]);
                this.out.setTrace(DNATools.c(), trace[1], maxVal[1]);
                this.out.setTrace(DNATools.g(), trace[2], maxVal[2]);
                this.out.setTrace(DNATools.t(), trace[3], maxVal[3]);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen", ise);
            }
        }

        protected void readSamplesInto(int[] samps) throws IOException {
            block3: {
                block2: {
                    if (this.header.sample_size != 1L) break block2;
                    for (int i = 0; i < samps.length; ++i) {
                        samps[i] = this.din.readUnsignedByte();
                        ++this.offset;
                    }
                    break block3;
                }
                if (this.header.sample_size != 2L) break block3;
                for (int i = 0; i < samps.length; ++i) {
                    samps[i] = this.din.readUnsignedShort();
                    this.offset += 2L;
                }
            }
        }

        protected void parseBases() throws IOException, UnsupportedChromatogramFormatException {
            this.skipTo(this.header.bases_offset);
            int count = (int)this.header.bases;
            List[] probs = new ArrayList[7];
            for (int i = 0; i < 7; ++i) {
                probs[i] = new ArrayList(count);
            }
            ArrayList<IntegerAlphabet.IntegerSymbol> offsets = new ArrayList<IntegerAlphabet.IntegerSymbol>(count);
            ArrayList<Symbol> dna = new ArrayList<Symbol>(count);
            try {
                int i;
                int j;
                int i2;
                for (i2 = 0; i2 < count; ++i2) {
                    long tmp = 0xFFFFFFFF & this.din.readInt();
                    this.offset += 4L;
                    if (tmp > Integer.MAX_VALUE) {
                        throw new UnsupportedChromatogramFormatException("SCF contains a base with peak offset > 2147483647");
                    }
                    offsets.add(IntegerAlphabet.getInstance().getSymbol((int)tmp));
                }
                for (j = 0; j < 4; ++j) {
                    for (i = 0; i < count; ++i) {
                        probs[j].add(SCF.getProbabilityAlphabet().getSymbol(this.din.readByte() & 0xFF));
                        ++this.offset;
                    }
                }
                try {
                    for (i2 = 0; i2 < count; ++i2) {
                        dna.add(this.decoder.decode(this.din.readByte()));
                        ++this.offset;
                    }
                }
                catch (IllegalSymbolException ise) {
                    ise.printStackTrace(System.err);
                    throw new UnsupportedChromatogramFormatException("Base call decoding failure");
                }
                for (j = 4; j < 7; ++j) {
                    for (i = 0; i < count; ++i) {
                        probs[j].add(SCF.getProbabilityAlphabet().getSymbol(this.din.readByte() & 0xFF));
                        ++this.offset;
                    }
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen unless there's a misdefinition of getProbabilityAlphabet() or IntegerAlphabet", ise);
            }
            this.createAndSetBaseCallAlignment(dna, offsets, probs);
        }
    }

    static abstract class Parser {
        protected long offset = 0L;
        protected DataInputStream din = null;
        protected HeaderStruct header;
        protected BaseCallUncertaintyDecoder decoder;
        protected SCF out = null;
        protected boolean parsed = false;

        Parser(DataInputStream din, SCF out, HeaderStruct header, long initOffset) throws UnsupportedChromatogramFormatException {
            if (din == null) {
                throw new IllegalArgumentException("Can't parse a null inputstream");
            }
            this.din = din;
            this.out = out == null ? new SCF() : out;
            if (header.samples > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Can't parse an SCF with more than 2147483647 trace samples");
            }
            if (header.bases > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Can't parse an SCF with more than 2147483647 called bases");
            }
            this.header = header;
            this.decoder = Parser.createDecoder(header.code_set);
            this.offset = initOffset;
        }

        private static BaseCallUncertaintyDecoder createDecoder(long codeSet) {
            if (codeSet != 0L && codeSet != 4L) {
                System.err.println("Warning: the code set (" + codeSet + ") is not specifically supported.  (It may still work, though.)");
            }
            return new DefaultUncertaintyDecoder();
        }

        public SCF getParsed() {
            if (this.parsed) {
                return this.out;
            }
            return null;
        }

        public void parse() throws IOException, UnsupportedChromatogramFormatException {
            this.parsed = false;
            Integer SAMPLES = new Integer(0);
            Integer BASES = new Integer(1);
            Integer COMMENTS = new Integer(2);
            Integer PRIVATE = new Integer(3);
            TreeMap<Long, Integer> sectionOrder = new TreeMap<Long, Integer>();
            sectionOrder.put(new Long(this.header.samples_offset), SAMPLES);
            sectionOrder.put(new Long(this.header.bases_offset), BASES);
            sectionOrder.put(new Long(this.header.comments_offset), COMMENTS);
            sectionOrder.put(new Long(this.header.private_offset), PRIVATE);
            Iterator it = sectionOrder.keySet().iterator();
            while (it.hasNext()) {
                Integer sect = (Integer)sectionOrder.get(it.next());
                if (sect == SAMPLES) {
                    this.parseSamples();
                    continue;
                }
                if (sect == BASES) {
                    this.parseBases();
                    continue;
                }
                if (sect == COMMENTS) {
                    this.parseComments();
                    continue;
                }
                if (sect != PRIVATE) continue;
                this.parsePrivate();
            }
            this.parsed = true;
        }

        protected abstract void parseSamples() throws IOException, UnsupportedChromatogramFormatException;

        protected abstract void parseBases() throws IOException, UnsupportedChromatogramFormatException;

        protected void parseComments() throws IOException {
            String line;
            this.skipTo(this.header.comments_offset);
            byte[] raw = new byte[(int)this.header.comments_size - 1];
            this.din.read(raw, 0, raw.length);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(raw), "ISO-8859-1"));
            int eqIdx = -1;
            while ((line = r.readLine()) != null) {
                eqIdx = line.indexOf(61);
                String key = line.substring(0, eqIdx);
                String value = line.substring(eqIdx + 1);
                this.out.comments.setProperty(key, value);
            }
        }

        protected void parsePrivate() throws IOException {
            if (this.header.private_size == 0L) {
                return;
            }
            this.skipTo(this.header.private_offset);
            SCF.access$202(this.out, new byte[(int)this.header.private_size]);
            int thisRead = 0;
            for (int privRead = 0; privRead < this.out.privateData.length; privRead += thisRead) {
                thisRead = this.din.read(this.out.privateData, privRead, this.out.privateData.length - privRead);
                this.offset += (long)thisRead;
            }
        }

        protected final void skipTo(long newOffset) throws IOException {
            int actualSkip;
            if (newOffset < this.offset) {
                throw new IllegalArgumentException("Can't skip backwards: (newOffset==" + newOffset + ") < (offset==" + this.offset + ")");
            }
            for (long skip = newOffset - this.offset; skip > 0L; skip -= (long)actualSkip) {
                actualSkip = this.din.skipBytes((int)skip);
                this.offset += (long)actualSkip;
            }
        }

        protected final void createAndSetBaseCallAlignment(List dna, List offsets, List[] probs) {
            try {
                SmallMap baseCalls = new SmallMap(9);
                baseCalls.put(Chromatogram.DNA, this.out.createImmutableSymbolList(DNATools.getDNA(), dna));
                baseCalls.put(Chromatogram.OFFSETS, this.out.createImmutableSymbolList(IntegerAlphabet.getInstance(), offsets));
                baseCalls.put(PROB_NUC_A, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[0]));
                baseCalls.put(PROB_NUC_C, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[1]));
                baseCalls.put(PROB_NUC_G, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[2]));
                baseCalls.put(PROB_NUC_T, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[3]));
                baseCalls.put(PROB_SUBSTITUTION, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[4]));
                baseCalls.put(PROB_OVERCALL, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[5]));
                baseCalls.put(PROB_UNDERCALL, this.out.createImmutableSymbolList(SCF.getProbabilityAlphabet(), probs[6]));
                this.out.setBaseCallAlignment(this.out.createImmutableAlignment(baseCalls));
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen unless the decoder is returning non-DNA symbols", ise);
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError("Can't happen", iae);
            }
        }

        private static class HeaderStruct {
            public static final int HEADER_LENGTH = 128;
            public long magic_number;
            public long samples;
            public long samples_offset;
            public long bases;
            public long bases_left_clip;
            public long bases_right_clip;
            public long bases_offset;
            public long comments_size;
            public long comments_offset;
            public char[] version = new char[4];
            public long sample_size;
            public long code_set;
            public long private_size;
            public long private_offset;
            public long[] spare = new long[18];

            private HeaderStruct() {
            }

            public static HeaderStruct create(DataInputStream din, long initOffset) throws IOException {
                int i;
                HeaderStruct hs = new HeaderStruct();
                if (initOffset > 4L) {
                    throw new IllegalStateException("Can't skip more than four bytes and still have enough info to read header");
                }
                if (initOffset == 0L) {
                    hs.magic_number = 0xFFFFFFFF & din.readInt();
                } else {
                    hs.magic_number = 0L;
                    i = 0;
                    while ((long)i < 4L - initOffset) {
                        din.read();
                        ++i;
                    }
                }
                hs.samples = 0xFFFFFFFF & din.readInt();
                hs.samples_offset = 0xFFFFFFFF & din.readInt();
                hs.bases = 0xFFFFFFFF & din.readInt();
                hs.bases_left_clip = 0xFFFFFFFF & din.readInt();
                hs.bases_right_clip = 0xFFFFFFFF & din.readInt();
                hs.bases_offset = 0xFFFFFFFF & din.readInt();
                hs.comments_size = 0xFFFFFFFF & din.readInt();
                hs.comments_offset = 0xFFFFFFFF & din.readInt();
                hs.version[0] = (char)din.readByte();
                hs.version[1] = (char)din.readByte();
                hs.version[2] = (char)din.readByte();
                hs.version[3] = (char)din.readByte();
                hs.sample_size = 0xFFFFFFFF & din.readInt();
                hs.code_set = 0xFFFFFFFF & din.readInt();
                hs.private_size = 0xFFFFFFFF & din.readInt();
                hs.private_offset = 0xFFFFFFFF & din.readInt();
                for (i = 0; i < hs.spare.length; ++i) {
                    hs.spare[i] = 0xFFFFFFFF & din.readInt();
                }
                return hs;
            }
        }
    }

    static class DefaultUncertaintyDecoder
    implements BaseCallUncertaintyDecoder {
        public Symbol decode(byte call) throws IllegalSymbolException {
            char c = (char)call;
            switch (c) {
                case 'A': 
                case 'a': {
                    return DNATools.a();
                }
                case 'C': 
                case 'c': {
                    return DNATools.c();
                }
                case 'G': 
                case 'g': {
                    return DNATools.g();
                }
                case 'T': 
                case 't': {
                    return DNATools.t();
                }
                case 'N': 
                case 'n': {
                    return DNATools.n();
                }
                case '-': {
                    return DNATools.getDNA().getGapSymbol();
                }
            }
            throw new IllegalSymbolException("No Symbol for " + c);
        }
    }

    static interface BaseCallUncertaintyDecoder {
        public Symbol decode(byte var1) throws IllegalSymbolException;
    }

    private static class ParserFactory {
        private ParserFactory() {
        }

        public static void parse(InputStream in, SCF out, long initOffset) throws IOException, UnsupportedChromatogramFormatException {
            DataInputStream din = new DataInputStream(in);
            Parser parser = ParserFactory.createParser(din, out, initOffset);
            parser.parse();
        }

        /*
         * WARNING - void declaration
         */
        public static Parser createParser(DataInputStream din, SCF out, long initOffset) throws UnsupportedChromatogramFormatException, IOException {
            void var7_7;
            Parser parser;
            float version;
            long offset = initOffset;
            Parser.HeaderStruct header = Parser.HeaderStruct.create(din, initOffset);
            offset = 128L;
            out.setBits((int)header.sample_size * 8);
            try {
                version = Float.parseFloat(new String(header.version));
            }
            catch (NumberFormatException e) {
                throw new UnsupportedChromatogramFormatException("The SCF's version (" + new String(header.version) + ") is not a number");
            }
            if (version < 3.0f && version >= 2.0f) {
                parser = new V2Parser(din, out, header, offset);
            } else if (version >= 3.0f) {
                parser = new V3Parser(din, out, header, offset);
            } else {
                throw new UnsupportedChromatogramFormatException("Only version 2 and version 3 SCFs are supported (not " + new String(header.version));
            }
            return var7_7;
        }
    }
}

