/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.program.das.dasalignment.DASAlignmentXMLResponseParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DASAlignmentCall {
    String serverurl;

    public DASAlignmentCall() {
        this.serverurl = "";
    }

    public DASAlignmentCall(String url) {
        this.serverurl = url;
    }

    public void setServerurl(String s) {
        this.serverurl = s;
    }

    public String getServerurl() {
        return this.serverurl;
    }

    public ArrayList getAlignments(String query) throws IOException {
        String connstr = this.serverurl + query;
        URL dasUrl = null;
        try {
            dasUrl = new URL(connstr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("connecting to " + connstr);
        InputStream inStream = this.connectDASServer(dasUrl);
        ArrayList ali = null;
        try {
            ali = this.parseDASResponse(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ali;
    }

    private InputStream connectDASServer(URL url) throws IOException {
        InputStream inStream = null;
        HttpURLConnection huc = null;
        huc = (HttpURLConnection)url.openConnection();
        System.out.println("response code " + huc.getResponseCode());
        inStream = huc.getInputStream();
        return inStream;
    }

    private ArrayList parseDASResponse(InputStream inStream) throws IOException, SAXException {
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        spfactory.setValidating(false);
        SAXParser saxParser = null;
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        XMLReader xmlreader = saxParser.getXMLReader();
        try {
            xmlreader.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXException e) {
            System.err.println("Cannot deactivate validation.");
        }
        try {
            xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        DASAlignmentXMLResponseParser cont_handle = new DASAlignmentXMLResponseParser();
        xmlreader.setContentHandler(cont_handle);
        xmlreader.setErrorHandler(new DefaultHandler());
        InputSource insource = new InputSource();
        insource.setByteStream(inStream);
        System.out.println("DASAlignmentCall parse XML response ...");
        xmlreader.parse(insource);
        System.out.println("DASAlignmentCall parse XML response done.");
        return cont_handle.getAlignments();
    }
}

