/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.BufferedReader;
import java.io.IOException;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierInfoException;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.util.StringVector;

public class StreamQualifier {
    private static final StringBuffer read_name_string_buffer = new StringBuffer(20);
    private static char[] read_value_buffer = new char[5000];
    private static int buffer_index = 0;

    public static Qualifier makeStreamQualifier(String name, String value, EntryInformation entry_information) throws QualifierParseException {
        if (!entry_information.isValidQualifier(name)) {
            QualifierInfo new_qualifier_info = value.startsWith("\"") ? new QualifierInfo(name, 1, null, null, false) : new QualifierInfo(name, 2, null, null, false);
            try {
                entry_information.addQualifierInfo(new_qualifier_info);
            }
            catch (QualifierInfoException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return new Qualifier(name, StreamQualifier.unquote(value));
    }

    public static String toString(QualifierInfo qualifier_info, Qualifier qualifier) {
        StringVector values = qualifier.getValues();
        if (values == null) {
            return String.valueOf('/') + qualifier.getName();
        }
        StringBuffer buffer = new StringBuffer(50);
        int i = 0;
        while (i < values.size()) {
            buffer.append('/');
            buffer.append(qualifier.getName());
            if (values.elementAt(i) != null) {
                buffer.append('=');
                buffer.append(StreamQualifier.quotedValue(qualifier_info, qualifier.getName(), values.elementAt(i)));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static StringVector toStringVector(QualifierInfo qualifier_info, Qualifier qualifier) {
        StringVector values = qualifier.getValues();
        StringVector return_vector = new StringVector();
        if (values == null) {
            return_vector.add(String.valueOf('/') + qualifier.getName());
        } else {
            int i = 0;
            while (i < values.size()) {
                StringBuffer buffer = new StringBuffer(50);
                buffer.append('/');
                buffer.append(qualifier.getName());
                if (values.elementAt(i) != null) {
                    buffer.append('=');
                    buffer.append(StreamQualifier.quotedValue(qualifier_info, qualifier.getName(), values.elementAt(i)));
                }
                return_vector.add(buffer.toString());
                ++i;
            }
        }
        return return_vector;
    }

    static String readName(BufferedReader buffered_reader) throws QualifierParseException, IOException {
        int current_char;
        while ((current_char = buffered_reader.read()) != -1 && current_char != 0) {
            if (32 == current_char || 10 == current_char || 9 == current_char) continue;
            if (47 == current_char) break;
            throw new QualifierParseException("failed to read a qualifier name from this string: " + (char)current_char + buffered_reader.readLine());
        }
        if (-1 == current_char || current_char == 0) {
            return null;
        }
        buffered_reader.mark(1);
        read_name_string_buffer.setLength(0);
        while ((current_char = buffered_reader.read()) != -1) {
            if (Character.isLetter((char)current_char) || Character.isDigit((char)current_char) || 95 == current_char || 43 == current_char) {
                read_name_string_buffer.append((char)current_char);
                buffered_reader.mark(1);
                continue;
            }
            buffered_reader.reset();
            break;
        }
        String return_string = read_name_string_buffer.toString();
        if (return_string.length() == 0) {
            throw new QualifierParseException("zero length qualifier name read from this string: " + buffered_reader.readLine());
        }
        return return_string;
    }

    private static void appendToValueBuffer(char new_char) {
        if (buffer_index >= read_value_buffer.length) {
            char[] temp_buffer = new char[read_value_buffer.length * 2];
            System.arraycopy(read_value_buffer, 0, temp_buffer, 0, read_value_buffer.length);
            read_value_buffer = temp_buffer;
        }
        StreamQualifier.read_value_buffer[StreamQualifier.buffer_index++] = new_char;
    }

    /*
     * Unable to fully structure code
     */
    static synchronized String readValue(BufferedReader buffered_reader) throws QualifierParseException, IOException {
        StreamQualifier.buffer_index = 0;
        buffered_reader.mark(1);
        current_char = buffered_reader.read();
        if (-1 == current_char) {
            return "";
        }
        final_char = 0;
        start_char = 0;
        bracket_count = 0;
        if (34 == current_char) {
            final_char = 34;
        }
        if (91 == current_char) {
            final_char = 93;
            start_char = 91;
            ++bracket_count;
        }
        if (40 == current_char) {
            final_char = 41;
            start_char = 40;
            ++bracket_count;
        }
        if (final_char == 0) {
            buffered_reader.reset();
        } else {
            StreamQualifier.appendToValueBuffer((char)current_char);
        }
        buffered_reader.mark(1);
        while ((current_char = buffered_reader.read()) != -1) {
            if (Character.isISOControl((char)current_char) && current_char != 9) {
                current_char = 32;
            }
            if (current_char != 34) {
                if (current_char == start_char) {
                    ++bracket_count;
                } else if (current_char == final_char) {
                    --bracket_count;
                }
            }
            if (current_char == final_char && bracket_count == 0) {
                if (current_char == 34) {
                    buffered_reader.mark(1);
                    next_char = buffered_reader.read();
                    if (next_char == 34) {
                        StreamQualifier.appendToValueBuffer('\"');
                        StreamQualifier.appendToValueBuffer('\"');
                        continue;
                    }
                    if (next_char != -1) {
                        buffered_reader.reset();
                    }
                    StreamQualifier.appendToValueBuffer('\"');
                    break;
                }
                StreamQualifier.appendToValueBuffer((char)current_char);
                break;
            }
            if (final_char == 0 && 47 == current_char) {
                buffered_reader.reset();
                break;
            }
            StreamQualifier.appendToValueBuffer((char)current_char);
            buffered_reader.mark(1);
        }
        if (bracket_count <= 0) ** GOTO lbl56
        throw new QualifierParseException("hit the end of line while looking for a \"" + (char)final_char + "\"");
lbl-1000:
        // 1 sources

        {
            --StreamQualifier.buffer_index;
lbl56:
            // 2 sources

            ** while (StreamQualifier.buffer_index > 0 && Character.isWhitespace((char)StreamQualifier.read_value_buffer[StreamQualifier.buffer_index - 1]))
        }
lbl57:
        // 1 sources

        return new String(StreamQualifier.read_value_buffer, 0, StreamQualifier.buffer_index);
    }

    private static String quotedValue(QualifierInfo qualifier_info, String name, String value) {
        if (qualifier_info != null && (qualifier_info.getType() == 1 || qualifier_info.getType() == 4)) {
            return String.valueOf('\"') + value + '\"';
        }
        if (value.indexOf(47) != -1) {
            return String.valueOf('\"') + value + '\"';
        }
        return value;
    }

    private static String unquote(String value) throws QualifierParseException {
        if (value.length() >= 2) {
            char first_char = value.charAt(0);
            char last_char = value.charAt(value.length() - 1);
            if (first_char == '\"' && last_char == '\"') {
                return value.substring(1, value.length() - 1);
            }
            if (first_char != '\"' && last_char != '\"') {
                return value;
            }
            throw new QualifierParseException("unbalanced quotes: " + value);
        }
        return value;
    }
}

