/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.Vector;
import uk.ac.sanger.artemis.io.Qualifier;

public class QualifierVector {
    private final Vector vector = new Vector(7);

    public boolean equals(Object object) {
        if (object instanceof QualifierVector) {
            QualifierVector comp_vector = (QualifierVector)object;
            if (comp_vector.size() == this.size()) {
                int i = 0;
                while (i < this.size()) {
                    if (!comp_vector.elementAt(i).equals(this.elementAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Qualifier addQualifierValues(Qualifier qualifier) {
        if (qualifier.getName() == null) {
            throw new Error("");
        }
        int index_of_qualifier = this.indexOfQualifierWithName(qualifier.getName());
        if (index_of_qualifier == -1) {
            this.vector.addElement(qualifier.copy());
            return null;
        }
        Qualifier current_qualifier = this.elementAt(index_of_qualifier);
        current_qualifier.addValues(qualifier.getValues());
        return current_qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        int index = this.indexOfQualifierWithName(qualifier.getName());
        if (index == -1) {
            this.vector.addElement(qualifier);
        } else {
            this.removeQualifierByName(qualifier.getName());
            this.vector.addElement(qualifier.copy());
        }
    }

    public void removeQualifierByName(String name) {
        int index = this.indexOfQualifierWithName(name);
        if (index != -1) {
            this.vector.removeElementAt(index);
        }
    }

    public Qualifier elementAt(int index) {
        return (Qualifier)this.vector.elementAt(index);
    }

    public int size() {
        return this.vector.size();
    }

    public boolean contains(String name) {
        return this.indexOfQualifierWithName(name) != -1;
    }

    public int indexOfQualifierWithName(String name) {
        int i = 0;
        while (i < this.size()) {
            if (this.elementAt(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Qualifier getQualifierByName(String name) {
        int index_of_named_qualifier = this.indexOfQualifierWithName(name);
        if (index_of_named_qualifier == -1) {
            return null;
        }
        return this.elementAt(index_of_named_qualifier);
    }

    public QualifierVector copy() {
        QualifierVector return_vector = new QualifierVector();
        int i = 0;
        while (i < this.size()) {
            return_vector.vector.addElement(this.elementAt(i).copy());
            ++i;
        }
        return return_vector;
    }
}

