/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.GFFEntryInformation;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleDocumentEntry;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class GFFDocumentEntry
extends SimpleDocumentEntry
implements DocumentEntry {
    private boolean finished_constructor = false;

    GFFDocumentEntry(Document document, ReadListener listener) throws IOException, EntryInformationException {
        super((EntryInformation)new GFFEntryInformation(), document, listener);
        this.combineFeatures();
        this.finished_constructor = true;
    }

    public GFFDocumentEntry(Entry new_entry, boolean force) throws EntryInformationException {
        super((EntryInformation)new GFFEntryInformation(), new_entry, force);
        this.finished_constructor = true;
    }

    public GFFDocumentEntry(EntryInformation entry_information) {
        super(new GFFEntryInformation());
        this.finished_constructor = true;
    }

    public boolean isReadOnly() {
        return this.finished_constructor;
    }

    protected SimpleDocumentFeature makeNativeFeature(Feature feature, boolean copy) {
        if (!copy && feature instanceof GFFStreamFeature) {
            return (GFFStreamFeature)feature;
        }
        return new GFFStreamFeature(feature);
    }

    protected StreamSequence makeNativeSequence(Sequence sequence) {
        return new FastaStreamSequence(sequence);
    }

    private void combineFeatures() {
        FeatureVector original_features = this.getAllFeatures();
        Hashtable forward_feature_groups = new Hashtable();
        Hashtable<String, FeatureVector> reverse_feature_groups = new Hashtable<String, FeatureVector>();
        int i = 0;
        while (i < original_features.size()) {
            String group_name;
            Feature this_feature = original_features.elementAt(i);
            Hashtable<String, FeatureVector> this_strand_feature_groups = this_feature.getLocation().isComplement() ? reverse_feature_groups : forward_feature_groups;
            try {
                StringVector values;
                if (this_feature.getQualifierByName("gene") == null) {
                    if (this_feature.getQualifierByName("group") == null) {
                        return;
                    }
                    values = this_feature.getQualifierByName("group").getValues();
                    if (values == null) {
                        throw new Error("internal error - no value for group qualifier");
                    }
                    group_name = values.elementAt(0);
                } else {
                    values = this_feature.getQualifierByName("gene").getValues();
                    if (values == null) {
                        throw new Error("internal error - no value for gene qualifier");
                    }
                    group_name = values.elementAt(0);
                }
            }
            catch (InvalidRelationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            FeatureVector other_features = (FeatureVector)this_strand_feature_groups.get(group_name);
            if (other_features == null) {
                FeatureVector new_feature_vector = new FeatureVector();
                new_feature_vector.add(this_feature);
                this_strand_feature_groups.put(group_name, new_feature_vector);
            } else {
                other_features.add(this_feature);
            }
            ++i;
        }
        this.combineFeaturesFromHash(forward_feature_groups);
        this.combineFeaturesFromHash(reverse_feature_groups);
    }

    private void combineFeaturesFromHash(Hashtable feature_groups) {
        Enumeration _enum = feature_groups.keys();
        while (_enum.hasMoreElements()) {
            String name = (String)_enum.nextElement();
            FeatureVector feature_group = (FeatureVector)feature_groups.get(name);
            if (feature_group.size() <= 1) continue;
            RangeVector new_range_vector = new RangeVector();
            StringVector new_gff_lines = new StringVector();
            int i = 0;
            while (i < feature_group.size()) {
                GFFStreamFeature this_feature = (GFFStreamFeature)feature_group.elementAt(i);
                Location this_feature_location = this_feature.getLocation();
                if (this_feature_location.getRanges().size() > 1) {
                    throw new Error("internal error - new location should have exactly one range");
                }
                Range new_range = this_feature_location.getRanges().elementAt(0);
                if (this_feature_location.isComplement()) {
                    new_range_vector.insertElementAt(new_range, 0);
                } else {
                    new_range_vector.add(new_range);
                }
                this.removeInternal(this_feature);
                new_gff_lines.add(this_feature.gff_lines);
                ++i;
            }
            Feature first_old_feature = feature_group.elementAt(0);
            GFFStreamFeature new_feature = new GFFStreamFeature(first_old_feature);
            new_feature.gff_lines = new_gff_lines;
            Location new_location = new Location(new_range_vector, first_old_feature.getLocation().isComplement());
            try {
                new_feature.setLocation(new_location);
                Qualifier gene_qualifier = new_feature.getQualifierByName("gene");
                if (gene_qualifier != null && gene_qualifier.getValues().size() > 0 && gene_qualifier.getValues().elementAt(0).startsWith("Phat")) {
                    new_feature.removeQualifierByName("codon_start");
                } else {
                    Qualifier old_codon_start_qualifier = first_old_feature.getQualifierByName("codon_start");
                    if (old_codon_start_qualifier != null) {
                        new_feature.setQualifier(old_codon_start_qualifier);
                    }
                }
                this.forcedAdd(new_feature);
            }
            catch (ReadOnlyException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
    }
}

