/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class EmblStreamSequence
extends StreamSequence {
    private String header_line = null;

    public EmblStreamSequence(LinePushBackReader in_stream) throws IOException {
        this.readHeader(in_stream);
        this.readSequence(in_stream);
    }

    public EmblStreamSequence(Sequence sequence) {
        this.setFromString(sequence.toString());
    }

    public EmblStreamSequence(String sequence_string) {
        this.setFromString(sequence_string);
    }

    public StreamSequence copy() {
        return new EmblStreamSequence(this);
    }

    public int getFormatType() {
        return 1;
    }

    protected void readHeader(LinePushBackReader in_stream) throws IOException {
        String seq_header_line = in_stream.readLine();
        this.setHeader(seq_header_line);
    }

    public String getHeader() {
        return this.header_line;
    }

    public void setHeader(String sequence_string) {
        this.header_line = sequence_string;
    }

    protected void readSequence(LinePushBackReader in_stream) throws IOException {
        String line;
        StringBuffer this_line_sequence_buffer = new StringBuffer(81);
        String seq_header_line = this.getHeader();
        int header_base_count = this.getHeaderBaseCount(seq_header_line);
        int buffer_capacity = header_base_count > 50000 ? header_base_count + 100 : 50000;
        StringBuffer sequence_buffer = new StringBuffer(buffer_capacity);
        while ((line = in_stream.readLine()) != null) {
            if (line.startsWith("//") || !line.startsWith("     ")) {
                in_stream.pushBack(line);
                break;
            }
            if (line.length() < 72) {
                throw new ReadFormatException("line too short while reading embl sequence data", in_stream.getLineNumber());
            }
            this_line_sequence_buffer.setLength(0);
            char[] this_line_char_array = line.toCharArray();
            int i = 0;
            while (i < 6) {
                int first_base = 5 + i * 11;
                this_line_sequence_buffer.append(this_line_char_array, first_base, 10);
                ++i;
            }
            String this_line_sequence = this_line_sequence_buffer.toString();
            if (this_line_char_array[59] == ' ') {
                sequence_buffer.append(this_line_sequence.trim().toLowerCase());
                continue;
            }
            sequence_buffer.append(this_line_sequence.toLowerCase());
        }
        this.setFromString(sequence_buffer.toString());
    }

    public synchronized void writeToStream(Writer writer) throws IOException {
        String sequence = this.toString();
        writer.write("SQ   Sequence " + sequence.length() + " BP; " + this.getACount() + " A; " + this.getCCount() + " C; " + this.getGCount() + " G; " + this.getTCount() + " T; " + this.getOtherCount() + " other;\n");
        int line_length_so_far = 0;
        int i = 0;
        while (i < sequence.length()) {
            int this_line_length = sequence.length() - i < 60 ? sequence.length() - i : 60;
            writer.write("    ");
            line_length_so_far += 4;
            int j = 0;
            while (j < this_line_length) {
                writer.write(32);
                int this_block_length = this_line_length - j < 10 ? this_line_length - j : 10;
                writer.write(sequence.substring(i + j, i + j + this_block_length));
                line_length_so_far += this_block_length + 1;
                j += 10;
            }
            int base_count = i + this_line_length;
            String string_base_count = String.valueOf(base_count);
            int count_width = string_base_count.length();
            int char_index = 0;
            while (char_index < 80 - count_width - line_length_so_far) {
                writer.write(32);
                ++char_index;
            }
            writer.write(string_base_count);
            line_length_so_far = 0;
            writer.write("\n");
            i += 60;
        }
    }

    private int getHeaderBaseCount(String line) {
        if (line.startsWith("SQ   Sequence ")) {
            String temp_line = line.substring(14);
            int space_index = temp_line.indexOf(32);
            if (space_index == -1) {
                return -1;
            }
            String count_string = temp_line.substring(0, space_index);
            try {
                return Integer.parseInt(count_string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }
}

