/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolListCharSequence;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class BioJavaSequence
implements Sequence {
    private SymbolList symbols;
    private int aCount;
    private int cCount;
    private int gCount;
    private int tCount;
    private boolean sequenceIsStale = true;

    public BioJavaSequence(SymbolList symbols) {
        this.symbols = symbols;
    }

    public int length() {
        return this.symbols.length();
    }

    public int getACount() {
        if (this.sequenceIsStale) {
            this.countSymbols();
        }
        return this.aCount;
    }

    public int getCCount() {
        if (this.sequenceIsStale) {
            this.countSymbols();
        }
        return this.cCount;
    }

    public int getGCount() {
        if (this.sequenceIsStale) {
            this.countSymbols();
        }
        return this.gCount;
    }

    public int getTCount() {
        if (this.sequenceIsStale) {
            this.countSymbols();
        }
        return this.tCount;
    }

    public int getOtherCount() {
        if (this.sequenceIsStale) {
            this.countSymbols();
        }
        return this.symbols.length() - this.aCount - this.cCount - this.gCount - this.tCount;
    }

    SymbolList getSymbolList() {
        return this.symbols;
    }

    public String getSubSequence(int index1, int index2) {
        String subSeq = "";
        try {
            subSeq = this.symbols.subStr(index1, index2);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("An error occurred while extracting subsequence " + ioe.getMessage());
            ioe.printStackTrace();
        }
        return subSeq;
    }

    public void setFromString(String seqString) throws ReadOnlyException, IllegalSymbolException {
        Edit ed = new Edit(1, this.length(), DNATools.createDNA((String)seqString));
        try {
            this.symbols.edit(ed);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new ReadOnlyException("cannot set sequence - readonly");
        }
        catch (IllegalAlphabetException e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
    }

    private void countSymbols() {
        SymbolListCharSequence slcs = new SymbolListCharSequence(this.symbols);
        int a = 0;
        int c = 0;
        int g = 0;
        int t = 0;
        int i = 0;
        while (i < slcs.length()) {
            char token = slcs.charAt(i);
            switch (token) {
                case 'a': {
                    ++a;
                    break;
                }
                case 'c': {
                    ++c;
                    break;
                }
                case 'g': {
                    ++g;
                    break;
                }
                case 't': {
                    ++t;
                    break;
                }
            }
            ++i;
        }
        this.aCount = a;
        this.cCount = c;
        this.gCount = g;
        this.tCount = t;
        this.sequenceIsStale = false;
    }
}

