/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SmartSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import uk.ac.sanger.artemis.io.BioJavaFeature;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureTable;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamFeatureTable;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class BioJavaEntry
implements DocumentEntry {
    private boolean in_constructor = false;
    private Date lastChangeTime = null;
    private Document document = null;
    private FeatureTable featTable;
    private EntryInformation entryInformation;
    private Sequence artemisSequence;
    private org.biojava.bio.seq.Sequence bioJavaSequence;
    private SequenceFormat sequenceFormat;

    public BioJavaEntry(Document document, SequenceFormat sequenceFormat) throws IOException {
        this(null, document, sequenceFormat);
    }

    public BioJavaEntry(EntryInformation entryInformation, Document document, SequenceFormat sequenceFormat) throws IOException {
        this.entryInformation = entryInformation;
        this.sequenceFormat = sequenceFormat;
        this.document = document;
        this.featTable = new StreamFeatureTable();
        BufferedReader reader = new BufferedReader(document.getLinePushBackReader());
        try {
            EmblProcessor.Factory sFact = new EmblProcessor.Factory(SmartSequenceBuilder.FACTORY);
            FiniteAlphabet alpha = DNATools.getDNA();
            SymbolTokenization rParser = alpha.getTokenization("token");
            EmblLikeFormat eFormat = new EmblLikeFormat();
            StreamReader seqIterator = new StreamReader(reader, (SequenceFormat)eFormat, rParser, (SequenceBuilderFactory)sFact);
            this.bioJavaSequence = seqIterator.nextSequence();
        }
        catch (BioException be) {
            be.printStackTrace();
            throw new IOException("Error reading BioJava sequence: " + (Object)((Object)be));
        }
        this.setArtemisFeatures((FeatureHolder)this.bioJavaSequence);
        this.setArtemisSequence((SymbolList)this.bioJavaSequence);
    }

    public BioJavaEntry(org.biojava.bio.seq.Sequence sequence) {
        this.bioJavaSequence = sequence;
        this.featTable = new StreamFeatureTable();
        this.setArtemisFeatures((FeatureHolder)this.bioJavaSequence);
        this.setArtemisSequence((SymbolList)this.bioJavaSequence);
    }

    public BioJavaEntry(Entry old_entry) {
        Sequence old_sequence = old_entry.getSequence();
        String old_sequence_str = old_sequence.getSubSequence(1, old_sequence.length());
        try {
            this.bioJavaSequence = DNATools.createDNASequence((String)old_sequence_str, (String)"dna");
            this.setArtemisSequence((SymbolList)this.bioJavaSequence);
        }
        catch (IllegalSymbolException e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        FeatureEnumeration feature_enum = old_entry.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature old_feature = feature_enum.nextFeature();
            try {
                this.createFeature(old_feature.getKey(), old_feature.getLocation(), old_feature.getQualifiers());
            }
            catch (ReadOnlyException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
    }

    public String getHeaderText() {
        return null;
    }

    public EntryInformation getEntryInformation() {
        return this.entryInformation;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void save() throws IOException {
        this.save(this.getDocument());
    }

    public void save(Document document) throws IOException {
        PrintStream printStream = new PrintStream(document.getOutputStream());
        this.sequenceFormat.writeSequence(this.bioJavaSequence, printStream);
    }

    public boolean hasUnsavedChanges() {
        return this.lastChangeTime != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean setHeaderText(String newHeader) throws IOException {
        return false;
    }

    public boolean setName(String name) {
        return false;
    }

    public Feature createFeature(Key key, Location location, QualifierVector qualifiers) throws ReadOnlyException, OutOfRangeException {
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.strand = location.isComplement() ? StrandedFeature.NEGATIVE : StrandedFeature.POSITIVE;
        template.annotation = new SimpleAnnotation();
        template.type = key.toString();
        template.location = BioJavaFeature.makeBioJavaLocation(location);
        try {
            org.biojava.bio.seq.Feature bioJavaFeature = this.bioJavaSequence.createFeature((Feature.Template)template);
            BioJavaFeature newFeature = new BioJavaFeature(bioJavaFeature, this);
            this.featTable.add(newFeature);
            this.setDirtyFlag();
            return newFeature;
        }
        catch (ChangeVetoException changeVetoException) {
            throw new ReadOnlyException("feature cannot be created");
        }
        catch (BioException e) {
            throw new ReadOnlyException("BioJava error: " + (Object)((Object)e));
        }
    }

    public Feature add(Feature feature) throws EntryInformationException, ReadOnlyException {
        return this.forcedAdd(feature);
    }

    public Feature forcedAdd(Feature feature) throws ReadOnlyException {
        if (feature.getEntry() != null) {
            throw new Error("internal error - a feature must have one owner");
        }
        try {
            return this.createFeature(feature.getKey(), feature.getLocation(), feature.getQualifiers());
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public boolean remove(Feature feature) throws ReadOnlyException {
        boolean reallyRemoved = this.featTable.contains(feature);
        this.featTable.remove(feature);
        if (reallyRemoved) {
            ((BioJavaFeature)feature).setBioJavaEntry(null);
            try {
                this.bioJavaSequence.removeFeature(((BioJavaFeature)feature).getBioJavaFeature());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("read only - feature cannot be removed");
            }
            catch (BioException bioException) {}
            this.setDirtyFlag();
            return true;
        }
        return false;
    }

    public void setDirtyFlag() {
        if (!this.in_constructor) {
            Calendar calendar = Calendar.getInstance();
            this.lastChangeTime = calendar.getTime();
        }
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    void removeFromTable(BioJavaFeature feature) {
        this.featTable.remove(feature);
    }

    void addToTable(BioJavaFeature feature) {
        this.featTable.add(feature);
    }

    public String getName() {
        return this.bioJavaSequence.getName();
    }

    public int getFeatureCount() {
        return this.featTable.getFeatureCount();
    }

    public Feature getFeatureAtIndex(int index) {
        return this.featTable.getFeatureAtIndex(index);
    }

    public int indexOf(Feature feature) {
        return this.featTable.indexOf(feature);
    }

    public boolean contains(Feature feature) {
        return this.featTable.contains(feature);
    }

    public FeatureEnumeration features() {
        return this.featTable.features();
    }

    public FeatureVector getFeaturesInRange(Range range) throws OutOfRangeException {
        return this.featTable.getFeaturesInRange(range);
    }

    public FeatureVector getAllFeatures() {
        return this.featTable.getAllFeatures();
    }

    public Sequence getSequence() {
        return this.artemisSequence;
    }

    private void setArtemisFeatures(FeatureHolder holder) {
        Iterator fi = holder.features();
        while (fi.hasNext()) {
            org.biojava.bio.seq.Feature f = (org.biojava.bio.seq.Feature)fi.next();
            BioJavaFeature biojavaFeature = new BioJavaFeature(f, this);
            this.featTable.add(biojavaFeature);
        }
    }

    private void setArtemisSequence(SymbolList symbols) {
        this.artemisSequence = new BioJavaSequence(symbols);
    }
}

