/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.sanger.artemis.editor.BigPane;
import uk.ac.sanger.artemis.editor.DataCollectionPane;
import uk.ac.sanger.artemis.editor.FastaListener;
import uk.ac.sanger.artemis.editor.HitInfo;
import uk.ac.sanger.artemis.util.WorkingGZIPInputStream;

public class FastaTextPane
extends JScrollPane {
    private JTextArea textArea;
    private Vector hitInfoCollection = null;
    private String format = null;
    private String dataFile;
    private int qlen;
    private Vector listerners = new Vector();

    public FastaTextPane(String dataFile) {
        this.dataFile = dataFile;
        this.format = this.getResultsFormat();
        StringBuffer contents = null;
        if (this.format.equals("fasta")) {
            contents = this.readFASTAFile(this.format);
        } else if (this.format.equals("blastp")) {
            contents = this.readBLASTPFile(this.format);
        }
        this.textArea = new JTextArea(contents.toString());
        this.setTextAreaFont(BigPane.font);
        this.textArea.setEditable(false);
        this.setViewportView(this.textArea);
        this.setPreferredSize(new Dimension(500, 300));
    }

    protected void addFastaListener(FastaListener obj) {
        this.listerners.add(obj);
    }

    protected void reRead() {
        StringBuffer contents = null;
        this.format = this.getResultsFormat();
        if (this.format.equals("fasta")) {
            contents = this.readFASTAFile(this.format);
        } else if (this.format.equals("blastp")) {
            contents = this.readBLASTPFile(this.format);
        }
        this.textArea.setText(contents.toString());
        this.setViewportView(this.textArea);
        Enumeration enumListeners = this.listerners.elements();
        while (enumListeners.hasMoreElements()) {
            ((FastaListener)enumListeners.nextElement()).update();
        }
    }

    protected String getFormat() {
        return this.format;
    }

    protected void setTextAreaFont(Font f) {
        this.textArea.setFont(f);
    }

    protected InputStream getInputStream() throws IOException {
        FileInputStream inStream = new FileInputStream(this.dataFile);
        if (this.dataFile.endsWith(".gz")) {
            return new WorkingGZIPInputStream(inStream);
        }
        return inStream;
    }

    protected String getResultsFormat() {
        File fn = new File(this.dataFile);
        if (!fn.exists()) {
            this.dataFile = String.valueOf(this.dataFile) + ".gz";
            fn = new File(this.dataFile);
        }
        InputStreamReader streamReader = null;
        BufferedReader buffReader = null;
        String line = null;
        String format = null;
        try {
            streamReader = new InputStreamReader(this.getInputStream());
            buffReader = new BufferedReader(streamReader);
            while ((line = buffReader.readLine()) != null) {
                if (line.startsWith("BLASTP")) {
                    format = "blastp";
                    break;
                }
                if (line.indexOf("FASTA") <= -1) continue;
                format = "fasta";
                break;
            }
            streamReader.close();
            buffReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + fn.getAbsolutePath());
        }
        return format;
    }

    protected StringBuffer readBLASTPFile(String format) {
        new File(this.dataFile);
        StringBuffer sbuff = new StringBuffer();
        InputStreamReader streamReader = null;
        BufferedReader buffReader = null;
        this.hitInfoCollection = new Vector();
        try {
            streamReader = new InputStreamReader(this.getInputStream());
            buffReader = new BufferedReader(streamReader);
            String line = null;
            int textPosition = 0;
            int len = 0;
            HitInfo hit = null;
            int ind1 = 0;
            while ((line = buffReader.readLine()) != null) {
                len = line.length() + 1;
                sbuff.append(String.valueOf(line) + "\n");
                if (line.startsWith("Sequences producing significant alignments:")) {
                    buffReader.readLine();
                    while (!(line = buffReader.readLine()).equals("")) {
                        textPosition += line.length() + 1;
                        sbuff.append(String.valueOf(line) + "\n");
                        hit = new HitInfo(line, format);
                        this.hitInfoCollection.add(hit);
                    }
                } else if (line.startsWith(">")) {
                    int ind2;
                    String currentID = line;
                    int ind = line.indexOf(" ");
                    if (ind > -1) {
                        currentID = line.substring(1, ind);
                    }
                    if ((ind2 = currentID.indexOf(":")) > -1) {
                        currentID = currentID.substring(ind2 + 1);
                    }
                    if (hit != null) {
                        hit.setEndPosition(textPosition);
                    }
                    hit = this.getHitInfo(currentID, this.hitInfoCollection);
                    hit.setStartPosition(textPosition);
                    String going = "";
                    ind = line.indexOf("GO:");
                    if (ind > -1) {
                        going = line.substring(ind + 3);
                    }
                    String nextLine = null;
                    while ((nextLine = buffReader.readLine()).indexOf("Length") == -1) {
                        len += nextLine.length() + 1;
                        sbuff.append(String.valueOf(nextLine) + "\n");
                        if (going.equals("") && (ind = nextLine.indexOf("GO:")) > -1) {
                            going = nextLine.substring(ind + 3);
                            continue;
                        }
                        if (going.equals("")) continue;
                        going = going.concat(nextLine);
                    }
                    if (!going.equals("")) {
                        hit.setGO(going);
                    }
                    if (nextLine != null) {
                        len += nextLine.length() + 1;
                        sbuff.append(String.valueOf(nextLine) + "\n");
                        ind1 = nextLine.indexOf("  Length = ");
                        if (ind1 > -1) {
                            hit.setLength(nextLine.substring(ind1 + 11));
                        }
                    }
                    while (!(nextLine = buffReader.readLine()).startsWith("Query: ")) {
                        len += nextLine.length() + 1;
                        sbuff.append(String.valueOf(nextLine) + "\n");
                    }
                    if (nextLine != null) {
                        len += nextLine.length() + 1;
                        sbuff.append(String.valueOf(nextLine) + "\n");
                        if (nextLine.startsWith("Query:")) {
                            ind1 = nextLine.indexOf(" ", 8);
                            int start = Integer.parseInt(nextLine.substring(7, ind1).trim());
                            hit.setQueryStart(start);
                            hit.setQueryEnd(Integer.parseInt(nextLine.substring(nextLine.lastIndexOf(" ")).trim()));
                        }
                    }
                } else {
                    ind1 = line.indexOf("Identities = ");
                    if (ind1 > -1) {
                        if ((ind1 = line.indexOf("(", ind1) + 1) > -1) {
                            hit.setIdentity(line.substring(ind1, line.indexOf(")", ind1)).trim());
                        }
                    } else {
                        ind1 = line.indexOf("  Length = ");
                        if (ind1 > -1) {
                            hit.setLength(line.substring(ind1 + 11));
                        } else if (line.startsWith("Query: ")) {
                            hit.setQueryEnd(Integer.parseInt(line.substring(line.lastIndexOf(" ")).trim()));
                        } else if (line.startsWith("Query=")) {
                            int ind2 = 0;
                            ind1 = line.indexOf(" letters)");
                            if (ind1 == -1) {
                                String nextLine = null;
                                while ((nextLine = buffReader.readLine()).indexOf(" letters)") < -1) {
                                    len += nextLine.length() + 1;
                                    sbuff.append(String.valueOf(nextLine) + "\n");
                                }
                                line = nextLine;
                                ind1 = nextLine.indexOf(" letters)");
                                ind2 = nextLine.indexOf("(");
                            } else {
                                ind2 = line.indexOf("(");
                            }
                            this.qlen = Integer.parseInt(line.substring(ind2 + 1, ind1).trim());
                        }
                    }
                }
                textPosition += len;
            }
            if (hit != null) {
                hit.setEndPosition(textPosition);
            }
            streamReader.close();
            buffReader.close();
            GetzThread getz = new GetzThread(this.hitInfoCollection);
            getz.start();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + this.dataFile);
        }
        return sbuff;
    }

    protected StringBuffer readFASTAFile(String format) {
        new File(this.dataFile);
        StringBuffer sbuff = new StringBuffer();
        InputStreamReader streamReader = null;
        BufferedReader buffReader = null;
        this.hitInfoCollection = new Vector();
        try {
            streamReader = new InputStreamReader(this.getInputStream());
            buffReader = new BufferedReader(streamReader);
            String line = null;
            int textPosition = 0;
            int len = 0;
            HitInfo hi = null;
            while ((line = buffReader.readLine()) != null) {
                int ind1;
                len = line.length() + 1;
                sbuff.append(String.valueOf(line) + "\n");
                if (line.endsWith(" aa")) {
                    int in1 = line.indexOf(":");
                    int in2 = line.lastIndexOf(" ");
                    if (in1 > -1 && in2 > -1) {
                        this.qlen = Integer.parseInt(line.substring(in1 + 1, in2).trim());
                    }
                } else if (line.startsWith("The best scores are:")) {
                    while (!(line = buffReader.readLine()).equals("")) {
                        textPosition += line.length() + 1;
                        sbuff.append(String.valueOf(line) + "\n");
                        this.hitInfoCollection.add(new HitInfo(line, format));
                    }
                } else if (line.startsWith(">>")) {
                    int ind = line.indexOf(" ");
                    String currentID = line.substring(2, ind);
                    if (hi != null) {
                        hi.setEndPosition(textPosition);
                    }
                    hi = this.getHitInfo(currentID, this.hitInfoCollection);
                    hi.setStartPosition(textPosition);
                } else if (line.startsWith("Smith-Waterman")) {
                    ind1 = line.indexOf("score:");
                    if (ind1 > -1) {
                        int ind2 = line.indexOf(";", ind1);
                        hi.setScore(line.substring(ind1 + 6, ind2));
                        ind1 = ind2 + 1;
                        ind2 = line.indexOf("identity");
                        if (ind2 > -1) {
                            hi.setIdentity(line.substring(ind1, ind2).trim());
                        }
                        if ((ind1 = line.indexOf("(", ind2)) > -1) {
                            ind2 = line.indexOf("ungapped)", ind1);
                            hi.setUngapped(line.substring(ind1 + 1, ind2).trim());
                        }
                        ind1 = line.indexOf(" in ", ind2);
                        ind2 = line.indexOf("(", ind1);
                        if (ind1 > -1 && ind2 > -1) {
                            hi.setOverlap(line.substring(ind1 + 4, ind2).trim());
                        }
                        if ((ind2 = line.indexOf(":", ind1 = ind2 + 1)) > -1) {
                            String range = line.substring(ind1, ind2);
                            hi.setQueryRange(range);
                            int split = range.indexOf("-");
                            if (split > -1) {
                                hi.setQueryStart(Integer.parseInt(range.substring(0, split)));
                                hi.setQueryEnd(Integer.parseInt(range.substring(split + 1)));
                            }
                        }
                        if ((ind2 = line.indexOf(")", ind1 = ind2 + 1)) > -1) {
                            hi.setSubjectRange(line.substring(ind1, ind2));
                        }
                    }
                } else {
                    ind1 = line.indexOf(" E():");
                    if (ind1 > -1) {
                        StringTokenizer tok = new StringTokenizer(line.substring(ind1 + 5));
                        hi.setEValue(tok.nextToken().trim());
                    }
                }
                textPosition += len;
            }
            if (hi != null) {
                hi.setEndPosition(textPosition);
            }
            streamReader.close();
            buffReader.close();
            GetzThread getz = new GetzThread(this.hitInfoCollection);
            getz.start();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file: " + this.dataFile);
        }
        return sbuff;
    }

    protected int getQueryLength() {
        return this.qlen;
    }

    protected Vector getHitCollection() {
        return this.hitInfoCollection;
    }

    protected HitInfo getHitInfo(String ID, Vector hitInfoCollection) {
        Enumeration hitInfo = hitInfoCollection.elements();
        while (hitInfo.hasMoreElements()) {
            HitInfo hi = (HitInfo)hitInfo.nextElement();
            if (!hi.getID().equals(ID)) continue;
            return hi;
        }
        return null;
    }

    public void show(Object obj) {
        if (obj instanceof HitInfo) {
            HitInfo hit = (HitInfo)obj;
            int start = hit.getStartPosition();
            hit.getEndPosition();
            this.textArea.moveCaretPosition(start);
            Point pos = this.getViewport().getViewPosition();
            Dimension rect = this.getViewport().getViewSize();
            double hgt = rect.getHeight() + pos.getY();
            pos.setLocation(pos.getX(), hgt);
            this.getViewport().setViewPosition(pos);
        }
    }

    class GetzThread
    extends Thread {
        private Vector hitInfoCollection;

        protected GetzThread(Vector hitInfoCollection) {
            this.hitInfoCollection = hitInfoCollection;
        }

        public void run() {
            DataCollectionPane.getzCall(this.hitInfoCollection, this.hitInfoCollection.size());
        }
    }
}

