/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ExternalApplication {
    private Process p;
    private StringBuffer stdout = new StringBuffer();
    private StringBuffer stderr = new StringBuffer();
    private File project;
    private String status;
    private StdoutHandler stdouth;
    private StderrHandler stderrh;

    public ExternalApplication(String[] cmd, String[] envp, File project) {
        this.project = project;
        this.status = "0";
        Runtime cmdRun = Runtime.getRuntime();
        try {
            this.p = cmdRun.exec(cmd, envp, project);
            this.stdouth = new StdoutHandler(this);
            this.stderrh = new StderrHandler(this);
            this.stdouth.start();
            this.stderrh.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("ExternalApplication Error executing: " + cmd);
            this.status = "1";
        }
    }

    private void readProcessStderr() {
        BufferedInputStream stderrStream = null;
        BufferedReader stderrRead = null;
        try {
            try {
                stderrStream = new BufferedInputStream(this.p.getErrorStream());
                stderrRead = new BufferedReader(new InputStreamReader(stderrStream));
                char[] c = new char[100];
                int nc = 0;
                while ((nc = stderrRead.read(c, 0, 100)) != -1) {
                    this.stderr = this.stderr.append(new String(c, 0, nc));
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error in collecting standard out");
            }
        }
        catch (Throwable throwable) {
            try {
                if (stderrStream != null) {
                    stderrStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error closing stream");
            }
            try {
                if (stderrRead != null) {
                    stderrRead.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error closing reader");
            }
            throw throwable;
        }
        try {
            if (stderrStream != null) {
                stderrStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("ExternalApplication: Error closing stream");
        }
        try {
            if (stderrRead != null) {
                stderrRead.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("ExternalApplication: Error closing reader");
        }
    }

    private void readProcessStdout() {
        BufferedInputStream stdoutStream = null;
        BufferedReader stdoutRead = null;
        try {
            try {
                stdoutStream = new BufferedInputStream(this.p.getInputStream());
                stdoutRead = new BufferedReader(new InputStreamReader(stdoutStream));
                char[] c = new char[100];
                int nc = 0;
                while ((nc = stdoutRead.read(c, 0, 100)) != -1) {
                    String chunk = new String(c, 0, nc);
                    this.stdout = this.stdout.append(chunk);
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error in collecting standard out");
            }
        }
        catch (Throwable throwable) {
            try {
                if (stdoutStream != null) {
                    stdoutStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error closing stream");
            }
            try {
                if (stdoutRead != null) {
                    stdoutRead.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("ExternalApplication: Error closing reader");
            }
            throw throwable;
        }
        try {
            if (stdoutStream != null) {
                stdoutStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("ExternalApplication: Error closing stream");
        }
        try {
            if (stdoutRead != null) {
                stdoutRead.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("ExternalApplication: Error closing reader");
        }
    }

    public String getProcessStdout() {
        try {
            while (this.stdouth.isAlive()) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return new String(this.stdout.toString().trim());
    }

    public String getProcessStderr() {
        try {
            while (this.stderrh.isAlive()) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return new String(this.stderr.toString().trim());
    }

    public int waitFor() {
        try {
            return this.p.waitFor();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return -1;
        }
    }

    public Process getProcess() {
        return this.p;
    }

    public String getStatus() {
        return this.status;
    }

    class StdoutHandler
    extends Thread {
        ExternalApplication rea;

        protected StdoutHandler(ExternalApplication rea) {
            this.rea = rea;
        }

        public void run() {
            this.rea.readProcessStdout();
        }
    }

    class StderrHandler
    extends Thread {
        ExternalApplication rea;

        protected StderrHandler(ExternalApplication rea) {
            this.rea = rea;
        }

        public void run() {
            this.rea.readProcessStderr();
        }
    }
}

