/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.FontUIResource;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.Logger;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.LogViewer;
import uk.ac.sanger.artemis.components.Utilities;
import uk.ac.sanger.artemis.util.InputStreamProgressEvent;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

public abstract class Splash
extends JFrame {
    private final JLabel status_line = new JLabel("");
    private String program_name;
    private String program_version;
    private JComponent helix_canvas;
    private JMenuBar menu_bar;
    protected JMenu file_menu;
    protected JMenu options_menu;
    private static final LogViewer logger = new LogViewer();
    private final InputStreamProgressListener stream_progress_listener = new InputStreamProgressListener(){

        public void progressMade(InputStreamProgressEvent event) {
            int char_count = event.getCharCount();
            if (char_count == -1) {
                Splash.this.getStatusLabel().setText("");
            } else {
                Splash.this.getStatusLabel().setText("chars read so far: " + char_count);
            }
        }
    };

    protected abstract void exit();

    public Splash(String program_name, String program_title, String program_version) {
        super(String.valueOf(program_title) + " " + program_version);
        this.program_name = program_name;
        this.program_version = program_version;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Splash.this.exit();
            }
        });
        UIManager.getLookAndFeel();
        FontUIResource font_ui_resource = Options.getOptions().getFontUIResource();
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font_ui_resource);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.makeAllMenus();
        this.helix_canvas = this.makeHelixCanvas();
        this.status_line.setFont(Options.getOptions().getFont());
        FontMetrics fm = this.getFontMetrics(this.status_line.getFont());
        int font_height = fm.getHeight() + 10;
        this.status_line.setMinimumSize(new Dimension(100, font_height));
        this.status_line.setPreferredSize(new Dimension(100, font_height));
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.status_line.setBorder(compound);
        this.getContentPane().add((Component)this.helix_canvas, "Center");
        this.getContentPane().add((Component)this.status_line, "South");
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon icon = new ImageIcon(cl.getResource("images/icon.gif"));
        if (icon != null) {
            Image icon_image = icon.getImage();
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(icon_image, 0);
            try {
                tracker.waitForAll();
                this.setIconImage(icon_image);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pack();
        this.setSize(460, 250);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    private JComponent makeHelixCanvas() {
        return new JPanel(){
            MediaTracker tracker = null;
            private Image helix = null;
            private Image sanger = null;
            private int sanger_height;
            private int helix_height;
            private int helix_width;

            public void update(Graphics g) {
                this.paint(g);
            }

            private String getNameString() {
                if (Options.getOptions().isEukaryoticMode()) {
                    return String.valueOf(Splash.this.program_name) + "  [Eukaryotic mode]";
                }
                return String.valueOf(Splash.this.program_name) + "  [Prokaryotic mode]";
            }

            public int textPaint(Graphics g) {
                FontMetrics fm = this.getFontMetrics(g.getFont());
                int font_height = fm.getHeight() + 3;
                g.setColor(Color.black);
                g.drawString(Splash.this.program_name, this.helix_width + 5, font_height);
                g.drawString(Splash.this.program_version, this.helix_width + 5, font_height * 2);
                if (Options.getOptions().isEukaryoticMode()) {
                    g.drawString("[Eukaryotic mode]", this.helix_width + 5, font_height * 3);
                } else {
                    g.drawString("[Prokaryotic mode]", this.helix_width + 5, font_height * 3);
                }
                g.drawString("Copyright 1998 - 2003", this.helix_width + 5, font_height * 9 / 2);
                g.drawString("Genome Research Limited", this.helix_width + 5, font_height * 11 / 2);
                return font_height;
            }

            public void paint(Graphics g) {
                boolean simple_splash_screen = Options.getOptions().getPropertyTruthValue("simple_splash_screen");
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                if (simple_splash_screen) {
                    this.textPaint(g);
                    return;
                }
                if (this.helix == null) {
                    ClassLoader cl = this.getClass().getClassLoader();
                    ImageIcon helix_icon = new ImageIcon(cl.getResource("images/helix.gif"));
                    this.helix = helix_icon.getImage();
                    ImageIcon sanger_icon = new ImageIcon(cl.getResource("images/sanger-centre.gif"));
                    this.sanger = sanger_icon.getImage();
                    this.tracker = new MediaTracker(this);
                    this.tracker.addImage(this.helix, 0);
                    this.tracker.addImage(this.sanger, 1);
                    try {
                        this.tracker.waitForAll();
                        this.helix_height = this.helix.getHeight(this);
                        this.helix_width = this.helix.getWidth(this);
                        this.sanger_height = this.sanger.getHeight(this);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                int i = 0;
                while (i * this.helix_height <= this.getSize().height) {
                    g.drawImage(this.helix, 0, i * this.helix_height, this);
                    ++i;
                }
                int sanger_position = this.getSize().height - this.sanger_height;
                int font_height = this.textPaint(g);
                if ((double)sanger_position > (double)font_height * 5.5) {
                    g.drawImage(this.sanger, this.helix_width + 5, sanger_position, this);
                }
            }
        };
    }

    public JLabel getStatusLabel() {
        return this.status_line;
    }

    public EntrySourceVector getEntrySources(JFrame frame) {
        return Utilities.getEntrySources(frame, this.stream_progress_listener);
    }

    public InputStreamProgressListener getInputStreamProgressListener() {
        return this.stream_progress_listener;
    }

    private void resetOptions() {
        Options.getOptions().reset();
    }

    private void makeAllMenus() {
        this.menu_bar = new JMenuBar();
        this.file_menu = new JMenu("File");
        this.options_menu = new JMenu("Options");
        this.menu_bar.add(this.file_menu);
        this.menu_bar.add(this.options_menu);
        this.setJMenuBar(this.menu_bar);
        ActionListener menu_listener = null;
        menu_listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Splash.this.resetOptions();
            }
        };
        Splash.makeMenuItem(this.options_menu, "Re-read Options", menu_listener);
        final JCheckBoxMenuItem enable_direct_edit_item = new JCheckBoxMenuItem("Enable Direct Editing");
        enable_direct_edit_item.setState(Options.getOptions().canDirectEdit());
        enable_direct_edit_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                boolean item_state = enable_direct_edit_item.getState();
                Options.getOptions().setDirectEdit(item_state);
            }
        });
        this.options_menu.add(enable_direct_edit_item);
        final JCheckBoxMenuItem enable_euk_mode_item = new JCheckBoxMenuItem("Eukaryotic Mode");
        enable_euk_mode_item.setState(Options.getOptions().isEukaryoticMode());
        enable_euk_mode_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                boolean item_state = enable_euk_mode_item.getState();
                Options.getOptions().setEukaryoticMode(item_state);
                Splash.this.helix_canvas.repaint();
            }
        });
        this.options_menu.add(enable_euk_mode_item);
        final JCheckBoxMenuItem highlight_active_entry_item = new JCheckBoxMenuItem("Highlight Active Entry");
        boolean highlight_active_entry_state = Options.getOptions().highlightActiveEntryFlag();
        highlight_active_entry_item.setState(highlight_active_entry_state);
        highlight_active_entry_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                boolean item_state = highlight_active_entry_item.getState();
                Options.getOptions().setHighlightActiveEntryFlag(item_state);
            }
        });
        this.options_menu.add(highlight_active_entry_item);
        if (Options.getOptions().getPropertyTruthValue("sanger_options") && Options.getOptions().getProperty("black_belt_mode") != null) {
            final JCheckBoxMenuItem black_belt_mode_item = new JCheckBoxMenuItem("Black Belt Mode");
            Options.getOptions();
            boolean state = Options.isBlackBeltMode();
            black_belt_mode_item.setState(state);
            black_belt_mode_item.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    boolean item_state = black_belt_mode_item.getState();
                    if (item_state) {
                        Options.getOptions().put("black_belt_mode", "true");
                    } else {
                        Options.getOptions().put("black_belt_mode", "false");
                    }
                }
            });
            this.options_menu.add(black_belt_mode_item);
        }
        if (Options.isUnixHost()) {
            this.options_menu.addSeparator();
            menu_listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Splash.showLog();
                }
            };
            Splash.makeMenuItem(this.options_menu, "Show Log Window", menu_listener);
            menu_listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    logger.setVisible(false);
                }
            };
            Splash.makeMenuItem(this.options_menu, "Hide Log Window", menu_listener);
        }
    }

    protected static void makeMenuItem(JMenu menu, String name, ActionListener listener) {
        JMenuItem new_item = new JMenuItem(name);
        menu.add(new_item);
        new_item.addActionListener(listener);
        if (name.equals("Open ...")) {
            new_item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public JComponent getCanvas() {
        return this.helix_canvas;
    }

    public static void showLog() {
        logger.setVisible(true);
    }
}

