/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import javax.swing.JComboBox;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.util.StringVector;

public class QualifierChoice
extends JComboBox {
    private Key key = null;
    private String default_qualifier = null;
    private EntryInformation entry_information;

    public QualifierChoice(EntryInformation entry_information, Key key, String default_qualifier) {
        this.entry_information = entry_information;
        this.key = key;
        this.default_qualifier = default_qualifier != null && entry_information.isValidQualifier(key, default_qualifier) ? default_qualifier : null;
        this.setMaximumRowCount(30);
        this.setEditable(true);
        this.update();
    }

    public void setKey(Key key) {
        if (this.key != key) {
            this.key = key;
            this.update();
        }
    }

    private void setSelectedQualifierByName(String qualifier_name) {
        int index = this.indexOf(qualifier_name);
        if (index == -1) {
            this.addItem(qualifier_name);
            this.setSelectedItem(qualifier_name);
        } else {
            this.setSelectedIndex(index);
        }
    }

    private int indexOf(String qualifier_name) {
        int i = 0;
        while (i < this.getItemCount()) {
            if (this.getItemAt(i).equals(qualifier_name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void update() {
        this.removeAllItems();
        StringVector qualifier_names = this.entry_information.getValidQualifierNames(this.key);
        if (qualifier_names == null) {
            qualifier_names = new StringVector("note");
        }
        if (this.default_qualifier != null && !qualifier_names.contains(this.default_qualifier)) {
            qualifier_names.add(this.default_qualifier);
        }
        qualifier_names.sort();
        int i = 0;
        while (i < qualifier_names.size()) {
            String qualifier_name = qualifier_names.elementAt(i);
            this.addItem(qualifier_name);
            ++i;
        }
        if (this.default_qualifier == null) {
            if (this.indexOf("note") != -1) {
                this.setSelectedQualifierByName("note");
            } else if (this.indexOf("locus_tag") != -1) {
                this.setSelectedQualifierByName("locus_tag");
            } else {
                this.setSelectedIndex(0);
            }
        } else {
            this.setSelectedQualifierByName(this.default_qualifier);
        }
    }
}

