/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.components.KeyChoice;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;

public class KeyChooser
extends JFrame {
    private KeyChoice key_choice;
    private final JButton ok_button = new JButton("OK");
    private final JButton close_button = new JButton("Cancel");

    public KeyChooser(EntryInformation entry_information) {
        this(entry_information, Key.CDS);
    }

    public KeyChooser(EntryInformation entry_information, Key default_key) {
        this.key_choice = new KeyChoice(entry_information, default_key);
        this.getContentPane().add((Component)this.key_choice, "Center");
        JPanel panel = new JPanel();
        panel.add(this.ok_button);
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KeyChooser.this.dispose();
            }
        });
        panel.add(this.close_button);
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KeyChooser.this.dispose();
            }
        });
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                KeyChooser.this.dispose();
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    public KeyChoice getKeyChoice() {
        return this.key_choice;
    }

    public JButton getOKButton() {
        return this.ok_button;
    }
}

