/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.util.InputStreamProgressEvent;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

public class InputStreamProgressDialog
extends JDialog {
    private InputStreamProgressListener stream_progress_listener = null;
    private final JButton ok_button = new JButton("OK");

    public InputStreamProgressDialog(JFrame parent, String message) {
        this(parent, message, message, true);
    }

    public InputStreamProgressDialog(JFrame parent_frame, String title, String message, boolean modal) {
        super(parent_frame, title, modal);
        this.getContentPane().add((Component)new JLabel(message), "North");
        final JLabel bytes_label = new JLabel("                               ");
        this.getContentPane().add((Component)bytes_label, "Center");
        JPanel panel = new JPanel();
        panel.add(this.ok_button);
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputStreamProgressDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                InputStreamProgressDialog.this.dispose();
            }
        });
        this.stream_progress_listener = new InputStreamProgressListener(){

            public void progressMade(InputStreamProgressEvent event) {
                int char_count = event.getCharCount();
                if (char_count == -1) {
                    bytes_label.setText("");
                } else {
                    InputStreamProgressDialog.this.setVisible(true);
                    bytes_label.setText("Characters read so far: " + char_count);
                }
            }
        };
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        this.setVisible(false);
    }

    public InputStreamProgressListener getInputStreamProgressListener() {
        return this.stream_progress_listener;
    }
}

