/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import javax.swing.JFrame;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.EntryFileDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class FileDialogEntrySource
implements EntrySource {
    final JFrame frame;
    private final InputStreamProgressListener stream_progress_listener;

    public FileDialogEntrySource(JFrame frame, InputStreamProgressListener listener) {
        this.frame = frame;
        this.stream_progress_listener = listener;
    }

    public Entry getEntry(Bases bases, ProgressThread progress_thread, boolean show_progress) throws OutOfRangeException {
        try {
            return this.getEntryInternal(bases, progress_thread, show_progress);
        }
        catch (NoSequenceException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Entry getEntry(Bases bases, boolean show_progress) throws OutOfRangeException {
        try {
            return this.getEntryInternal(bases, null, show_progress);
        }
        catch (NoSequenceException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Entry getEntry(boolean show_progress) throws OutOfRangeException, NoSequenceException {
        return this.getEntryInternal(null, null, show_progress);
    }

    public Entry getEntry(boolean show_progress, ProgressThread progress_thread) throws OutOfRangeException, NoSequenceException {
        return this.getEntryInternal(null, progress_thread, show_progress);
    }

    public boolean isFullEntrySource() {
        return false;
    }

    private Entry makeEntry(Bases bases, uk.ac.sanger.artemis.io.Entry embl_entry) throws OutOfRangeException, NoSequenceException {
        if (bases == null) {
            return new Entry(embl_entry);
        }
        return new Entry(bases, embl_entry);
    }

    public InputStreamProgressListener getInputStreamProgressListener() {
        return this.stream_progress_listener;
    }

    public String getSourceName() {
        return "Filesystem";
    }

    private Entry getEntryInternal(Bases bases, ProgressThread progress_thread, boolean show_progress) throws OutOfRangeException, NoSequenceException {
        SimpleEntryInformation new_entry_information;
        EntryFileDialog dialog = bases == null ? new EntryFileDialog(this.frame, true) : new EntryFileDialog(this.frame, false);
        uk.ac.sanger.artemis.io.Entry new_embl_entry = dialog.getEntry(new_entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation()), this.stream_progress_listener, progress_thread, show_progress);
        if (new_embl_entry == null) {
            return null;
        }
        return this.makeEntry(bases, new_embl_entry);
    }
}

