/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeEvent;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.components.Plot;
import uk.ac.sanger.artemis.components.PlotMouseListener;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class BasePlot
extends Plot
implements DisplayAdjustmentListener,
SelectionChangeListener {
    private static final int HEIGHT;
    private float[][] value_array_array = null;
    private int step_size = 0;
    private float min_value = Float.MAX_VALUE;
    private float max_value = Float.MIN_VALUE;
    private int start_base;
    private int end_base;
    private int width_in_bases;
    private boolean rev_comp_display;
    private Bases bases;
    private Marker selection_start_marker = null;
    private Marker selection_end_marker = null;
    private Selection selection;
    private GotoEventSource goto_event_source;

    static {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Integer base_plot_height = Options.getOptions().getIntegerProperty("base_plot_height");
        HEIGHT = base_plot_height == null ? (screen.height <= 600 ? 100 : 150) : base_plot_height;
    }

    public BasePlot(BaseAlgorithm algorithm, Selection selection, GotoEventSource goto_event_source) {
        super(algorithm, false);
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        this.bases = this.getBaseAlgorithm().getBases();
        this.getSelection().addSelectionChangeListener(this);
        this.addPlotMouseListener(new PlotMouseListener(){

            private void setSelectionRange(int start_base, int end_base) {
                Strand strand = BasePlot.this.bases.getForwardStrand();
                try {
                    MarkerRange marker_range = strand.makeMarkerRangeFromPositions(start_base, end_base);
                    BasePlot.this.getSelection().setMarkerRange(marker_range);
                }
                catch (OutOfRangeException outOfRangeException) {
                    BasePlot.this.getSelection().clear();
                }
            }

            public void mouseClick(int position) {
            }

            public void mouseDrag(int drag_start_position, int current_position) {
                if (BasePlot.this.rev_comp_display) {
                    drag_start_position = BasePlot.this.bases.getComplementPosition(drag_start_position);
                    current_position = BasePlot.this.bases.getComplementPosition(current_position);
                }
                this.setSelectionRange(drag_start_position, current_position);
            }

            public void mouseDoubleClick(int position) {
                if (BasePlot.this.rev_comp_display) {
                    position = BasePlot.this.bases.getComplementPosition(position);
                }
                this.setSelectionRange(position, position);
                BasePlot.this.getGotoEventSource().gotoBase(position);
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, HEIGHT);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, HEIGHT);
    }

    public void displayAdjustmentValueChanged(DisplayAdjustmentEvent event) {
        this.start_base = event.getStart();
        this.end_base = event.getEnd();
        this.width_in_bases = event.getWidthInBases();
        this.rev_comp_display = event.isRevCompDisplay();
        this.recalculate_flag = true;
        if (event.getType() == 3) {
            this.selection_start_marker = null;
            this.selection_end_marker = null;
        }
        this.repaintCanvas();
    }

    public void selectionChanged(SelectionChangeEvent event) {
        this.selection_start_marker = null;
        this.selection_end_marker = null;
        this.repaintCanvas();
    }

    public BaseAlgorithm getBaseAlgorithm() {
        return (BaseAlgorithm)super.getAlgorithm();
    }

    private int getStart() {
        return this.start_base;
    }

    private int getEnd() {
        return this.end_base;
    }

    private int getWidthInBases() {
        return this.width_in_bases;
    }

    protected void recalculateValues() {
        int unit_count;
        int number_of_values;
        Float algorithm_minimum = this.getAlgorithm().getMinimum();
        Float algorithm_maximum = this.getAlgorithm().getMaximum();
        this.max_value = algorithm_maximum == null ? Float.MIN_VALUE : algorithm_maximum.floatValue();
        this.min_value = algorithm_minimum == null ? Float.MAX_VALUE : algorithm_minimum.floatValue();
        int window_size = this.getWindowSize();
        Integer default_step_size = this.getAlgorithm().getDefaultStepSize(window_size);
        this.step_size = default_step_size == null ? 1 : (default_step_size < window_size ? default_step_size : window_size);
        int real_start = this.getStart();
        if (real_start < 1) {
            real_start = 1;
        }
        if ((number_of_values = ((unit_count = this.getEnd() - real_start) - (window_size - this.step_size)) / this.step_size) < 2) {
            this.value_array_array = null;
            return;
        }
        this.getBaseAlgorithm().setRevCompDisplay(this.rev_comp_display);
        int get_values_return_count = this.getBaseAlgorithm().getValueCount();
        if (this.value_array_array == null) {
            this.value_array_array = new float[get_values_return_count][];
        }
        if (this.value_array_array[0] == null || this.value_array_array[0].length != number_of_values) {
            int i = 0;
            while (i < this.value_array_array.length) {
                this.value_array_array[i] = new float[number_of_values];
                ++i;
            }
        }
        float[] temp_values = new float[get_values_return_count];
        int i = 0;
        while (i < number_of_values) {
            this.getBaseAlgorithm().getValues(real_start + i * this.step_size, real_start + i * this.step_size + window_size - 1, temp_values);
            int value_index = 0;
            while (value_index < get_values_return_count) {
                float current_value;
                this.value_array_array[value_index][i] = current_value = temp_values[value_index];
                if (algorithm_maximum == null && current_value > this.max_value) {
                    this.max_value = current_value;
                }
                if (algorithm_minimum == null && current_value < this.min_value) {
                    this.min_value = current_value;
                }
                ++value_index;
            }
            ++i;
        }
        this.recalculate_flag = false;
    }

    public void drawMultiValueGraph(Graphics g) {
        int cross_hair_position;
        int selection_base;
        if (this.recalculate_flag) {
            this.recalculateValues();
        }
        if (this.value_array_array == null) {
            this.drawMinMax(g, 0.0f, 1.0f);
            return;
        }
        int window_size = this.getWindowSize();
        int get_values_return_count = this.getBaseAlgorithm().getValueCount();
        int number_of_values = this.value_array_array[0].length;
        if (number_of_values > 1) {
            this.drawGlobalAverage(g, this.min_value, this.max_value);
        }
        int value_index = 0;
        while (value_index < get_values_return_count) {
            if (get_values_return_count == 1) {
                g.setColor(Color.black);
            } else {
                switch (value_index) {
                    case 0: {
                        g.setColor(new Color(255, 0, 0));
                        break;
                    }
                    case 1: {
                        g.setColor(new Color(0, 200, 0));
                        break;
                    }
                    case 2: {
                        g.setColor(new Color(0, 0, 255));
                        break;
                    }
                    default: {
                        g.setColor(Color.black);
                    }
                }
            }
            int offset = this.getStart() < 1 ? 1 - this.getStart() : 0;
            this.drawPoints(g, this.min_value, this.max_value, this.step_size, window_size, this.getWidthInBases(), offset, this.value_array_array[value_index]);
            ++value_index;
        }
        this.drawMinMax(g, this.min_value, this.max_value);
        if (this.getCrossHairPosition() >= 0 && (selection_base = this.getPointPosition(cross_hair_position = this.getCrossHairPosition())) >= 1) {
            if (selection_base > this.end_base) {
                this.cancelCrossHairs();
            } else {
                String label_string = this.rev_comp_display ? String.valueOf(this.bases.getLength() - selection_base + 1) : String.valueOf(selection_base);
                this.drawCrossHair(g, cross_hair_position, label_string, 0);
            }
        }
        if (this.getCrossHairPosition() >= 0 && this.getSelectionStartMarker() != null) {
            int selection_first_base = this.getSelectionStartMarker().getRawPosition();
            String label_string = this.rev_comp_display ? String.valueOf(this.bases.getLength() - selection_first_base + 1) : String.valueOf(selection_first_base);
            if (Math.abs(selection_first_base - this.getPointPosition(this.getCrossHairPosition())) > 3) {
                this.drawCrossHair(g, this.getCanvasPosition(selection_first_base), label_string, 1);
            }
        }
        if (this.getCrossHairPosition() >= 0 && this.getSelectionEndMarker() != null && this.getSelectionStartMarker() != null && Math.abs(this.getSelectionEndMarker().getRawPosition() - this.getSelectionStartMarker().getRawPosition()) >= 3) {
            int selection_last_base = this.getSelectionEndMarker().getRawPosition();
            String label_string = this.rev_comp_display ? String.valueOf(this.bases.getLength() - selection_last_base + 1) : String.valueOf(selection_last_base);
            if (Math.abs(selection_last_base - this.getPointPosition(this.getCrossHairPosition())) > 3) {
                this.drawCrossHair(g, this.getCanvasPosition(selection_last_base), label_string, 2);
            }
        }
    }

    protected int getPointPosition(int canvas_x_position) {
        return (int)(1.0 * (double)canvas_x_position / (double)this.getCanvas().getSize().width * (double)this.getWidthInBases()) + this.getStart();
    }

    private int getCanvasPosition(int base) {
        return (int)((1.0 * (double)base - (double)this.getStart()) / (double)this.getWidthInBases() * (double)this.getCanvas().getSize().width);
    }

    private Marker getSelectionStartMarker() {
        if (this.selection_start_marker == null) {
            this.selection_start_marker = this.getSelection().getLowestBaseOfSelection();
            if (this.selection_start_marker != null && this.rev_comp_display) {
                Strand strand = this.bases.getReverseStrand();
                int orig_position = this.selection_start_marker.getRawPosition();
                this.bases.getComplementPosition(orig_position);
                try {
                    this.selection_start_marker = strand.makeMarker(orig_position);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
        }
        return this.selection_start_marker;
    }

    private Marker getSelectionEndMarker() {
        if (this.selection_end_marker == null) {
            this.selection_end_marker = this.getSelection().getHighestBaseOfSelection();
            if (this.selection_end_marker != null && this.rev_comp_display) {
                Strand strand = this.bases.getReverseStrand();
                int orig_position = this.selection_end_marker.getRawPosition();
                this.bases.getComplementPosition(orig_position);
                try {
                    this.selection_end_marker = strand.makeMarker(orig_position);
                }
                catch (OutOfRangeException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
        }
        return this.selection_end_marker;
    }

    private Selection getSelection() {
        return this.selection;
    }

    private GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }
}

