/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.ac.sanger.artemis.ChangeEvent;
import uk.ac.sanger.artemis.ChangeListener;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selectable;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentEntryFactory;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class Entry
implements FeatureChangeListener,
Selectable {
    private uk.ac.sanger.artemis.io.Entry embl_entry;
    private final Vector entry_listener_list = new Vector();
    private final Vector feature_listener_list = new Vector();
    private Bases bases;

    public Entry(Bases bases, uk.ac.sanger.artemis.io.Entry embl_entry) throws OutOfRangeException {
        this.embl_entry = embl_entry;
        this.bases = bases;
        this.checkLocations();
        this.createDianaFeatures();
    }

    public Entry(uk.ac.sanger.artemis.io.Entry embl_entry) throws OutOfRangeException, NoSequenceException {
        this.embl_entry = embl_entry;
        if (embl_entry.getSequence() == null || embl_entry.getSequence().length() == 0) {
            throw new NoSequenceException();
        }
        this.bases = new Bases(embl_entry.getSequence());
        this.checkLocations();
        this.createDianaFeatures();
    }

    public boolean isReadOnly() {
        return this.getEMBLEntry().isReadOnly();
    }

    public void save(int destination_type) throws IOException, EntryInformationException {
        if (destination_type == 0) {
            this.getEMBLEntry().save();
        } else if (this.getEMBLEntry() instanceof DocumentEntry) {
            this.getEMBLEntryAsNewType(this.getEntryInformation(), destination_type, false).save();
        } else {
            throw new ReadOnlyException("operation cannot be applied to this entry");
        }
    }

    public void saveStandardOnly(int destination_type) throws IOException, EntryInformationException {
        if (destination_type == 0) {
            this.getEMBLEntry().save();
        } else if (this.getEMBLEntry() instanceof DocumentEntry) {
            EntryInformation entry_information = Options.getDBEntryInformation();
            this.getEMBLEntryAsNewType(entry_information, destination_type, false).save();
        } else {
            throw new ReadOnlyException("operation cannot be applied to this entry");
        }
    }

    public void save(File file, int destination_type, boolean force) throws IOException, EntryInformationException {
        FileDocument file_document = new FileDocument(file);
        DocumentEntry document_entry = (DocumentEntry)this.getEMBLEntryAsNewType(this.getEntryInformation(), destination_type, force);
        document_entry.save(file_document);
    }

    public void saveStandardOnly(File file, int destination_type, boolean force) throws IOException, EntryInformationException {
        FileDocument file_document = new FileDocument(file);
        DocumentEntry document_entry = (DocumentEntry)this.getEMBLEntryAsNewType(Options.getDBEntryInformation(), destination_type, force);
        document_entry.save(file_document);
    }

    public boolean hasUnsavedChanges() {
        return this.getEMBLEntry().hasUnsavedChanges();
    }

    public static Entry newEntry(Bases bases) {
        EmblDocumentEntry entry = new EmblDocumentEntry(Options.getArtemisEntryInformation());
        try {
            return new Entry(bases, entry);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public String getName() {
        return this.getEMBLEntry().getName();
    }

    public boolean setName(String name) {
        String orig_entry_name = this.getName();
        if (this.getEMBLEntry().setName(name)) {
            if (orig_entry_name == null || !name.equals(orig_entry_name)) {
                EntryChangeEvent event = new EntryChangeEvent(name, this, 3);
                this.fireAction(this.entry_listener_list, event);
            }
            return true;
        }
        return false;
    }

    public String getHeaderText() {
        return this.getEMBLEntry().getHeaderText();
    }

    public boolean setHeaderText(String new_header) throws IOException {
        if (this.getEMBLEntry().setHeaderText(new_header)) {
            EntryChangeEvent event = new EntryChangeEvent(new_header, this, 4);
            this.fireAction(this.entry_listener_list, event);
            return true;
        }
        return false;
    }

    public Document getRootDocument() {
        if (this.getEMBLEntry() instanceof DocumentEntry && ((DocumentEntry)this.getEMBLEntry()).getDocument() != null) {
            return ((DocumentEntry)this.getEMBLEntry()).getDocument().getParent();
        }
        return null;
    }

    public FeatureVector getFeaturesInRange(Range range) throws OutOfRangeException {
        FeatureVector return_features = new FeatureVector();
        uk.ac.sanger.artemis.io.FeatureVector embl_features = this.getEMBLEntry().getFeaturesInRange(range);
        int i = 0;
        while (i < embl_features.size()) {
            Feature diana_feature = this.getFeatureOf(embl_features.elementAt(i));
            return_features.add(diana_feature);
            ++i;
        }
        return return_features;
    }

    public FeatureVector getAllFeatures() {
        FeatureVector return_features = new FeatureVector();
        uk.ac.sanger.artemis.io.FeatureVector embl_features = this.getEMBLEntry().getAllFeatures();
        int i = 0;
        while (i < embl_features.size()) {
            Feature diana_feature = this.getFeatureOf(embl_features.elementAt(i));
            return_features.add(diana_feature);
            ++i;
        }
        return return_features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Feature feature) throws ReadOnlyException {
        Bases bases = this.getBases();
        synchronized (bases) {
            if (!this.getEMBLEntry().remove(feature.getEmblFeature())) {
                throw new Error("internal error - remove failed");
            }
            EntryChangeEvent event = new EntryChangeEvent(this, feature, 1);
            this.fireAction(this.entry_listener_list, event);
            feature.setEntry(null);
        }
    }

    public void removeAllFeatures() throws ReadOnlyException {
        while (this.getFeatureCount() > 0) {
            this.remove(this.getFeature(0));
        }
    }

    public void add(Feature new_feature, boolean force) throws EntryInformationException, OutOfRangeException, ReadOnlyException {
        try {
            if (new_feature.getEntry() != null) {
                throw new Error("internal error - Feature has a parent");
            }
            new_feature.setEntry(this);
            uk.ac.sanger.artemis.io.Feature old_embl_reference = new_feature.getEmblFeature();
            uk.ac.sanger.artemis.io.Feature new_embl_reference = force ? this.getEMBLEntry().forcedAdd(new_feature.getEmblFeature()) : this.getEMBLEntry().add(new_feature.getEmblFeature());
            if (new_embl_reference != old_embl_reference) {
                new_feature.getEmblFeature().setUserData(null);
                new_feature.setEmblFeature(new_embl_reference);
                new_embl_reference.setUserData(new_feature);
            }
            EntryChangeEvent event = new EntryChangeEvent(this, new_feature, 2);
            this.fireAction(this.entry_listener_list, event);
        }
        catch (EntryInformationException e) {
            new_feature.setEntry(null);
            throw e;
        }
    }

    public void dispose() {
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            EntryChangeEvent event = new EntryChangeEvent(this, current_feature, 1);
            this.fireAction(this.entry_listener_list, event);
            current_feature.setEntry(null);
        }
    }

    public Feature getFeature(int i) {
        return this.getFeatureOf(this.getEMBLEntry().getFeatureAtIndex(i));
    }

    public Feature createFeature() throws ReadOnlyException {
        QualifierVector new_qualifiers = new QualifierVector();
        try {
            Key new_key = this.getEntryInformation().getDefaultKey();
            Location new_location = new Location("1.." + this.getBases().getLength());
            return this.createFeature(new_key, new_location, new_qualifiers);
        }
        catch (LocationParseException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Feature createFeature(Key new_key, Location new_location, QualifierVector new_qualifiers) throws EntryInformationException, ReadOnlyException, OutOfRangeException {
        uk.ac.sanger.artemis.io.Feature new_embl_feature = this.getEMBLEntry().createFeature(new_key, new_location, new_qualifiers);
        Feature new_feature = this.getFeatureOf(new_embl_feature);
        EntryChangeEvent event = new EntryChangeEvent(this, new_feature, 2);
        this.fireAction(this.entry_listener_list, event);
        return new_feature;
    }

    public Feature createFeature(Key new_key, Location new_location) throws EntryInformationException, ReadOnlyException, OutOfRangeException {
        QualifierVector new_qualifiers = new QualifierVector();
        return this.createFeature(new_key, new_location, new_qualifiers);
    }

    public boolean contains(Feature feature) {
        return this.getEMBLEntry().contains(feature.getEmblFeature());
    }

    public int indexOf(Feature feature) {
        return this.getEMBLEntry().indexOf(feature.getEmblFeature());
    }

    public int getIndexOfFeature(Feature feature) {
        return this.getEMBLEntry().indexOf(feature.getEmblFeature());
    }

    public FeatureEnumeration features() {
        return new FeatureEnumerator();
    }

    public int getFeatureCount() {
        return this.getEMBLEntry().getFeatureCount();
    }

    private int getSequenceLength() {
        return this.getBases().getLength();
    }

    private Strand getForwardStrand() {
        return this.getBases().getForwardStrand();
    }

    private Strand getReverseStrand() {
        return this.getBases().getReverseStrand();
    }

    public Bases getBases() {
        return this.bases;
    }

    public Entry truncate(Bases new_bases, Range constraint) {
        Entry new_entry;
        EmblDocumentEntry new_embl_entry = new EmblDocumentEntry(this.getEntryInformation());
        try {
            new_entry = new Entry(new_bases, new_embl_entry);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            Location current_feature_location = current_feature.getLocation();
            Location new_location = current_feature_location.truncate(constraint);
            if (new_location == null) continue;
            Key current_key = current_feature.getKey();
            QualifierVector current_qualifiers = current_feature.getQualifiers();
            try {
                EmblStreamFeature new_embl_feature = new EmblStreamFeature(current_key, new_location, current_qualifiers);
                Feature new_feature = new Feature(new_embl_feature);
                new_entry.add(new_feature, false);
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (OutOfRangeException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            catch (ReadOnlyException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return new_entry;
    }

    public FeatureVector checkForNonEMBLKeys() {
        FeatureVector non_embl_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (current_feature.hasValidEMBLKey()) continue;
            non_embl_features.add(current_feature);
        }
        return non_embl_features;
    }

    public FeatureVector checkFeatureStartCodons() {
        FeatureKeyQualifierPredicate predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
        FeatureVector non_embl_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (!predicate.testPredicate(current_feature) || current_feature.hasValidStartCodon()) continue;
            non_embl_features.add(current_feature);
        }
        return non_embl_features;
    }

    public FeatureVector checkFeatureStopCodons() {
        FeatureKeyQualifierPredicate predicate = new FeatureKeyQualifierPredicate(Key.CDS, "pseudo", false);
        FeatureVector non_embl_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (!predicate.testPredicate(current_feature) || current_feature.hasValidStopCodon()) continue;
            non_embl_features.add(current_feature);
        }
        return non_embl_features;
    }

    public FeatureVector checkForEMBLDuplicates() {
        FeatureVector non_embl_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        Feature last_feature = null;
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            Key current_key = current_feature.getKey();
            Location current_location = current_feature.getLocation();
            if (last_feature != null && last_feature.getKey().equals(current_key) && last_feature.getLocation().equals(current_location)) {
                if (!non_embl_features.contains(last_feature)) {
                    non_embl_features.add(last_feature);
                }
                non_embl_features.add(current_feature);
                continue;
            }
            last_feature = current_feature;
        }
        return non_embl_features;
    }

    public FeatureVector checkForOverlappingCDSs() {
        FeatureVector cds_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (!current_feature.isCDS()) continue;
            cds_features.add(current_feature);
        }
        FeatureVector return_features = new FeatureVector();
        int i = 0;
        while (i + 1 < cds_features.size()) {
            int next_feature_start;
            Feature this_feature = cds_features.elementAt(i);
            Feature next_feature = cds_features.elementAt(i + 1);
            int this_feature_end = this_feature.getRawLastBase();
            if (this_feature_end >= (next_feature_start = next_feature.getRawFirstBase())) {
                return_features.add(this_feature);
            }
            ++i;
        }
        return return_features;
    }

    public FeatureVector checkForMissingQualifiers() {
        FeatureVector non_embl_features = new FeatureVector();
        FeatureEnumeration feature_enum = this.features();
        while (feature_enum.hasMoreFeatures()) {
            Feature current_feature = feature_enum.nextFeature();
            if (current_feature.hasRequiredQualifiers()) continue;
            non_embl_features.add(current_feature);
        }
        return non_embl_features;
    }

    public void addEntryChangeListener(EntryChangeListener l) {
        this.entry_listener_list.addElement(l);
    }

    public void removeEntryChangeListener(EntryChangeListener l) {
        this.entry_listener_list.removeElement(l);
    }

    public void addFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.addElement(l);
    }

    public void removeFeatureChangeListener(FeatureChangeListener l) {
        this.feature_listener_list.removeElement(l);
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.fireAction(this.feature_listener_list, event);
    }

    public EntryInformation getEntryInformation() {
        return this.getEMBLEntry().getEntryInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, ChangeEvent event) {
        Vector targets;
        Entry entry = this;
        synchronized (entry) {
            targets = (Vector)listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            ChangeListener target = (ChangeListener)targets.elementAt(i);
            if (event instanceof EntryChangeEvent) {
                EntryChangeListener entry_change_listener = (EntryChangeListener)target;
                entry_change_listener.entryChanged((EntryChangeEvent)event);
            } else {
                FeatureChangeListener feature_change_listener = (FeatureChangeListener)target;
                feature_change_listener.featureChanged((FeatureChangeEvent)event);
            }
            ++i;
        }
    }

    private Feature getFeatureOf(uk.ac.sanger.artemis.io.Feature embl_feature) {
        Feature test_feature = (Feature)embl_feature.getUserData();
        if (test_feature == null) {
            Feature new_feature = new Feature(embl_feature);
            new_feature.setEntry(this);
            new_feature.getSegments();
            return new_feature;
        }
        return test_feature;
    }

    private void checkLocations() throws OutOfRangeException {
        uk.ac.sanger.artemis.io.FeatureEnumeration feature_enumerator = this.getEMBLEntry().features();
        while (feature_enumerator.hasMoreFeatures()) {
            uk.ac.sanger.artemis.io.Feature feature = feature_enumerator.nextFeature();
            Location location = feature.getLocation();
            RangeVector ranges = location.getRanges();
            int i = 0;
            while (i < ranges.size()) {
                if (ranges.elementAt(i).getEnd() > this.getBases().getLength()) {
                    throw new OutOfRangeException(location.toString());
                }
                ++i;
            }
        }
    }

    private void createDianaFeatures() {
        FeatureEnumeration feature_enumerator = this.features();
        while (feature_enumerator.hasMoreFeatures()) {
            feature_enumerator.nextFeature();
        }
    }

    uk.ac.sanger.artemis.io.Entry getEMBLEntry() {
        return this.embl_entry;
    }

    private uk.ac.sanger.artemis.io.Entry getEMBLEntryAsNewType(EntryInformation entry_information, int new_type, boolean force) throws EntryInformationException {
        return DocumentEntryFactory.makeDocumentEntry(entry_information, this.embl_entry, new_type, force);
    }

    public class FeatureEnumerator
    implements FeatureEnumeration {
        private uk.ac.sanger.artemis.io.FeatureEnumeration feature_enumerator;

        public FeatureEnumerator() {
            this.feature_enumerator = Entry.this.getEMBLEntry().features();
        }

        public boolean hasMoreFeatures() {
            return this.feature_enumerator.hasMoreFeatures();
        }

        public Feature nextFeature() throws NoSuchElementException {
            uk.ac.sanger.artemis.io.Feature this_feature = this.feature_enumerator.nextFeature();
            return Entry.this.getFeatureOf(this_feature);
        }
    }
}

