/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.ArrayList;
import scigol.Any;
import scigol.Debug;
import scigol.List;
import scigol.Math;
import scigol.Range;
import scigol.ScigolTreeParser;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;
import scigol.accessor;

public class Vector {
    protected ArrayList a = new ArrayList();

    public Vector() {
    }

    public Vector(double d) {
        this.a.add(new Double(d));
    }

    public Vector(List l) {
        int i = 0;
        while (i < l.size()) {
            this.appendElement(l.get_Item((int)i).value);
            ++i;
        }
    }

    public double dot(Vector v) {
        if (v.op_Card() != this.op_Card()) {
            throw new IllegalArgumentException("vector arguments must have same dimension");
        }
        double dp = 0.0;
        int a = 0;
        while (a < this.op_Card()) {
            Object v1o = this.get_Item((int)a).value;
            Value v1e = new Value(v1o);
            Double element1 = (Double)TypeManager.performImplicitConversion(TypeSpec.typeOf(v1e), TypeSpec.realTypeSpec, v1e).getValue();
            Object v2o = v.get_Item((int)a).value;
            Value v2e = new Value(v2o);
            Double element2 = (Double)TypeManager.performImplicitConversion(TypeSpec.typeOf(v2e), TypeSpec.realTypeSpec, v2e).getValue();
            dp += element1 * element2;
            ++a;
        }
        return dp;
    }

    public static Vector zero(int dim) {
        Vector v = new Vector();
        int d = 0;
        while (d < dim) {
            v.a.add(new Double(0.0));
            ++d;
        }
        return v;
    }

    @accessor
    public int get_size() {
        return this.a.size();
    }

    @accessor
    public Vector get_Item(Range r) {
        r = r.normalize(this.a.size());
        if (r.start < 0 || r.start >= this.a.size()) {
            throw new IndexOutOfBoundsException("vector range start " + r.start + " out of range 0.." + (this.get_size() - 1));
        }
        if (r.end < 0 || r.end >= this.a.size()) {
            throw new IndexOutOfBoundsException("vector range end " + r.end + " out of range 0.." + (this.get_size() - 1));
        }
        if (r.start > r.end) {
            return new Vector();
        }
        if (r.start == r.end) {
            Vector v = new Vector();
            v.appendElement(this.a.get(r.start));
            return v;
        }
        Vector vec = new Vector();
        int i = r.start;
        while (i <= r.end) {
            vec.a.add(this.a.get(i));
            ++i;
        }
        return vec;
    }

    @accessor
    public void set_Item(Range r, Vector value) {
        r = r.normalize(this.a.size());
        if (r.start < 0 || r.start >= this.a.size()) {
            throw new IndexOutOfBoundsException("vector range start " + r.start + " out of range 0.." + (this.get_size() - 1));
        }
        if (r.end < 0 || r.end >= this.a.size()) {
            throw new IndexOutOfBoundsException("vector range end " + r.end + " out of range 0.." + (this.get_size() - 1));
        }
        if (r.start > r.end) {
            if (value.get_size() != 0) {
                throw new IllegalArgumentException("can't assign vector with " + value.get_size() + " elements to a range of 0 elements");
            }
            return;
        }
        if (r.start == r.end) {
            this.a.set(r.start, value.a.get(0));
            if (value.get_size() != 0) {
                throw new IllegalArgumentException("can't assign vector with " + value.get_size() + " elements to a range of 1 element");
            }
            return;
        }
        if (value.get_size() != r.end - r.start + 1) {
            throw new IllegalArgumentException("can't assign vector with " + value.get_size() + " elements to a range of " + (r.end - r.start + 1) + " elements");
        }
        int i = r.start;
        while (i <= r.end) {
            this.a.set(i, value.a.get(i - r.start));
            ++i;
        }
    }

    @accessor
    public Any get_Item(int i) {
        if (i >= 0 && i < this.a.size()) {
            return new Any(this.a.get(i));
        }
        throw new IndexOutOfBoundsException("vector index " + i + " out of range 0.." + this.a.size());
    }

    @accessor
    public void set_Item(int i, Any value) {
        if (i < 0 || i >= this.a.size()) {
            throw new IndexOutOfBoundsException("vector index " + i + " out of range 0.." + this.a.size());
        }
        this.a.set(i, value.value);
    }

    public static Vector op_UnaryNegation(Vector v) {
        Vector nv = new Vector();
        int a = 0;
        while (a < v.op_Card()) {
            Any ve = v.get_Item(a);
            Value e = new Value(ve);
            nv.appendElement(Math.performOverloadedOperation("operator-", null, e).getValue());
            ++a;
        }
        return nv;
    }

    public static Vector op_Subtraction(Vector v1, Vector v2) {
        Debug.Assert(v1.op_Card() == v2.op_Card(), "vector sized don't match (this should be a semantic error)");
        Vector mv2 = Vector.op_UnaryNegation(v2);
        return Vector.op_Addition(v1, mv2);
    }

    public static Vector op_Addition(Vector v1, Vector v2) {
        Debug.Assert(v1.op_Card() == v2.op_Card(), "vector sized don't match (this should be a semantic error)");
        Vector v3 = new Vector();
        int a = 0;
        while (a < v1.op_Card()) {
            Any v1e = v1.get_Item(a);
            Any v2e = v2.get_Item(a);
            Value e1 = new Value(v1e);
            Value e2 = new Value(v2e);
            v3.appendElement(Math.performOverloadedOperation("operator+", e1, e2).getValue());
            ++a;
        }
        return v3;
    }

    public static Vector op_Multiply(Vector v1, Double s) {
        Vector v2 = new Vector();
        int a = 0;
        while (a < v1.op_Card()) {
            Object v1o = v1.get_Item((int)a).value;
            Value v1e = new Value(v1o);
            Double element = (Double)TypeManager.performImplicitConversion(TypeSpec.typeOf(v1e), TypeSpec.realTypeSpec, v1e).getValue();
            Double e1 = new Double(element * s);
            v2.appendElement(e1);
            ++a;
        }
        return v2;
    }

    public static int op_Card(Vector v) {
        return v.op_Card();
    }

    public int op_Card() {
        return this.a.size();
    }

    public static Object op_Norm(Vector v) {
        if (v.a.get(0) instanceof Double) {
            double ss = 0.0;
            int i = 0;
            while (i < v.a.size()) {
                ss += (Double)v.a.get(i) * (Double)v.a.get(i);
                ++i;
            }
            return new Double(java.lang.Math.sqrt(ss));
        }
        if (v.a.get(0) instanceof Float) {
            double ss = 0.0;
            int i = 0;
            while (i < v.a.size()) {
                ss += (double)(((Float)v.a.get(i)).floatValue() * ((Float)v.a.get(i)).floatValue());
                ++i;
            }
            return new Double(java.lang.Math.sqrt(ss));
        }
        ScigolTreeParser.semanticError("can't compute the norm (operator||) of non-numeric vector elements");
        return null;
    }

    public void appendElement(Object e) {
        TypeSpec ntype;
        TypeSpec etype;
        if (this.a.size() > 0 && !(etype = new TypeSpec(this.a.get(0).getClass())).equals(ntype = new TypeSpec(e.getClass()))) {
            if (!TypeManager.existsImplicitConversion(etype, ntype, new Value(e))) {
                ScigolTreeParser.semanticError("expected element of type '" + etype + "', not '" + ntype + "'");
            } else {
                ArrayList<Object> na = new ArrayList<Object>();
                int i = 0;
                while (i < this.a.size()) {
                    na.add(TypeManager.performImplicitConversion(etype, ntype, new Value(this.a.get(i))).getValue());
                    ++i;
                }
                this.a = na;
            }
        }
        this.a.add(e);
    }

    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.a.size()) {
            s = String.valueOf(s) + this.a.get(i).toString();
            if (i != this.a.size() - 1) {
                s = String.valueOf(s) + " ";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

