/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import scigol.Any;
import scigol.Class;
import scigol.ClassInfo;
import scigol.Debug;
import scigol.Func;
import scigol.FuncInfo;
import scigol.List;
import scigol.Map;
import scigol.Matrix;
import scigol.Num;
import scigol.Range;
import scigol.ScigolTreeParser;
import scigol.Value;
import scigol.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSpec {
    protected Kind _kind;
    protected Object _type;
    public static java.lang.Class objectType = Object.class;
    public static java.lang.Class anyType = Any.class;
    public static java.lang.Class numType = Num.class;
    public static java.lang.Class byteType = Byte.class;
    public static java.lang.Class charType = Character.class;
    public static java.lang.Class stringType = String.class;
    public static java.lang.Class boolType = Boolean.class;
    public static java.lang.Class intType = Integer.class;
    public static java.lang.Class rangeType = Range.class;
    public static java.lang.Class dintType = Long.class;
    public static java.lang.Class realType = Double.class;
    public static java.lang.Class srealType = Float.class;
    public static java.lang.Class typeType = TypeSpec.class;
    public static java.lang.Class vectorType = Vector.class;
    public static java.lang.Class matrixType = Matrix.class;
    public static java.lang.Class listType = List.class;
    public static java.lang.Class mapType = Map.class;
    public static TypeSpec objectTypeSpec = new TypeSpec(objectType);
    public static TypeSpec anyTypeSpec = new TypeSpec(anyType);
    public static TypeSpec numTypeSpec = new TypeSpec(numType);
    public static TypeSpec byteTypeSpec = new TypeSpec(byteType);
    public static TypeSpec charTypeSpec = new TypeSpec(charType);
    public static TypeSpec stringTypeSpec = new TypeSpec(stringType);
    public static TypeSpec boolTypeSpec = new TypeSpec(boolType);
    public static TypeSpec intTypeSpec = new TypeSpec(intType);
    public static TypeSpec rangeTypeSpec = new TypeSpec(rangeType);
    public static TypeSpec dintTypeSpec = new TypeSpec(dintType);
    public static TypeSpec realTypeSpec = new TypeSpec(realType);
    public static TypeSpec srealTypeSpec = new TypeSpec(srealType);
    public static TypeSpec typeTypeSpec = new TypeSpec(typeType);
    public static TypeSpec vectorTypeSpec = new TypeSpec(vectorType);
    public static TypeSpec matrixTypeSpec = new TypeSpec(matrixType);
    public static TypeSpec listTypeSpec = new TypeSpec(listType);
    public static TypeSpec mapTypeSpec = new TypeSpec(mapType);
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;
    static /* synthetic */ java.lang.Class class$3;
    static /* synthetic */ java.lang.Class class$4;
    static /* synthetic */ java.lang.Class class$5;
    static /* synthetic */ java.lang.Class class$6;
    static /* synthetic */ java.lang.Class class$7;
    static /* synthetic */ java.lang.Class class$8;
    static /* synthetic */ java.lang.Class class$9;
    static /* synthetic */ java.lang.Class class$10;
    static /* synthetic */ java.lang.Class class$11;
    static /* synthetic */ java.lang.Class class$12;
    static /* synthetic */ java.lang.Class class$13;
    static /* synthetic */ java.lang.Class class$14;
    static /* synthetic */ java.lang.Class class$15;
    static /* synthetic */ java.lang.Class class$16;
    static /* synthetic */ java.lang.Class class$17;
    static /* synthetic */ java.lang.Class class$18;

    public TypeSpec() {
        this._kind = Kind.Builtin;
        this._type = anyType;
    }

    public TypeSpec(Type type) {
        Debug.Assert(!type.equals(Void.TYPE), "can't have a TypeSpec for Void");
        this.init(type);
    }

    protected void init(Type type) {
        Debug.Assert(type != null);
        if (TypeSpec.isBuiltin(type)) {
            this._kind = Kind.Builtin;
            this._type = type;
            if (type instanceof java.lang.Class && ((java.lang.Class)type).isPrimitive()) {
                java.lang.Class pclass = (java.lang.Class)type;
                if (pclass.equals(Byte.TYPE)) {
                    this._type = byteType;
                } else if (pclass.equals(Character.TYPE)) {
                    this._type = charType;
                } else if (pclass.equals(Boolean.TYPE)) {
                    this._type = boolType;
                } else if (pclass.equals(Short.TYPE)) {
                    this._type = intType;
                } else if (pclass.equals(Integer.TYPE)) {
                    this._type = intType;
                } else if (pclass.equals(Long.TYPE)) {
                    this._type = dintType;
                } else if (pclass.equals(Double.TYPE)) {
                    this._type = realType;
                } else if (pclass.equals(Float.TYPE)) {
                    this._type = srealType;
                } else {
                    Debug.Assert(false, "unsupported java primitive type:" + type);
                }
            }
        } else if (type instanceof java.lang.Class) {
            Debug.Assert(!type.equals(Class.class), "can't recover ClassInfo from Type of Class object, construct TypeSpec from Class object instead");
            this._kind = Kind.Class;
            this._type = new ClassInfo((java.lang.Class)type);
        } else {
            this._kind = Kind.Builtin;
            this._type = type;
        }
    }

    public TypeSpec(Member member) {
        this._kind = Kind.Function;
        this._type = new FuncInfo(member);
    }

    public TypeSpec(String name) {
        Type javaType = TypeSpec.sysTypeOf(name);
        this.init(javaType);
    }

    public TypeSpec(FuncInfo fi) {
        Debug.Assert(fi != null);
        this._kind = Kind.Function;
        this._type = fi;
    }

    public TypeSpec(ClassInfo ci) {
        Debug.Assert(ci != null);
        this._kind = Kind.Class;
        this._type = ci;
    }

    public boolean isFunc() {
        return this._kind == Kind.Function;
    }

    public boolean isType() {
        if (this._kind == Kind.Builtin) {
            return ((Type)this._type).equals(typeType);
        }
        if (this._kind == Kind.Class) {
            return ((ClassInfo)this._type).isTypeSpec();
        }
        return false;
    }

    public boolean isBuiltin() {
        return this._kind == Kind.Builtin;
    }

    public boolean isBuiltinObject() {
        return this._kind == Kind.Builtin && ((Type)this._type).equals(objectType);
    }

    public boolean isBuiltinClass() {
        return this.isBuiltin() && (this._type.equals(objectType) || this._type.equals(stringType) || this._type.equals(rangeType) || this._type.equals(vectorType) || this._type.equals(matrixType) || this._type.equals(listType) || this._type.equals(mapType));
    }

    public boolean isClassOrBuiltinClass() {
        return this.isClass() || this.isBuiltinClass();
    }

    public boolean isClassOrBuiltinClassOrInterface() {
        return this.isClassOrInterface() || this.isBuiltinClass();
    }

    public boolean isAny() {
        return this._kind == Kind.Builtin && ((Type)this._type).equals(anyType);
    }

    public boolean isNum() {
        return this._kind == Kind.Builtin && ((Type)this._type).equals(numType);
    }

    public boolean isANum() {
        if (this.isNum()) {
            return true;
        }
        if (this._kind != Kind.Builtin) {
            return false;
        }
        Type sysType = (Type)this._type;
        return sysType.equals(intType) || sysType.equals(dintType) || sysType.equals(realType) || sysType.equals(srealType) || sysType.equals(byteType) || sysType.equals(charType);
    }

    public boolean isClass() {
        if (this._kind == Kind.Class) {
            return !((ClassInfo)this._type).isInterface();
        }
        return false;
    }

    public boolean isClassOrInterface() {
        return this._kind == Kind.Class;
    }

    public boolean isInterface() {
        if (this._kind == Kind.Class) {
            return ((ClassInfo)this._type).isInterface();
        }
        return false;
    }

    public boolean isAbstractClass() {
        if (this._kind == Kind.Class) {
            return ((ClassInfo)this._type).isAbstract();
        }
        return false;
    }

    public boolean isAbstractClassOrInterface() {
        return this.isAbstractClass() || this.isInterface();
    }

    public boolean isByte() {
        return this._type instanceof Type && this._type.equals(byteType);
    }

    public boolean isChar() {
        return this._type instanceof Type && this._type.equals(charType);
    }

    public boolean isString() {
        return this._type instanceof Type && this._type.equals(stringType);
    }

    public boolean isBool() {
        return this._type instanceof Type && this._type.equals(boolType);
    }

    public boolean isInt() {
        return this._type instanceof Type && this._type.equals(intType);
    }

    public boolean isRange() {
        return this._type instanceof Type && this._type.equals(rangeType);
    }

    public boolean isDint() {
        return this._type instanceof Type && this._type.equals(dintType);
    }

    public boolean isReal() {
        return this._type instanceof Type && this._type.equals(realType);
    }

    public boolean isSreal() {
        return this._type instanceof Type && this._type.equals(srealType);
    }

    public boolean isVector() {
        return this._type instanceof Type && this._type.equals(vectorType);
    }

    public boolean isMatrix() {
        return this._type instanceof Type && this._type.equals(matrixType);
    }

    public boolean isList() {
        return this._type instanceof Type && this._type.equals(listType);
    }

    public boolean isMap() {
        return this._type instanceof Type && this._type.equals(mapType);
    }

    public ClassInfo getClassInfo() {
        if (this.isBuiltinClass()) {
            return new ClassInfo((java.lang.Class)this.getSysType());
        }
        Debug.Assert(this.isClass() || this.isInterface(), "only classes & interfaces have classInfo");
        Debug.Assert(this._type instanceof ClassInfo);
        return (ClassInfo)this._type;
    }

    public FuncInfo getFuncInfo() {
        Debug.Assert(this.isFunc(), "only functions have funcInfo");
        Debug.Assert(this._type instanceof FuncInfo);
        return (FuncInfo)this._type;
    }

    public Type getSysType() {
        if (this._kind == Kind.Builtin) {
            return (Type)this._type;
        }
        if (this._kind == Kind.Class) {
            return ((ClassInfo)this._type).getSysType();
        }
        Debug.Assert(false, "type has no Java type");
        return null;
    }

    public boolean equals(TypeSpec t) {
        if (t == null) {
            return false;
        }
        if (this._kind == Kind.Builtin) {
            if (!t.isBuiltin()) {
                return false;
            }
            return this.getSysType().equals(t.getSysType());
        }
        if (this._kind == Kind.Class) {
            if (t._kind != Kind.Class) {
                return false;
            }
            return this.getClassInfo().equals(t.getClassInfo());
        }
        if (!t.isFunc()) {
            return false;
        }
        return this.getFuncInfo().equals(t.getFuncInfo());
    }

    public boolean equals(Type t) {
        if (t == null) {
            return false;
        }
        return this.equals(new TypeSpec(t));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof TypeSpec) {
            return this.equals((TypeSpec)o);
        }
        if (o instanceof Type) {
            return this.equals((Type)o);
        }
        return false;
    }

    public boolean isA(TypeSpec t) {
        if (t.isBuiltinObject()) {
            return true;
        }
        if (this.equals(t)) {
            return true;
        }
        if (this.isClassOrInterface()) {
            if (t.isBuiltinClass()) {
                if (this.getClassInfo().isExternal() && ((java.lang.Class)t.getSysType()).isAssignableFrom((java.lang.Class)this.getSysType())) {
                    return true;
                }
            } else if (t.isClassOrInterface()) {
                return this.getClassInfo().isA(t.getClassInfo());
            }
        }
        return false;
    }

    public Value constructValue(FuncInfo callSig, ArrayList args, ScigolTreeParser treeParser) {
        if (this._kind == Kind.Builtin) {
            Debug.Assert(callSig == null || callSig.numArgs() == 0, "builtin construction with args not implemented");
            java.lang.Class sysClass = (java.lang.Class)this._type;
            try {
                Constructor ctor = sysClass.getConstructor(new java.lang.Class[0]);
                return new Value(ctor.newInstance(new Object[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return new Value(new Any(null));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("construction exception", e.getCause());
            }
            catch (InstantiationException instantiationException) {
                Debug.Assert(false, "a builtin is abstract?!");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("construction access exception", e.getCause());
            }
        } else {
            if (this._kind == Kind.Class) {
                Debug.Assert(callSig != null, "must supply an instantiation call signature");
                ClassInfo classInfo = (ClassInfo)this._type;
                return new Value(classInfo.instantiateClass(callSig, args, treeParser));
            }
            if (this._kind == Kind.Function) {
                return new Value(new Func(this.getFuncInfo(), null, null, null, null, null));
            }
        }
        Debug.Assert(false, "unhandled type Kind");
        return null;
    }

    public static Value unwrapAnyValue(Value v) {
        if (v.getValue() != null && v.getValue() instanceof Any) {
            return new Value(((Any)v.getValue()).value);
        }
        return v;
    }

    public static Value unwrapAnyOrNumValue(Value v) {
        if (v.getValue() != null) {
            if (v.getValue() instanceof Any) {
                return new Value(((Any)v.getValue()).value);
            }
            if (v.getValue() instanceof Num) {
                return new Value(((Num)v.getValue()).value);
            }
        }
        return v;
    }

    public static Object unwrapAny(Object v) {
        if (v instanceof Value) {
            v = ((Value)v).getValue();
        }
        if (v != null && v instanceof Any) {
            return ((Any)v).value;
        }
        return v;
    }

    public static Object unwrapAnyOrNum(Object v) {
        if (v instanceof Value) {
            v = ((Value)v).getValue();
        }
        if (v != null) {
            if (v instanceof Any) {
                return ((Any)v).value;
            }
            if (v instanceof Num) {
                return ((Num)v).value;
            }
        }
        return v;
    }

    public static TypeSpec typeOf(String name) {
        Type sysType = TypeSpec.sysTypeOf(name);
        if (sysType == null) {
            return null;
        }
        return new TypeSpec(sysType);
    }

    public static TypeSpec typeOf(Value v) {
        Debug.Assert(v != null, "Value v is null");
        return v.getType();
    }

    public static TypeSpec typeOf(Object o) {
        if (o == null) {
            return new TypeSpec(anyType);
        }
        if (o instanceof Value) {
            return TypeSpec.typeOf((Value)o);
        }
        if (o instanceof Func) {
            return new TypeSpec(((Func)o).getInfo());
        }
        if (o instanceof Class) {
            return new TypeSpec(((Class)o).getInfo());
        }
        return new TypeSpec(o.getClass());
    }

    public static Object valueOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Value) {
            return ((Value)o).getValue();
        }
        return o;
    }

    public static String typeName(Value v) {
        Debug.Assert(v != null);
        return TypeSpec.typeOf(v).typeName();
    }

    public static String typeName(Object o) {
        return TypeSpec.typeName(new Value(o));
    }

    public String typeName() {
        if (this._kind == Kind.Builtin) {
            Type t = (Type)this._type;
            if (t.equals(intType)) {
                return "int";
            }
            if (t.equals(rangeType)) {
                return "range";
            }
            if (t.equals(dintType)) {
                return "dint";
            }
            if (t.equals(realType)) {
                return "real";
            }
            if (t.equals(srealType)) {
                return "sreal";
            }
            if (t.equals(boolType)) {
                return "bool";
            }
            if (t.equals(byteType)) {
                return "byte";
            }
            if (t.equals(charType)) {
                return "char";
            }
            if (t.equals(stringType)) {
                return "string";
            }
            if (t.equals(vectorType)) {
                return "vector";
            }
            if (t.equals(matrixType)) {
                return "matrix";
            }
            if (t.equals(listType)) {
                return "list";
            }
            if (t.equals(mapType)) {
                return "map";
            }
            if (t.equals(typeType)) {
                return "type";
            }
            if (t.equals(numType)) {
                return "num";
            }
            if (t.equals(anyType)) {
                return "any";
            }
            if (t.equals(objectType)) {
                return "object";
            }
            Debug.Assert(false, "unrecognized builtin type:" + t);
        } else {
            if (this._kind == Kind.Function) {
                return this.getFuncInfo().toString();
            }
            if (this._kind == Kind.Class) {
                return this.getClassInfo().toString();
            }
        }
        return "any";
    }

    public boolean isConvertableTo(TypeSpec to) {
        return TypeSpec.isConvertable(this, to, null);
    }

    public boolean isConvertableTo(TypeSpec to, Value value) {
        return TypeSpec.isConvertable(this, to, value);
    }

    public static boolean isConvertable(TypeSpec from, TypeSpec to) {
        return TypeSpec.isConvertable(from, to, null);
    }

    public static boolean isConvertable(TypeSpec from, TypeSpec to, Value value) {
        Debug.Depricated("TypeSpec.isConvertable()");
        Debug.Assert(from._type != null);
        Debug.Assert(to._type != null);
        if (from.isAny() && value != null) {
            if (((Any)value.getValue()).value != null) {
                from = TypeSpec.typeOf(((Any)value.getValue()).value);
            } else {
                return true;
            }
        }
        if (from.equals(to)) {
            return true;
        }
        if (to.equals(anyType)) {
            return true;
        }
        if (to.equals(objectType)) {
            return true;
        }
        if (value != null && value.getValue() != null && from.isAny()) {
            Debug.Assert(TypeSpec.typeOf(value).isAny(), "value must have type 'any' of from.isAny()");
        }
        if (from.isFunc() && !to.isFunc()) {
            return false;
        }
        if (!from.isFunc() && to.isFunc()) {
            return false;
        }
        if (!from.isFunc() && !to.isFunc()) {
            if (to._type.equals(numType)) {
                return from._type.equals(intType) || from._type.equals(dintType) || from._type.equals(realType) || from._type.equals(srealType) || from._type.equals(byteType);
            }
            if (from._type.equals(intType)) {
                return to._type.equals(dintType) || to._type.equals(srealType) || to._type.equals(realType);
            }
            if (from._type.equals(dintType)) {
                return to._type.equals(realType);
            }
            if (from._type.equals(srealType)) {
                return to._type.equals(realType);
            }
            if (from._type.equals(byteType)) {
                return to._type.equals(charType) || to._type.equals(intType) || to._type.equals(dintType);
            }
            if (from._type.equals(charType)) {
                return to._type.equals(byteType) || to._type.equals(intType) || to._type.equals(dintType) || to._type.equals(stringType);
            }
            if (to._type instanceof Type && from._type instanceof Type) {
                return false;
            }
            return false;
        }
        return ((FuncInfo)from._type).callCompatible((FuncInfo)to._type);
    }

    public static Value convertTo(TypeSpec totype, Value value) {
        Debug.Depricated("TypeSpec.convertTo()");
        Debug.Assert(TypeSpec.isConvertable(TypeSpec.typeOf(value), totype, value), "isConvertable");
        if (value.getValue() instanceof Any) {
            value = new Value(((Any)value.getValue()).value);
        }
        if (value.getValue() == null) {
            return new Value(new Any(null));
        }
        if (TypeSpec.typeOf(value).equals(totype)) {
            return value;
        }
        if (totype.equals(anyType)) {
            return new Value(new Any(value));
        }
        if (totype.equals(objectType)) {
            return value;
        }
        Debug.Assert(false, "can't convert");
        return null;
    }

    public String toString() {
        return this.typeName();
    }

    protected static Type sysTypeOf(String name) {
        if (name.equals("object")) {
            return objectType;
        }
        if (name.equals("int")) {
            return intType;
        }
        if (name.equals("range")) {
            return rangeType;
        }
        if (name.equals("dint")) {
            return dintType;
        }
        if (name.equals("real")) {
            return realType;
        }
        if (name.equals("sreal")) {
            return srealType;
        }
        if (name.equals("bool")) {
            return boolType;
        }
        if (name.equals("byte")) {
            return byteType;
        }
        if (name.equals("char")) {
            return charType;
        }
        if (name.equals("string")) {
            return stringType;
        }
        if (name.equals("vector")) {
            return vectorType;
        }
        if (name.equals("matrix")) {
            return matrixType;
        }
        if (name.equals("list")) {
            return listType;
        }
        if (name.equals("map")) {
            return mapType;
        }
        if (name.equals("type")) {
            return typeType;
        }
        if (name.equals("num")) {
            return numType;
        }
        if (name.equals("any")) {
            return anyType;
        }
        try {
            return java.lang.Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected static boolean isBuiltin(Type type) {
        if (type instanceof java.lang.Class && ((java.lang.Class)type).isPrimitive()) {
            return true;
        }
        return type.equals(objectType) || type.equals(anyType) || type.equals(numType) || type.equals(byteType) || type.equals(charType) || type.equals(stringType) || type.equals(boolType) || type.equals(intType) || type.equals(rangeType) || type.equals(dintType) || type.equals(realType) || type.equals(srealType) || type.equals(typeType) || type.equals(vectorType) || type.equals(matrixType) || type.equals(listType) || type.equals(mapType);
    }

    public static String modifiersString(EnumSet<Modifier> m) {
        String s = "";
        if (m.contains((Object)Modifier.New)) {
            s = String.valueOf(s) + "new ";
        }
        if (m.contains((Object)Modifier.Const)) {
            s = String.valueOf(s) + "const ";
        }
        if (m.contains((Object)Modifier.Implicit)) {
            s = String.valueOf(s) + "implicit ";
        }
        if (m.contains((Object)Modifier.Public)) {
            s = String.valueOf(s) + "public ";
        }
        if (m.contains((Object)Modifier.Protected)) {
            s = String.valueOf(s) + "protected ";
        }
        if (m.contains((Object)Modifier.Private)) {
            s = String.valueOf(s) + "private ";
        }
        if (m.contains((Object)Modifier.Final)) {
            s = String.valueOf(s) + "final ";
        }
        if (m.contains((Object)Modifier.Static)) {
            s = String.valueOf(s) + "static ";
        }
        if (m.contains((Object)Modifier.Override)) {
            s = String.valueOf(s) + "override ";
        }
        if (m.contains((Object)Modifier.Abstract)) {
            s = String.valueOf(s) + "abstract ";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static EnumSet<Modifier> modifiersFromJavaModifiers(int javaModifiers) {
        int m = javaModifiers;
        EnumSet<Modifier> mods = EnumSet.noneOf(Modifier.class);
        if (java.lang.reflect.Modifier.isPublic(m)) {
            mods.add(Modifier.Public);
        }
        if (java.lang.reflect.Modifier.isProtected(m)) {
            mods.add(Modifier.Protected);
        }
        if (java.lang.reflect.Modifier.isPrivate(m)) {
            mods.add(Modifier.Private);
        }
        if (java.lang.reflect.Modifier.isFinal(m)) {
            mods.add(Modifier.Final);
        }
        if (java.lang.reflect.Modifier.isStatic(m)) {
            mods.add(Modifier.Static);
        }
        if (java.lang.reflect.Modifier.isAbstract(m)) {
            mods.add(Modifier.Abstract);
        }
        return mods;
    }

    public static TypeSpec covariantReturn(Member minfo) {
        Debug.Unimplemented("covariantReturn");
        return null;
    }

    public static String operatorSourceName(String javaName) {
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.javaName.equals(javaName)) {
                return op.srcName;
            }
            ++n;
        }
        if (javaName.equals("op_Implicit") || javaName.equals("op_Explicit") || javaName.equals("toString")) {
            return "operator->";
        }
        return javaName;
    }

    public static String operatorJavaName(String sourceName, boolean binary) {
        if (sourceName.equals("operator->")) {
            Debug.Assert(false, "amgibuous source operator name:" + sourceName);
        }
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.srcName.equals(sourceName) && op.binary == binary) {
                return op.javaName;
            }
            ++n;
        }
        Debug.Assert(false, "invalid source operator name:" + sourceName);
        return null;
    }

    public static String operatorJavaName(String sourceName) {
        if (sourceName.equals("operator->")) {
            Debug.Assert(false, "amgibuous source operator name:" + sourceName);
        }
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.srcName.equals(sourceName)) {
                return op.javaName;
            }
            ++n;
        }
        Debug.Assert(false, "invalid source operator name:" + sourceName);
        return null;
    }

    public static boolean isJavaOperator(String JavaName) {
        if (JavaName.equals("op_Implicit") || JavaName.equals("op_Explicit") || JavaName.equals("toString")) {
            return true;
        }
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.javaName.equals(JavaName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isOperator(String sourceName) {
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.srcName.equals(sourceName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isBinaryOperator(String sourceName) {
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.srcName.equals(sourceName)) {
                return op.binary;
            }
            ++n;
        }
        return false;
    }

    public static Operator operatorByName(String sourceName) {
        Operator[] operatorArray = Operator.values();
        int n = 0;
        int n2 = operatorArray.length;
        while (n < n2) {
            Operator op = operatorArray[n];
            if (op.srcName.equals(sourceName)) {
                return op;
            }
            ++n;
        }
        Debug.Assert(false, "bad operator source name");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        Builtin,
        Class,
        Function;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modifier {
        Public,
        Protected,
        Private,
        Final,
        Static,
        Override,
        Abstract,
        Const,
        Implicit,
        New;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        Multiply("operator*", "op_Multiply"),
        Division("operator/", "op_Division"),
        Modulus("operator%", "op_Modulus"),
        Addition("operator+", "op_Addition"),
        Subtraction("operator-", "op_Subtraction"),
        LessThan("operator<", "op_LessThan"),
        GreaterThan("operator>", "op_GreaterThan"),
        LessThanOrEqual("operator<=", "op_LessThanOrEqual"),
        GreaterThanOrEqual("operator>=", "op_GreaterThanOrEqual"),
        Equality("operator==", "op_Equality"),
        Inequality("operator!=", "op_Inequality"),
        UnaryPlus("operator+", "op_UnaryPlus", false),
        UnaryNegation("operator-", "op_UnaryNegation", false),
        Increment("operator++", "op_Increment"),
        Decrement("operator--", "op_Decrement"),
        Norm("operator||", "op_Norm", false),
        Cardinality("operator#", "op_Card", false),
        Power("operator^", "op_Power"),
        Prime("operator'", "op_Prime", false),
        Conversion("operator->", "", false);

        public String srcName;
        public String javaName;
        boolean binary;

        private Operator(String srcName, String javaName) {
            this.srcName = srcName;
            this.javaName = javaName;
            this.binary = true;
        }

        private Operator(String srcName, String javaName, boolean binary) {
            this.srcName = srcName;
            this.javaName = javaName;
            this.binary = binary;
        }
    }
}

