/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.ArrayList;
import scigol.Any;
import scigol.Class;
import scigol.ClassScope;
import scigol.Debug;
import scigol.Entry;
import scigol.Func;
import scigol.FuncInfo;
import scigol.List;
import scigol.Matrix;
import scigol.Num;
import scigol.Range;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeSpec;
import scigol.Value;
import scigol.Vector;

public class TypeManager {
    public static TypeSpec conversionOperatorFromType(TypeSpec declaringType, Entry entry) {
        Debug.Assert(entry.name.equals(".ctor") || entry.name.equals("operator->"), "must be a convertsion 'operator'");
        FuncInfo fi = entry.type.getFuncInfo();
        if (fi.numRequiredArgs() == 1) {
            return fi.getParamTypes()[0];
        }
        return declaringType;
    }

    public static TypeSpec conversionOperatorToType(TypeSpec declaringType, Entry entry) {
        Debug.Assert(entry.name.equals(".ctor") || entry.name.equals("operator->"), "must be a convertsion 'operator'");
        if (entry.name.equals(".ctor")) {
            return declaringType;
        }
        return entry.type.getFuncInfo().getReturnType();
    }

    public static Value callConversionOperator(TypeSpec declaringType, Entry entry, Value fromValue) {
        Debug.Assert(entry.type.isFunc(), "can only call func!");
        TypeSpec[] ts = new TypeSpec[]{TypeSpec.typeOf(fromValue)};
        FuncInfo callSig = new FuncInfo(ts, declaringType);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(fromValue.getValue());
        new ClassScope(declaringType);
        if (entry.name.equals(".ctor")) {
            Debug.Assert(declaringType.isClass() || declaringType.isBuiltinClass(), "declaring type must be a class");
            Func ctorFunc = (Func)Class.getMemberValue(entry, null);
            ScigolTreeParser tparser = ctorFunc.getParser();
            Class c = declaringType.getClassInfo().instantiateClass(callSig, args, tparser);
            if (c.isExternal()) {
                return new Value(c.getSysValue());
            }
            return new Value(c);
        }
        if (entry.isStatic()) {
            Func opFunc = (Func)Class.getMemberValue(entry, null);
            Object r = opFunc.call(null, args);
            return new Value(r);
        }
        if (fromValue.getValue() == null) {
            ScigolTreeParser.semanticError("a null instance was supplied in call to instance 'operator->' of type '" + declaringType + "' when an object was expected");
        }
        Debug.Assert(TypeSpec.typeOf(fromValue).equals(declaringType), "fromValue must be the instance of declaringType=" + declaringType);
        Debug.Assert(fromValue.getValue() != null, "need an instance!");
        Object instance = fromValue.getValue();
        Debug.Assert(instance instanceof Class, "instance must be class");
        Func opFunc = (Func)Class.getMemberValue(entry, instance);
        Object r = opFunc != null ? opFunc.call(instance, new Object[0]) : null;
        return new Value(r);
    }

    public static Entry[] getUserDefinedConversionOperatorsOf(TypeSpec t) {
        Entry[] ops;
        Entry entry;
        int n;
        int n2;
        Entry[] entryArray;
        if (!t.isClass() && !t.isBuiltinClass()) {
            return new Entry[0];
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        ClassScope classScope = new ClassScope(t);
        if (!t.isAbstractClassOrInterface()) {
            Entry[] ctors;
            entryArray = ctors = ((Scope)classScope).getEntries(".ctor", null);
            n2 = 0;
            n = entryArray.length;
            while (n2 < n) {
                entry = entryArray[n2];
                Debug.Assert(entry.type.isFunc(), ".ctor isn't a func! type:" + entry.type);
                if (entry.type.getFuncInfo().numRequiredArgs() == 1 && !entry.type.getFuncInfo().getParamTypes()[0].equals(t)) {
                    entries.add(entry);
                }
                ++n2;
            }
        }
        entryArray = ops = ((Scope)classScope).getEntries("operator->", null);
        n2 = 0;
        n = entryArray.length;
        while (n2 < n) {
            boolean isStaticOp;
            entry = entryArray[n2];
            Debug.Assert(entry.type.isFunc(), "entry for operator-> isn't a func; type:" + entry.type);
            FuncInfo fi = entry.type.getFuncInfo();
            boolean isInstanceOp = !entry.isStatic() && fi.numRequiredArgs() == 0;
            boolean bl = isStaticOp = entry.isStatic() && fi.numRequiredArgs() == 1 && (fi.getParamTypes()[0].equals(t) || fi.getReturnType().equals(t));
            if (!entry.isAbstract() && entry.index >= 0) {
                if (isInstanceOp) {
                    if (!fi.getReturnType().equals(t)) {
                        entries.add(entry);
                    }
                } else if (isStaticOp && !fi.getParamTypes()[0].equals(fi.getReturnType())) {
                    entries.add(entry);
                }
            }
            ++n2;
        }
        return Entry.toArray(entries);
    }

    public static boolean existsImplicitNumericConversion(TypeSpec from, TypeSpec to) {
        if (!from.isBuiltin() || !to.isBuiltin()) {
            return false;
        }
        if (from == to || from.equals(to)) {
            return true;
        }
        if (to.isAny()) {
            return true;
        }
        if (from.isANum() && to.isNum()) {
            return true;
        }
        if (from.isByte()) {
            return to.isChar() || to.isInt() || to.isDint() || to.isSreal() || to.isReal() || to.isRange() || to.isVector() || to.isMatrix();
        }
        if (from.isChar()) {
            return to.isInt() || to.isDint() || to.isSreal() || to.isReal() || to.isRange() || to.isVector() || to.isMatrix();
        }
        if (from.isInt()) {
            return to.isDint() || to.isSreal() || to.isReal() || to.isRange() || to.isVector() || to.isMatrix();
        }
        if (from.isDint()) {
            return to.isSreal() || to.isReal() || to.isVector() || to.isMatrix();
        }
        if (from.isSreal()) {
            return to.isReal() || to.isVector() || to.isMatrix();
        }
        if (from.isReal()) {
            return to.isVector() || to.isMatrix();
        }
        if (from.isVector()) {
            return to.isMatrix();
        }
        return false;
    }

    public static Value performImplicitNumericConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        Debug.Assert(TypeManager.existsImplicitNumericConversion(from, to), "implicit numeric conversion doesn't exist!");
        if (from == to || from.equals(to)) {
            return fromValue;
        }
        if (to.isAny()) {
            if (from.isNum() && fromValue.getValue() != null) {
                return new Value(new Any(((Num)fromValue.getValue()).value));
            }
            return new Value(new Any(fromValue.getValue()));
        }
        if (from.isANum() && to.isNum()) {
            Object value = fromValue.getValue();
            if (from.isNum() && value != null) {
                value = ((Num)fromValue.getValue()).value;
            }
            return new Value(new Num(value));
        }
        if (fromValue.getValue() == null) {
            return fromValue;
        }
        Object v = fromValue.getValue();
        if (from.isByte()) {
            if (to.isChar()) {
                return new Value(new Character((char)((Byte)v).byteValue()));
            }
            if (to.isInt()) {
                return new Value(new Integer(((Byte)v).byteValue()));
            }
            if (to.isDint()) {
                return new Value(new Long(((Byte)v).byteValue()));
            }
            if (to.isSreal()) {
                return new Value(new Float(((Byte)v).byteValue()));
            }
            if (to.isReal()) {
                return new Value(new Double(((Byte)v).byteValue()));
            }
            if (to.isRange()) {
                return new Value(new Range(((Byte)v).byteValue(), ((Byte)v).byteValue()));
            }
            if (to.isVector()) {
                return new Value(new Vector(((Byte)v).byteValue()));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix(((Byte)v).byteValue()));
            }
        }
        if (from.isChar()) {
            if (to.isInt()) {
                return new Value(new Integer(((Character)v).charValue()));
            }
            if (to.isDint()) {
                return new Value(new Long(((Character)v).charValue()));
            }
            if (to.isSreal()) {
                return new Value(new Float(((Character)v).charValue()));
            }
            if (to.isReal()) {
                return new Value(new Double(((Character)v).charValue()));
            }
            if (to.isRange()) {
                return new Value(new Range(((Character)v).charValue(), ((Character)v).charValue()));
            }
            if (to.isVector()) {
                return new Value(new Vector(((Character)v).charValue()));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix(((Character)v).charValue()));
            }
        }
        if (from.isInt()) {
            if (to.isDint()) {
                return new Value(new Long(((Integer)v).intValue()));
            }
            if (to.isSreal()) {
                return new Value(new Float(((Integer)v).intValue()));
            }
            if (to.isReal()) {
                return new Value(new Double(((Integer)v).intValue()));
            }
            if (to.isRange()) {
                return new Value(new Range((Integer)v, (Integer)v));
            }
            if (to.isVector()) {
                return new Value(new Vector(((Integer)v).intValue()));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix(((Integer)v).intValue()));
            }
        }
        if (from.isDint()) {
            if (to.isSreal()) {
                return new Value(new Float(((Long)v).longValue()));
            }
            if (to.isReal()) {
                return new Value(new Double(((Long)v).longValue()));
            }
            if (to.isVector()) {
                return new Value(new Vector(((Long)v).longValue()));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix(((Long)v).longValue()));
            }
        }
        if (from.isSreal()) {
            if (to.isReal()) {
                return new Value(new Double(((Float)v).floatValue()));
            }
            if (to.isVector()) {
                return new Value(new Vector(((Float)v).floatValue()));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix(((Float)v).floatValue()));
            }
        }
        if (from.isReal()) {
            if (to.isVector()) {
                return new Value(new Vector((Double)v));
            }
            if (to.isMatrix()) {
                return new Value(new Matrix((Double)v));
            }
        }
        if (from.isVector() && to.isMatrix()) {
            return new Value(new Matrix((Vector)v));
        }
        Debug.Assert(false, "unimplemented or bad performImplicitNumericConversion(" + from + ", " + to + ")");
        return null;
    }

    public static boolean existsImplicitReferenceConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (from == to || from.equals(to)) {
            return true;
        }
        if (to.isBuiltinObject()) {
            return true;
        }
        if (to.isAny()) {
            return true;
        }
        if (from.isAny()) {
            return true;
        }
        if (from.isNum() && to.isANum()) {
            return true;
        }
        if (from.isA(to)) {
            return true;
        }
        if (from.isList() && to.isVector()) {
            return true;
        }
        if (fromValue != null) {
            if (fromValue.getValue() == null) {
                return true;
            }
            if (from.isAny() && TypeSpec.typeOf(((Any)fromValue.getValue()).value).equals(to)) {
                return true;
            }
            if (to.isString() && from.isBuiltin()) {
                return true;
            }
        }
        return false;
    }

    public static Value performImplicitReferenceConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (from == to || from.equals(to)) {
            return fromValue;
        }
        if (to.isBuiltinObject()) {
            return fromValue;
        }
        if (to.isAny()) {
            if (from.isNum()) {
                return new Value(new Any(((Num)fromValue.getValue()).value));
            }
            return new Value(new Any(fromValue.getValue()));
        }
        if (from.isA(to)) {
            return fromValue;
        }
        if (fromValue.getValue() == null) {
            return fromValue;
        }
        if (from.isList() && to.isVector()) {
            return new Value(new Vector((List)fromValue.getValue()));
        }
        if (from.isAny()) {
            Object svalue = ((Any)fromValue.getValue()).value;
            TypeSpec stype = TypeSpec.typeOf(svalue);
            if (stype.equals(to)) {
                return new Value(svalue);
            }
            if (stype.isA(to)) {
                return new Value(svalue);
            }
            return TypeManager.performExplicitConversion(stype, to, new Value(svalue));
        }
        if (from.isNum() && to.isANum()) {
            Object svalue = ((Num)fromValue.getValue()).value;
            TypeSpec stype = TypeSpec.typeOf(svalue);
            if (stype.equals(to)) {
                return new Value(svalue);
            }
            if (stype.isA(to)) {
                return new Value(svalue);
            }
            return TypeManager.performExplicitConversion(stype, to, new Value(svalue));
        }
        if (to.isString() && from.isBuiltin()) {
            if (from.isChar()) {
                Character c = (Character)fromValue.getValue();
                char[] ca = new char[]{c.charValue()};
                return new Value(new String(ca));
            }
            return new Value(fromValue.getValue().toString());
        }
        Debug.Assert(false, "unimplemented or bad performImplicitReferenceConversion(" + from + ", " + to + ")");
        return null;
    }

    public static boolean existsImplicitUserDefinedConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        Value r = TypeManager.performUserDefinedConversion(from, to, fromValue, true);
        return r != null;
    }

    public static Value performImplicitUserDefinedConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        return TypeManager.performUserDefinedConversion(from, to, fromValue, true);
    }

    public static boolean existsImplicitConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (from == to || from.equals(to)) {
            return true;
        }
        if (TypeManager.existsImplicitNumericConversion(from, to)) {
            return true;
        }
        if (TypeManager.existsImplicitReferenceConversion(from, to, fromValue)) {
            return true;
        }
        return TypeManager.existsImplicitUserDefinedConversion(from, to, fromValue);
    }

    public static Value performImplicitConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        Debug.Assert(fromValue.getValue() == null || TypeSpec.typeOf(fromValue).isA(from), "fromValue (type " + TypeSpec.typeOf(fromValue) + ") must be of type 'from' (= " + from + ") or a derived type");
        if (from == to || from.equals(to)) {
            return fromValue;
        }
        Value r = TypeManager.performImplicitUserDefinedConversion(from, to, fromValue);
        if (r != null) {
            return r;
        }
        if (TypeManager.existsImplicitNumericConversion(from, to)) {
            return TypeManager.performImplicitNumericConversion(from, to, fromValue);
        }
        if (TypeManager.existsImplicitReferenceConversion(from, to, fromValue)) {
            return TypeManager.performImplicitReferenceConversion(from, to, fromValue);
        }
        ScigolTreeParser.semanticError("there is no implicit conversion available from type '" + from + "' to type '" + to + "'");
        return null;
    }

    public static boolean existsExplicitNumericConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (from.isANum() && !TypeManager.existsImplicitNumericConversion(from, to)) {
            return true;
        }
        if (from.isANum() && (to.isANum() || to.isAny())) {
            return true;
        }
        return (from.isVector() || from.isMatrix() || from.isList() || from.isString()) && to.isANum();
    }

    public static Value performExplicitVectorOrMatrixConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        TypeSpec eltType;
        Any element;
        Debug.Assert((from.isVector() || from.isMatrix()) && to.isANum() && !to.isNum(), "only vector or matrix to concrete numeric values");
        Object v = fromValue.getValue();
        Value realValue = null;
        if (from.isMatrix()) {
            Matrix m = (Matrix)v;
            if (m.get_rows() == 1 && m.get_cols() == 1) {
                element = m.get_Item(0, 0);
                eltType = TypeSpec.typeOf(element);
                if (TypeManager.existsImplicitNumericConversion(eltType, TypeSpec.realTypeSpec)) {
                    realValue = TypeManager.performImplicitNumericConversion(eltType, TypeSpec.realTypeSpec, new Value(element));
                } else {
                    ScigolTreeParser.semanticError("conversion from type 'matrix' to type '" + to + "' requires the matrix to have a single element that is convertable to '" + to + "'");
                }
            } else {
                ScigolTreeParser.semanticError("conversion from type 'matrix' to type '" + to + "' requires the matrix to have a single element that is convertable to '" + to + "'");
            }
        }
        if (from.isVector()) {
            Vector vec = (Vector)v;
            if (vec.get_size() == 1) {
                element = vec.get_Item(0);
                eltType = TypeSpec.typeOf(element);
                if (TypeManager.existsImplicitNumericConversion(eltType, TypeSpec.realTypeSpec)) {
                    realValue = TypeManager.performImplicitNumericConversion(eltType, TypeSpec.realTypeSpec, new Value(element));
                } else {
                    ScigolTreeParser.semanticError("conversion from type 'vector' to type '" + to + "' requires the vector to have a single element that is convertable to '" + to + "'");
                }
            } else {
                ScigolTreeParser.semanticError("conversion from type 'vector' to type '" + to + "' requires the vector to have a single element that is convertable to '" + to + "'");
            }
        }
        return TypeManager.performExplicitNumericConversion(TypeSpec.realTypeSpec, to, realValue);
    }

    public static Value performExplicitNumericConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (!TypeManager.existsImplicitNumericConversion(from, to)) {
            if ((from.isANum() || from.isVector() || from.isMatrix()) && (to.isANum() || to.isAny())) {
                if (fromValue.getValue() == null) {
                    if (to.isNum()) {
                        return new Value(new Num(null));
                    }
                    if (to.isAny()) {
                        return new Value(new Any(null));
                    }
                    return fromValue;
                }
                if (from.isNum()) {
                    fromValue = new Value(((Num)fromValue.getValue()).value);
                    from = TypeSpec.typeOf(fromValue);
                    if (fromValue.getValue() == null) {
                        if (to.isNum()) {
                            return new Value(new Num(null));
                        }
                        if (to.isAny()) {
                            return new Value(new Any(null));
                        }
                        return fromValue;
                    }
                }
                if (to.isAny()) {
                    return new Value(new Any(fromValue.getValue()));
                }
                if (from.equals(to)) {
                    return fromValue;
                }
                Object v = fromValue.getValue();
                if (to.isVector() && from.isMatrix()) {
                    Matrix m = (Matrix)v;
                    if (m.get_rows() == 1) {
                        return new Value(m.row(0));
                    }
                    if (m.get_cols() == 1) {
                        return new Value(m.col(0));
                    }
                    if (m.get_rows() == 0) {
                        return new Value(new Vector());
                    }
                    ScigolTreeParser.semanticError("conversion from type 'matrix' to type 'vector' requires the matrix to have either 1 row or 1 column or 0 elements");
                }
                if (to.isReal() && (from.isMatrix() || from.isVector())) {
                    return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                }
                if (to.isSreal()) {
                    if (from.isMatrix() || from.isVector()) {
                        return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                    }
                    if (from.isReal()) {
                        return new Value(new Float((float)((Double)v).doubleValue()));
                    }
                }
                if (to.isDint()) {
                    if (from.isMatrix() || from.isVector()) {
                        return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                    }
                    if (from.isReal()) {
                        return new Value(new Long((long)((Double)v).doubleValue()));
                    }
                    if (from.isSreal()) {
                        return new Value(new Long((long)((Float)v).floatValue()));
                    }
                }
                if (to.isInt()) {
                    if (from.isMatrix() || from.isVector()) {
                        return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                    }
                    if (from.isReal()) {
                        return new Value(new Integer((int)((Double)v).doubleValue()));
                    }
                    if (from.isSreal()) {
                        return new Value(new Integer((int)((Float)v).floatValue()));
                    }
                    if (from.isDint()) {
                        return new Value(new Integer((int)((Long)v).longValue()));
                    }
                }
                if (to.isChar()) {
                    if (from.isMatrix() || from.isVector()) {
                        return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                    }
                    if (from.isReal()) {
                        return new Value(new Character((char)((Double)v).doubleValue()));
                    }
                    if (from.isSreal()) {
                        return new Value(new Character((char)((Float)v).floatValue()));
                    }
                    if (from.isDint()) {
                        return new Value(new Character((char)((Long)v).longValue()));
                    }
                    if (from.isInt()) {
                        return new Value(new Character((char)((Integer)v).intValue()));
                    }
                }
                if (to.isByte()) {
                    if (from.isMatrix() || from.isVector()) {
                        return TypeManager.performExplicitVectorOrMatrixConversion(from, to, fromValue);
                    }
                    if (from.isReal()) {
                        return new Value(new Byte((byte)((Double)v).doubleValue()));
                    }
                    if (from.isSreal()) {
                        return new Value(new Byte((byte)((Float)v).floatValue()));
                    }
                    if (from.isDint()) {
                        return new Value(new Byte((byte)((Long)v).longValue()));
                    }
                    if (from.isInt()) {
                        return new Value(new Byte((byte)((Integer)v).intValue()));
                    }
                    if (from.isChar()) {
                        return new Value(new Byte((byte)((Character)v).charValue()));
                    }
                }
            }
            if ((from.isList() || from.isString()) && to.isANum()) {
                if (from.isList()) {
                    Any element;
                    TypeSpec eltType;
                    List l = (List)fromValue.getValue();
                    if (l.get_size() == 1 && TypeManager.existsImplicitNumericConversion(eltType = TypeSpec.typeOf(element = l.get_Item(0)), to)) {
                        return TypeManager.performImplicitNumericConversion(eltType, to, new Value(element));
                    }
                    ScigolTreeParser.semanticError("conversion from type 'list' to type '" + to + "' requires the list to have a single element that is convertable to '" + to + "'");
                }
                if (from.isString()) {
                    if (fromValue.getValue() == null) {
                        ScigolTreeParser.semanticError("cannot convert a null string to type '" + to + "'");
                    }
                    if (to.isANum()) {
                        if (!to.isChar()) {
                            double n = 0.0;
                            try {
                                n = Double.parseDouble((String)fromValue.getValue());
                            }
                            catch (Exception e) {
                                ScigolTreeParser.semanticError("cannot convert string to type '" + to + "' - " + e.getMessage());
                            }
                            return TypeManager.performExplicitNumericConversion(new TypeSpec(TypeSpec.realType), to, new Value(new Double(n)));
                        }
                        String fromString = (String)fromValue.getValue();
                        if (fromString == null) {
                            ScigolTreeParser.semanticError("cannot convert a null string into a char");
                        }
                        if (fromString.length() != 1) {
                            ScigolTreeParser.semanticError("conversion of a string into a char requires the string to contain a single character");
                        }
                        return new Value(new Character(fromString.charAt(0)));
                    }
                }
            }
        } else {
            return TypeManager.performImplicitNumericConversion(from, to, fromValue);
        }
        Debug.Assert(false, "unimplemented or bad performExplicitNumericConversion(" + from + ", " + to + ")");
        return null;
    }

    public static boolean existsExplicitReferenceConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (from.isBuiltinObject()) {
            return true;
        }
        if (from.isString() && to.isBool()) {
            return true;
        }
        if (to.isA(from)) {
            return true;
        }
        return to.isInterface();
    }

    public static Value performExplicitReferenceConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (!TypeManager.existsExplicitReferenceConversion(from, to, fromValue)) {
            return null;
        }
        if (from.isString() && to.isBool()) {
            String fromString = (String)fromValue.getValue();
            if (fromString == null) {
                return new Value(new Boolean(false));
            }
            if (fromString.startsWith("true") || fromString.startsWith("True")) {
                return new Value(new Boolean(true));
            }
            return new Value(new Boolean(false));
        }
        Debug.Unimplemented("performExplicitReferenceConversion");
        return null;
    }

    public static boolean existsExplicitUserDefinedConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        Value r = TypeManager.performUserDefinedConversion(from, to, fromValue, false);
        return r != null;
    }

    public static Value performExplicitUserDefinedConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        return TypeManager.performUserDefinedConversion(from, to, fromValue, false);
    }

    public static boolean existsExplicitConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (TypeManager.existsImplicitConversion(from, to, fromValue)) {
            return true;
        }
        if (TypeManager.existsExplicitNumericConversion(from, to, fromValue)) {
            return true;
        }
        if (TypeManager.existsExplicitReferenceConversion(from, to, fromValue)) {
            return true;
        }
        return TypeManager.existsExplicitUserDefinedConversion(from, to, fromValue);
    }

    public static Value performExplicitConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (fromValue.getValue() != null) {
            fromValue = TypeSpec.unwrapAnyValue(fromValue);
            if (from.isAny() || from.isNum()) {
                from = TypeSpec.typeOf(fromValue);
            }
        }
        Debug.Assert(fromValue.getValue() == null || TypeSpec.typeOf(fromValue).equals(from), "fromValue (type " + TypeSpec.typeOf(fromValue) + ") must be type of 'from' (= " + from + ")");
        Value r = TypeManager.performExplicitUserDefinedConversion(from, to, fromValue);
        if (r != null) {
            return r;
        }
        r = TypeManager.performImplicitUserDefinedConversion(from, to, fromValue);
        if (r != null) {
            return r;
        }
        if (TypeManager.existsImplicitConversion(from, to, fromValue)) {
            return TypeManager.performImplicitConversion(from, to, fromValue);
        }
        if (TypeManager.existsExplicitNumericConversion(from, to, fromValue)) {
            return TypeManager.performExplicitNumericConversion(from, to, fromValue);
        }
        return TypeManager.performExplicitReferenceConversion(from, to, fromValue);
    }

    public static boolean existsImplicitStandardConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (TypeManager.existsImplicitNumericConversion(from, to)) {
            return true;
        }
        return TypeManager.existsImplicitReferenceConversion(from, to, fromValue);
    }

    public static boolean existsExplicitStandardConversion(TypeSpec from, TypeSpec to, Value fromValue) {
        if (TypeManager.existsImplicitStandardConversion(from, to, fromValue)) {
            return true;
        }
        return TypeManager.existsExplicitNumericConversion(from, to, fromValue) || TypeManager.existsExplicitReferenceConversion(from, to, fromValue);
    }

    public static boolean encompassedBy(TypeSpec a, TypeSpec b) {
        return !a.isInterface() && !b.isInterface() && TypeManager.existsImplicitStandardConversion(a, b, null);
    }

    public static boolean encompasses(TypeSpec b, TypeSpec a) {
        return !a.isInterface() && !b.isInterface() && TypeManager.existsImplicitStandardConversion(a, b, null);
    }

    public static TypeSpec mostEncompassingType(ArrayList types) {
        if (types.size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return (TypeSpec)types.get(0);
        }
        TypeSpec mostEncompassing = (TypeSpec)types.get(0);
        for (Object o : types) {
            TypeSpec type = (TypeSpec)o;
            if (TypeManager.encompasses(type, mostEncompassing)) {
                mostEncompassing = type;
                continue;
            }
            if (TypeManager.encompasses(mostEncompassing, type)) continue;
            return null;
        }
        return mostEncompassing;
    }

    public static TypeSpec mostEncompassedType(ArrayList types) {
        if (types.size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return (TypeSpec)types.get(0);
        }
        TypeSpec mostEncompassed = (TypeSpec)types.get(0);
        for (Object o : types) {
            TypeSpec type = (TypeSpec)o;
            if (TypeManager.encompassedBy(type, mostEncompassed)) {
                mostEncompassed = type;
                continue;
            }
            if (TypeManager.encompassedBy(mostEncompassed, type)) continue;
            return null;
        }
        return mostEncompassed;
    }

    /*
     * WARNING - void declaration
     */
    public static Value performUserDefinedConversion(TypeSpec from, TypeSpec to, Value fromValue, boolean implicitConversion) {
        void var12_25;
        void var12_22;
        Value value;
        void var11_47;
        void var10_36;
        void var10_34;
        void var10_29;
        TypeSpec convertTo;
        TypeSpec convertFrom;
        Entry entry;
        void var10_27;
        boolean toIsSimpleBuiltin;
        if (fromValue != null) {
            if (from.isAny()) {
                if (fromValue.getValue() != null) {
                    fromValue = new Value(((Any)fromValue.getValue()).value);
                    from = TypeSpec.typeOf(fromValue);
                } else {
                    fromValue = new Value();
                }
            } else if (from.isNum()) {
                if (fromValue.getValue() != null) {
                    fromValue = new Value(((Num)fromValue.getValue()).value);
                    from = TypeSpec.typeOf(fromValue);
                } else {
                    fromValue = new Value();
                }
            } else {
                fromValue = TypeSpec.unwrapAnyOrNumValue(fromValue);
            }
        }
        if (fromValue != null && fromValue.getValue() != null) {
            Debug.Assert(TypeSpec.typeOf(fromValue).equals(from), "fromValue (type " + TypeSpec.typeOf(fromValue) + ") must be of type 'from'=" + from);
        }
        boolean fromIsSimpleBuiltin = from.isBuiltin() && !from.isBuiltinClass() || from.isBuiltinObject();
        boolean bl = toIsSimpleBuiltin = to.isBuiltin() && !to.isBuiltinClass() || to.isBuiltinObject();
        if (fromIsSimpleBuiltin && toIsSimpleBuiltin) {
            return null;
        }
        Entry[] fromOps = TypeManager.getUserDefinedConversionOperatorsOf(from);
        Entry[] toOps = !from.equals(to) ? TypeManager.getUserDefinedConversionOperatorsOf(to) : new Entry[]{};
        ArrayList<ConvOperator> applicableOps = new ArrayList<ConvOperator>();
        Entry[] entryArray = fromOps;
        boolean bl2 = false;
        int n = entryArray.length;
        while (var10_27 < n) {
            entry = entryArray[var10_27];
            convertFrom = TypeManager.conversionOperatorFromType(from, entry);
            convertTo = TypeManager.conversionOperatorToType(from, entry);
            if (TypeManager.encompasses(convertFrom, from) && TypeManager.encompassedBy(convertTo, to) && (!implicitConversion || entry.isImplicit())) {
                applicableOps.add(new ConvOperator(from, entry));
            }
            ++var10_27;
        }
        Entry[] entryArray2 = toOps;
        boolean bl3 = false;
        int n2 = entryArray2.length;
        while (var10_29 < n2) {
            entry = entryArray2[var10_29];
            convertFrom = TypeManager.conversionOperatorFromType(to, entry);
            convertTo = TypeManager.conversionOperatorToType(to, entry);
            if (TypeManager.encompasses(convertFrom, from) && TypeManager.encompassedBy(convertTo, to) && (!implicitConversion || entry.isImplicit())) {
                applicableOps.add(new ConvOperator(to, entry));
            }
            ++var10_29;
        }
        if (applicableOps.size() == 0) {
            return null;
        }
        TypeSpec mostSpecificFrom = null;
        for (Object e : applicableOps) {
            ConvOperator convOperator = (ConvOperator)e;
            if (!convOperator.from().equals(from)) continue;
            mostSpecificFrom = from;
            break;
        }
        if (mostSpecificFrom == null) {
            ArrayList<TypeSpec> arrayList = new ArrayList<TypeSpec>();
            for (Object e : applicableOps) {
                arrayList.add(((ConvOperator)e).from());
            }
            mostSpecificFrom = TypeManager.mostEncompassedType(arrayList);
            if (mostSpecificFrom == null) {
                ScigolTreeParser.semanticError((implicitConversion ? "implicit " : "") + "conversion from type '" + from + "' to type '" + to + "' is ambiguous");
            }
        }
        Object var10_32 = null;
        for (Object e : applicableOps) {
            if (!((ConvOperator)e).to().equals(to)) continue;
            TypeSpec typeSpec = to;
            break;
        }
        if (var10_34 == null) {
            ArrayList<TypeSpec> arrayList = new ArrayList<TypeSpec>();
            for (Object e : applicableOps) {
                arrayList.add(((ConvOperator)e).to());
            }
            TypeSpec typeSpec = TypeManager.mostEncompassingType(arrayList);
            if (typeSpec == null) {
                ScigolTreeParser.semanticError((implicitConversion ? "implicit " : "") + "conversion from type '" + from + "' to type '" + to + "' is ambiguous");
            }
        }
        Object var11_46 = null;
        for (Object e : applicableOps) {
            ConvOperator op = (ConvOperator)e;
            if (!op.from().equals(mostSpecificFrom) || !op.to().equals((TypeSpec)var10_36)) continue;
            if (var11_47 == null) {
                ConvOperator convOperator = op;
                continue;
            }
            ScigolTreeParser.semanticError((implicitConversion ? "implicit " : "") + "conversion from type '" + from + "' to type '" + to + "' is ambiguous");
        }
        if (var11_47 == null) {
            ScigolTreeParser.semanticError((implicitConversion ? "implicit " : "") + "conversion from type '" + from + "' to type '" + to + "' is ambiguous");
        }
        if (fromValue == null) {
            return new Value();
        }
        Value value2 = fromValue;
        if (!from.equals(mostSpecificFrom)) {
            Value value3 = TypeManager.performImplicitConversion(from, mostSpecificFrom, value2);
        }
        Debug.Assert((value = TypeManager.callConversionOperator(var11_47.declaringType, var11_47.methodEntry, (Value)var12_22)) != null, "call of conversion operator failed");
        Debug.Assert(TypeSpec.typeOf(value).equals((TypeSpec)var10_36), "unexpected return type from conversion operator");
        if (!to.equals((TypeSpec)var10_36)) {
            Value value4 = TypeManager.performImplicitConversion((TypeSpec)var10_36, to, value);
        }
        return var12_25;
    }

    public static int betterConversion(TypeSpec from, TypeSpec to1, TypeSpec to2, Value fromValue) {
        if (to1.equals(to2)) {
            return 0;
        }
        if (from.equals(to1)) {
            return 1;
        }
        if (from.equals(to2)) {
            return -1;
        }
        if (fromValue != null && fromValue.getValue() != null) {
            if (from.isAny()) {
                fromValue = new Value(((Any)fromValue.getValue()).value);
                from = TypeSpec.typeOf(fromValue.getValue());
            } else if (from.isNum()) {
                fromValue = new Value(((Num)fromValue.getValue()).value);
                from = TypeSpec.typeOf(fromValue.getValue());
            }
        }
        if (from.equals(to1)) {
            return 1;
        }
        if (from.equals(to2)) {
            return -1;
        }
        boolean implicitConversion1to2Exists = TypeManager.existsImplicitConversion(to1, to2, null);
        boolean implicitConversion2to1Exists = TypeManager.existsImplicitConversion(to2, to1, null);
        if (implicitConversion1to2Exists && !implicitConversion2to1Exists) {
            return 1;
        }
        if (implicitConversion2to1Exists && !implicitConversion1to2Exists) {
            return -1;
        }
        return 0;
    }

    public static boolean betterFuncMatch(FuncInfo P, FuncInfo Q, FuncInfo callSig, Object[] args) {
        Debug.Assert(args == null || args.length == callSig.numArgs());
        Debug.Assert(callSig.numArgs() >= P.numRequiredArgs());
        Debug.Assert(callSig.numArgs() >= Q.numRequiredArgs());
        Debug.Assert(callSig.numArgs() <= P.numArgs());
        Debug.Assert(callSig.numArgs() <= Q.numArgs());
        boolean atLeastOneArgPbetterQ = false;
        int a = 0;
        while (a < callSig.numArgs()) {
            boolean PworseQ;
            TypeSpec fromArgType = callSig.getParamTypes()[a];
            Value fromArg = args != null ? new Value(args[a]) : null;
            TypeSpec argPType = P.getParamTypes()[a];
            TypeSpec argQType = Q.getParamTypes()[a];
            int c = TypeManager.betterConversion(fromArgType, argPType, argQType, fromArg);
            boolean PbetterQ = c > 0;
            boolean bl = PworseQ = c < 0;
            if (PworseQ) {
                return false;
            }
            if (PbetterQ) {
                atLeastOneArgPbetterQ = true;
            }
            ++a;
        }
        return atLeastOneArgPbetterQ;
    }

    public static Entry[] bestFuncMatch(Entry[] candidates, FuncInfo callSig, Object[] args) {
        if (candidates.length <= 1) {
            return candidates;
        }
        Entry[] entryArray = candidates;
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry candidateBest = entryArray[n];
            boolean betterThanAll = true;
            Entry[] entryArray2 = candidates;
            int n3 = 0;
            int n4 = entryArray2.length;
            while (n3 < n4) {
                Entry candidate = entryArray2[n3];
                if (candidate != candidateBest && !TypeManager.betterFuncMatch(candidateBest.type.getFuncInfo(), candidate.type.getFuncInfo(), callSig, args)) {
                    betterThanAll = false;
                    break;
                }
                ++n3;
            }
            if (betterThanAll) {
                Entry[] e = new Entry[]{candidateBest};
                return e;
            }
            ++n;
        }
        return candidates;
    }

    public static Entry[] applicableFuncs(Entry[] candidates, FuncInfo callSig, Object[] args) {
        if (candidates.length == 0) {
            return candidates;
        }
        ArrayList<Entry> applicableEntries = new ArrayList<Entry>();
        Entry[] entryArray = candidates;
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            FuncInfo candidateSig;
            Entry entry = entryArray[n];
            boolean isFunc = entry.type.isFunc();
            FuncInfo funcInfo = candidateSig = isFunc ? entry.type.getFuncInfo() : null;
            if (isFunc && callSig.numArgs() >= candidateSig.numRequiredArgs() && callSig.numArgs() <= candidateSig.numArgs()) {
                boolean conversionsExist = true;
                int a = 0;
                while (a < callSig.numArgs() && conversionsExist) {
                    if (!TypeManager.existsImplicitConversion(callSig.getParamTypes()[a], candidateSig.getParamTypes()[a], new Value(args[a]))) {
                        conversionsExist = false;
                    }
                    ++a;
                }
                if (conversionsExist) {
                    applicableEntries.add(entry);
                }
            }
            ++n;
        }
        return Entry.toArray(applicableEntries);
    }

    public static Entry[] resolveOverload(Entry[] candidates, FuncInfo callSig, Object[] args) {
        if (callSig == null) {
            return candidates;
        }
        Entry[] applicable = TypeManager.applicableFuncs(candidates, callSig, args);
        if (applicable.length <= 1) {
            return applicable;
        }
        return TypeManager.bestFuncMatch(applicable, callSig, args);
    }

    public static Entry[] getUserDefinedOverloadOperatorsOf(TypeSpec t, String opname, FuncInfo callSig, Object[] args) {
        if (!t.isClass() && !t.isBuiltinClass()) {
            return new Entry[0];
        }
        boolean foundOperators = false;
        Entry[] ops = null;
        ArrayList<Entry> candidates = null;
        TypeSpec classType = t;
        while (classType != null && !classType.isBuiltinObject() && !foundOperators) {
            ops = classType.getClassInfo().getDeclaredEntries(opname);
            ops = TypeManager.applicableFuncs(ops, callSig, args);
            candidates = new ArrayList<Entry>();
            if (ops.length > 0) {
                Entry[] entryArray = ops;
                int n = 0;
                int n2 = entryArray.length;
                while (n < n2) {
                    Entry e = entryArray[n];
                    if (e.isStatic() && !e.isAbstract()) {
                        candidates.add(e);
                    }
                    ++n;
                }
            }
            if (candidates.size() > 0) {
                foundOperators = true;
                continue;
            }
            classType = classType.getClassInfo().getBaseClass();
        }
        return Entry.toArray(candidates);
    }

    public static Entry[] resolveOperatorOverload(String opname, FuncInfo callSig, Object[] args) {
        Debug.Assert(callSig != null, "callSig required");
        FuncInfo newCallSig = new FuncInfo(callSig);
        Object[] newArgs = (Object[])args.clone();
        int a = 0;
        while (a < newCallSig.numArgs()) {
            TypeSpec ptype = newCallSig.getParamTypes()[a];
            if (ptype.isAny() || ptype.isNum()) {
                newArgs[a] = TypeSpec.unwrapAnyOrNum(newArgs[a]);
                newCallSig.getParamTypes()[a] = TypeSpec.typeOf(newArgs[a]);
            }
            ++a;
        }
        ArrayList<Entry> candidates = new ArrayList<Entry>();
        int a2 = 0;
        while (a2 < newCallSig.numArgs()) {
            TypeSpec ptype = newCallSig.getParamTypes()[a2];
            boolean seen = false;
            int p = 0;
            while (p < a2 && !seen) {
                if (newCallSig.getParamTypes()[p].equals(ptype)) {
                    seen = true;
                }
                ++p;
            }
            Entry[] ops = new Entry[]{};
            if (!seen) {
                ops = TypeManager.getUserDefinedOverloadOperatorsOf(ptype, opname, newCallSig, args);
            }
            Entry[] entryArray = ops;
            int n = 0;
            int n2 = entryArray.length;
            while (n < n2) {
                Entry e = entryArray[n];
                candidates.add(e);
                ++n;
            }
            ++a2;
        }
        return TypeManager.bestFuncMatch(Entry.toArray(candidates), callSig, args);
    }

    protected static class ConvOperator {
        public TypeSpec declaringType;
        public Entry methodEntry;

        public ConvOperator(TypeSpec t, Entry e) {
            this.declaringType = t;
            this.methodEntry = e;
        }

        public TypeSpec from() {
            return TypeManager.conversionOperatorFromType(this.declaringType, this.methodEntry);
        }

        public TypeSpec to() {
            return TypeManager.conversionOperatorToType(this.declaringType, this.methodEntry);
        }
    }
}

