/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import java.util.ArrayList;
import scigol.Class;
import scigol.ClassScope;
import scigol.Debug;
import scigol.Entry;
import scigol.FuncInfo;
import scigol.Location;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeSpec;

public class Symbol {
    protected Scope _scope;
    protected Entry[] _entries;
    protected Object _instance;
    protected Location _location;

    public Symbol(Scope scope, String id, Object instance) {
        this.init(scope, id, instance);
    }

    public Symbol(Scope scope, String id) {
        this.init(scope, id, null);
    }

    public Location getDefinitionLocation() {
        if (this._location != null) {
            return this._location;
        }
        return new Location();
    }

    public void setDefinitionLocation(Location value) {
        this._location = value;
    }

    protected void init(Scope scope, String id, Object instance) {
        Debug.Assert(id != null);
        this._location = null;
        this._scope = scope;
        this._instance = instance;
        this._entries = scope.lookup(id, null, null, instance);
    }

    public Object getValue() {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        if (this.getEntry().isProperty()) {
            return this.getValue(new FuncInfo(), new Object[0]);
        }
        if (this.isAmbiguous()) {
            ScigolTreeParser.semanticError(this._location, "the name '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
        }
        Entry _entry = this._entries[0];
        if (_entry.scope.isClassScope()) {
            if (!_entry.isStatic()) {
                Debug.Assert(this._instance != null, "need an instance for instance member access to " + _entry.name + " in scope:\n" + this._scope);
            }
            return Class.getMemberValue(_entry, this._instance);
        }
        return _entry.getStaticValue();
    }

    public void setValue(Object value) {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        if (this.getEntry().isProperty()) {
            this.setValue(new FuncInfo(), new Object[0], value);
            return;
        }
        if (this.isAmbiguous()) {
            ScigolTreeParser.semanticError(this._location, "the name '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
        }
        Entry _entry = this._entries[0];
        if (_entry.scope.isClassScope()) {
            if (!_entry.isStatic()) {
                Debug.Assert(this._instance != null, "need an instance for instance member access to " + _entry.name + " in scope:\n" + this._scope);
            }
            Class.setMemberValue(_entry, value, this._instance);
        } else {
            _entry.setStaticValue(value);
        }
    }

    public Object getValue(FuncInfo callSig, Object[] args) {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        Debug.Assert(this._entries[0].isProperty(), "symbol isn't a property!");
        Entry entry = this._entries[0];
        if (this.isAmbiguous()) {
            FuncInfo accessorCallSig;
            String propName = this._entries[0].name;
            String accessorName = FuncInfo.accessorName(propName, true);
            Entry[] entries = this._scope.lookup(accessorName, accessorCallSig = callSig.accessorSig("get", TypeSpec.anyTypeSpec), args, this._instance);
            if (entries.length > 1) {
                ScigolTreeParser.semanticError(this._location, "the property '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
            } else if (entries.length == 0) {
                ScigolTreeParser.semanticError(this._location, "a property '" + this.getName() + "' compatible with the call signature " + accessorCallSig + " could not be found in the current context. Candidates are:\n" + this.entriesToString());
            }
            Entry accessorEntry = entries[0];
            entry = accessorEntry.propertyEntry;
        }
        return Class.getPropertyValue(entry, callSig, args, this._instance);
    }

    public void setValue(FuncInfo callSig, Object[] args, Object value) {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        Debug.Assert(this._entries[0].isProperty(), "symbol isn't a property!");
        Entry entry = this._entries[0];
        if (this.isAmbiguous()) {
            String propName = this._entries[0].name;
            String accessorName = FuncInfo.accessorName(propName, false);
            FuncInfo accessorCallSig = callSig.accessorSig("set", TypeSpec.typeOf(value));
            Object[] accessorArgs = new Object[args.length + 1];
            int i = 0;
            while (i < args.length) {
                accessorArgs[i] = args[i];
                ++i;
            }
            accessorArgs[args.length] = value;
            Entry[] entries = this._scope.lookup(accessorName, accessorCallSig, accessorArgs, this._instance);
            if (entries.length > 1) {
                ScigolTreeParser.semanticError(this._location, "the property '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
            } else if (entries.length == 0) {
                ScigolTreeParser.semanticError(this._location, "a property '" + this.getName() + "' compatible with the call signature " + accessorCallSig + " could not be found in the current context. Candidates are:\n" + this.entriesToString());
            }
            Entry accessorEntry = entries[0];
            entry = accessorEntry.propertyEntry;
        }
        Class.setPropertyValue(entry, callSig, args, value, this._instance);
    }

    public TypeSpec getType(FuncInfo callSig, Object[] args) {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        Debug.Assert(this._entries[0].isProperty(), "symbol isn't a property!");
        Entry entry = this._entries[0];
        if (this.isAmbiguous()) {
            FuncInfo accessorCallSig;
            String propName = this._entries[0].name;
            String accessorName = FuncInfo.accessorName(propName, true);
            Entry[] entries = this._scope.lookup(accessorName, accessorCallSig = callSig.accessorSig("get", TypeSpec.anyTypeSpec), args, this._instance);
            if (entries.length > 1) {
                ScigolTreeParser.semanticError(this._location, "the property '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
            } else if (entries.length == 0) {
                ScigolTreeParser.semanticError(this._location, "a property '" + this.getName() + "' compatible with the call signature " + accessorCallSig + " could not be found in the current context. Candidates are:\n" + this.entriesToString());
            }
            Entry accessorEntry = entries[0];
            Debug.Assert(accessorEntry.isAccessor(), "prop isn't connected to an accessor!");
            entry = accessorEntry.propertyEntry;
        }
        return entry.type;
    }

    public TypeSpec getType() {
        Debug.Assert(this.exists(), "symbol doesn't exist");
        if (this.isAmbiguous()) {
            ScigolTreeParser.semanticError(this._location, "the name '" + this.getName() + "' is ambiguous in the current context. Candidates are:\n" + this.entriesToString());
        }
        Entry entry = this._entries[0];
        return entry.type;
    }

    public Entry getEntry() {
        Debug.Assert(this.exists(), "can't get entry of non-existent symbol");
        Debug.Assert(!this.isAmbiguous(), "can't get entry until overload resolution performed");
        return this._entries[0];
    }

    public void disambiguate(FuncInfo callSig, Object[] args) {
        if (!this.isAmbiguous()) {
            return;
        }
        String name = this._entries[0].name;
        this._entries = this._scope.lookup(name, callSig, args, this._instance);
        if (this._entries.length != 1) {
            if (this._entries.length == 0) {
                ScigolTreeParser.semanticError(this._location, "the name '" + name + "' cannot be found with a signature matching " + callSig);
            }
            ScigolTreeParser.semanticError(this._location, "the name '" + name + "' is ambiguous when called with signature " + callSig);
        }
    }

    public void disambiguate(FuncInfo callSig, ArrayList args) {
        Object[] aargs = new Object[args.size()];
        int a = 0;
        while (a < args.size()) {
            aargs[a] = args.get(a);
            ++a;
        }
        this.disambiguate(callSig, aargs);
    }

    public boolean isAmbiguous() {
        return this._entries.length > 1;
    }

    public boolean exists() {
        return this._entries.length > 0;
    }

    public Scope getScope() {
        return this._scope;
    }

    public String getName() {
        return this._entries[0].name;
    }

    public Object getInstance() {
        return this._instance;
    }

    public String toString() {
        if (this._location != null) {
            return String.valueOf(this._location.isKnown() ? "[" + this._location.toString() + "] " : "") + this.getName() + ":" + this.getType() + " = " + this.getValue();
        }
        return String.valueOf(this.getName()) + ":" + this.getType() + " = " + this.getValue();
    }

    protected String entriesToString() {
        String err = "";
        int c = 0;
        while (c < this._entries.length) {
            Entry e = this._entries[c];
            err = String.valueOf(err) + " " + e.name;
            if (e.location != null && e.location.isKnown()) {
                err = String.valueOf(err) + "[" + e.location.toString() + "]";
            }
            err = String.valueOf(err) + " :" + e.type;
            if (e.scope.isClassScope()) {
                err = String.valueOf(err) + " in " + ((ClassScope)e.scope).getClassType();
            }
            if (c != this._entries.length - 1) {
                err = String.valueOf(err) + "\n";
            }
            ++c;
        }
        return err;
    }
}

