/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import scigol.Any;
import scigol.Debug;
import scigol.Entry;
import scigol.Func;
import scigol.FuncInfo;
import scigol.Num;
import scigol.ScigolTreeParser;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;

public class Math {
    public static Value performOverloadedOperation(String opname, Value lhs, Value rhs) {
        Debug.Assert(!opname.equals("operator->"), "the conversion operator 'operator->' is handled through, TypeManager.performUserDefinedConversion()");
        TypeSpec tlhs = lhs != null ? TypeSpec.typeOf(lhs) : new TypeSpec(TypeSpec.anyType);
        TypeSpec trhs = rhs != null ? TypeSpec.typeOf(rhs) : new TypeSpec(TypeSpec.anyType);
        boolean binary = TypeSpec.isBinaryOperator(opname);
        if ((opname.equals("operator+") || opname.equals("operator-")) && (lhs == null || rhs == null)) {
            binary = false;
        }
        TypeSpec[] paramTypes = new TypeSpec[binary ? 2 : 1];
        Object[] args = new Object[binary ? 2 : 1];
        if (binary) {
            paramTypes[0] = tlhs;
            args[0] = lhs.getValue();
            paramTypes[1] = trhs;
            args[1] = rhs.getValue();
        } else if (lhs != null) {
            paramTypes[0] = tlhs;
            args[0] = lhs.getValue();
        } else {
            paramTypes[0] = trhs;
            args[0] = rhs.getValue();
        }
        FuncInfo callSig = new FuncInfo(paramTypes, new TypeSpec(TypeSpec.anyType));
        Entry[] ops = TypeManager.resolveOperatorOverload(opname, callSig, args);
        if (ops.length > 1) {
            ScigolTreeParser.semanticError("call of overloaded operator '" + opname + "' is ambiguous for signature " + callSig);
        }
        if (ops.length == 1) {
            Func opFunc = (Func)ops[0].getStaticValue();
            Debug.Assert(opFunc != null, "no Func to call!");
            args = opFunc.getInfo().convertParameters(callSig, args, opFunc.isExternal());
            Object result = opFunc.call(null, args);
            return new Value(result);
        }
        if (tlhs.isBuiltin() || trhs.isBuiltin()) {
            if (tlhs.isAny() && lhs != null && lhs.getValue() != null) {
                lhs = new Value(((Any)lhs.getValue()).value);
                tlhs = TypeSpec.typeOf(lhs);
            }
            if (trhs.isAny() && rhs != null && rhs.getValue() != null) {
                rhs = new Value(((Any)rhs.getValue()).value);
                trhs = TypeSpec.typeOf(rhs);
            }
            if (binary && opname.equals("operator+") && tlhs.isString()) {
                String lhsString = lhs.getValue() != null ? (String)lhs.getValue() : "null";
                String rhsString = null;
                if (rhs.getValue() == null) {
                    rhsString = "null";
                } else if (!trhs.isString()) {
                    if (trhs.isBuiltin()) {
                        rhsString = rhs.getValue().toString();
                    } else {
                        Value o = TypeManager.performExplicitConversion(trhs, tlhs, rhs);
                        if (o instanceof Value) {
                            rhsString = (String)o.getValue();
                        } else {
                            ScigolTreeParser.semanticError("no conversion to string");
                        }
                    }
                } else {
                    rhsString = (String)rhs.getValue();
                }
                if (rhsString == null) {
                    rhsString = "null";
                }
                return new Value(String.valueOf(lhsString) + rhsString);
            }
            if (binary && (opname.equals("operator==") || opname.equals("operator!=")) && tlhs.isString()) {
                boolean equality = opname.equals("operator==");
                if (lhs.getValue() == null) {
                    if (equality) {
                        return new Value(rhs.getValue() == null);
                    }
                    return new Value(rhs.getValue() != null);
                }
                if (rhs.getValue() == null) {
                    if (equality) {
                        return new Value(lhs.getValue() == null);
                    }
                    return new Value(lhs.getValue() != null);
                }
                String lhsString = (String)lhs.getValue();
                String rhsString = null;
                if (!trhs.isString()) {
                    if (trhs.isBuiltin()) {
                        rhsString = rhs.getValue().toString();
                    } else {
                        Value o = TypeManager.performExplicitConversion(trhs, tlhs, rhs);
                        if (o instanceof Value) {
                            rhsString = (String)o.getValue();
                        } else {
                            ScigolTreeParser.semanticError("no conversion to string");
                        }
                    }
                } else {
                    rhsString = (String)rhs.getValue();
                }
                if (rhsString == null) {
                    return new Value(!equality);
                }
                boolean result = lhsString.equals(rhsString);
                if (!equality) {
                    result = !result;
                }
                return new Value(result);
            }
            if (!binary && opname == "operator#" && trhs.isString()) {
                if (rhs.getValue() == null) {
                    return new Value(0);
                }
                String rhsString = (String)rhs.getValue();
                return new Value(new Integer(rhsString.length()));
            }
            if ((lhs == null || tlhs.isANum()) && (rhs == null || trhs.isANum())) {
                if (tlhs.isNum() && lhs != null && lhs.getValue() != null) {
                    lhs = new Value(((Num)lhs.getValue()).value);
                    tlhs = TypeSpec.typeOf(lhs);
                }
                if (trhs.isNum() && rhs != null && rhs.getValue() != null) {
                    rhs = new Value(((Num)rhs.getValue()).value);
                    trhs = TypeSpec.typeOf(rhs);
                }
                boolean typesIdentical = true;
                if (binary && !tlhs.equals(trhs)) {
                    if (TypeManager.encompasses(tlhs, trhs)) {
                        rhs = TypeManager.performImplicitConversion(trhs, tlhs, rhs);
                        trhs = tlhs;
                    } else if (TypeManager.encompasses(trhs, tlhs)) {
                        lhs = TypeManager.performImplicitConversion(tlhs, trhs, lhs);
                        tlhs = trhs;
                    } else {
                        typesIdentical = false;
                    }
                }
                if (typesIdentical) {
                    TypeSpec.Operator op = TypeSpec.operatorByName(opname);
                    if (!binary) {
                        if (opname.equals("operator+")) {
                            op = TypeSpec.Operator.UnaryPlus;
                        }
                        if (opname.equals("operator-")) {
                            op = TypeSpec.Operator.UnaryNegation;
                        }
                    }
                    if (binary) {
                        return new Value(Math.performBuiltinOperator(tlhs, lhs.getValue(), rhs.getValue(), op));
                    }
                    TypeSpec t = lhs == null ? trhs : tlhs;
                    Object v = lhs == null ? rhs.getValue() : lhs.getValue();
                    return new Value(Math.performBuiltinOperator(t, v, v, op));
                }
            }
        }
        ScigolTreeParser.semanticError("no suitable operator '" + opname + "' could be found for call with signature " + callSig);
        return null;
    }

    protected static Object performBuiltinOperator(TypeSpec t, Object l, Object r, TypeSpec.Operator op) {
        switch (op) {
            case Multiply: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l * (Byte)r));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() * ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l * (Integer)r);
                }
                if (t.isDint()) {
                    return new Long((Long)l * (Long)r);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() * ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double((Double)l * (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case Division: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l / (Byte)r));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() / ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l / (Integer)r);
                }
                if (t.isDint()) {
                    return new Long((Long)l / (Long)r);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() / ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double((Double)l / (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case Modulus: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l % (Byte)r));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() % ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l % (Integer)r);
                }
                if (t.isDint()) {
                    return new Long((Long)l % (Long)r);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() % ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double((Double)l % (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case Addition: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l + (Byte)r));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() + ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l + (Integer)r);
                }
                if (t.isDint()) {
                    return new Long((Long)l + (Long)r);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() + ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double((Double)l + (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case Subtraction: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l - (Byte)r));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() - ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l - (Integer)r);
                }
                if (t.isDint()) {
                    return new Long((Long)l - (Long)r);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() - ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double((Double)l - (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case LessThan: {
                if (t.isByte()) {
                    return new Boolean((Byte)l < (Byte)r);
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() < ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean((Integer)l < (Integer)r);
                }
                if (t.isDint()) {
                    return new Boolean((Long)l < (Long)r);
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() < ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean((Double)l < (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case GreaterThan: {
                if (t.isByte()) {
                    return new Boolean((Byte)l > (Byte)r);
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() > ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean((Integer)l > (Integer)r);
                }
                if (t.isDint()) {
                    return new Boolean((Long)l > (Long)r);
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() > ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean((Double)l > (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case LessThanOrEqual: {
                if (t.isByte()) {
                    return new Boolean((Byte)l <= (Byte)r);
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() <= ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean((Integer)l <= (Integer)r);
                }
                if (t.isDint()) {
                    return new Boolean((Long)l <= (Long)r);
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() <= ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean((Double)l <= (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case GreaterThanOrEqual: {
                if (t.isByte()) {
                    return new Boolean((Byte)l >= (Byte)r);
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() >= ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean((Integer)l >= (Integer)r);
                }
                if (t.isDint()) {
                    return new Boolean((Long)l >= (Long)r);
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() >= ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean((Double)l >= (Double)r);
                }
                Debug.Assert(false);
                break;
            }
            case Equality: {
                if (t.isByte()) {
                    return new Boolean(((Byte)l).byteValue() == ((Byte)r).byteValue());
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() == ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean(((Integer)l).intValue() == ((Integer)r).intValue());
                }
                if (t.isDint()) {
                    return new Boolean(((Long)l).longValue() == ((Long)r).longValue());
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() == ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean(((Double)l).doubleValue() == ((Double)r).doubleValue());
                }
                Debug.Assert(false);
                break;
            }
            case Inequality: {
                if (t.isByte()) {
                    return new Boolean(((Byte)l).byteValue() != ((Byte)r).byteValue());
                }
                if (t.isChar()) {
                    return new Boolean(((Character)l).charValue() != ((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Boolean(((Integer)l).intValue() != ((Integer)r).intValue());
                }
                if (t.isDint()) {
                    return new Boolean(((Long)l).longValue() != ((Long)r).longValue());
                }
                if (t.isSreal()) {
                    return new Boolean(((Float)l).floatValue() != ((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Boolean(((Double)l).doubleValue() != ((Double)r).doubleValue());
                }
                Debug.Assert(false);
                break;
            }
            case UnaryPlus: {
                if (t.isByte()) {
                    return r;
                }
                if (t.isChar()) {
                    return r;
                }
                if (t.isInt()) {
                    return r;
                }
                if (t.isDint()) {
                    return r;
                }
                if (t.isSreal()) {
                    return r;
                }
                if (t.isReal()) {
                    return r;
                }
                Debug.Assert(false);
                break;
            }
            case UnaryNegation: {
                if (t.isByte()) {
                    return new Byte(-((Byte)r).byteValue());
                }
                if (t.isChar()) {
                    return new Character(-((Character)r).charValue());
                }
                if (t.isInt()) {
                    return new Integer(-((Integer)r).intValue());
                }
                if (t.isDint()) {
                    return new Long(-((Long)r).longValue());
                }
                if (t.isSreal()) {
                    return new Float(-((Float)r).floatValue());
                }
                if (t.isReal()) {
                    return new Double(-((Double)r).doubleValue());
                }
                Debug.Assert(false);
                break;
            }
            case Increment: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l + 1));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() + '\u0001'));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l + 1);
                }
                if (t.isDint()) {
                    return new Long((Long)l + 1L);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() + 1.0f);
                }
                if (t.isReal()) {
                    return new Double((Double)l + 1.0);
                }
                Debug.Assert(false);
                break;
            }
            case Decrement: {
                if (t.isByte()) {
                    return new Byte((byte)((Byte)l - 1));
                }
                if (t.isChar()) {
                    return new Character((char)(((Character)l).charValue() - '\u0001'));
                }
                if (t.isInt()) {
                    return new Integer((Integer)l - 1);
                }
                if (t.isDint()) {
                    return new Long((Long)l - 1L);
                }
                if (t.isSreal()) {
                    return new Float(((Float)l).floatValue() - 1.0f);
                }
                if (t.isReal()) {
                    return new Double((Double)l - 1.0);
                }
                Debug.Assert(false);
                break;
            }
            case Norm: {
                if (t.isByte()) {
                    return new Byte((byte)java.lang.Math.abs(((Byte)l).byteValue()));
                }
                if (t.isChar()) {
                    return new Character((char)java.lang.Math.abs(((Character)l).charValue()));
                }
                if (t.isInt()) {
                    return new Integer(java.lang.Math.abs((Integer)l));
                }
                if (t.isDint()) {
                    return new Long(java.lang.Math.abs((Long)l));
                }
                if (t.isSreal()) {
                    return new Float(java.lang.Math.abs(((Float)l).floatValue()));
                }
                if (t.isReal()) {
                    return new Double(java.lang.Math.abs((Double)l));
                }
                Debug.Assert(false);
                break;
            }
            case Cardinality: {
                return new Integer(1);
            }
            case Power: {
                if (t.isByte()) {
                    return new Double(java.lang.Math.pow(((Byte)l).byteValue(), ((Byte)r).byteValue()));
                }
                if (t.isChar()) {
                    return new Double(java.lang.Math.pow(((Character)l).charValue(), ((Character)r).charValue()));
                }
                if (t.isInt()) {
                    return new Double(java.lang.Math.pow(((Integer)l).intValue(), ((Integer)r).intValue()));
                }
                if (t.isDint()) {
                    return new Double(java.lang.Math.pow(((Long)l).longValue(), ((Long)r).longValue()));
                }
                if (t.isSreal()) {
                    return new Double(java.lang.Math.pow(((Float)l).floatValue(), ((Float)r).floatValue()));
                }
                if (t.isReal()) {
                    return new Double(java.lang.Math.pow((Double)l, (Double)r));
                }
                Debug.Assert(false);
                break;
            }
            case Prime: {
                return new Integer(1);
            }
            default: {
                Debug.Assert(false, "bad/unknown/unimplemented operator");
            }
        }
        return null;
    }

    protected static Value callOverloadedOperator(Value v1, Value v2, String opname) {
        Debug.Depricated("Math.callOverloadedOperator");
        return null;
    }

    public static Value plus(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value minus(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value unaryminus(Value v1) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value multiply(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value divide(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value modulo(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value card(Value v1) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value norm(Value v1) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value power(Value v1, Value v2) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value prime(Value v1) {
        Debug.Depricated("Math.<operation>");
        return null;
    }

    public static Value equality(Value v1, Value v2) {
        Value ov = Math.callOverloadedOperator(v1, v2, "operator==");
        if (ov != null) {
            return ov;
        }
        Object n1 = v1.getValue();
        Object n2 = v2.getValue();
        if (n1 instanceof Comparable && n1.getClass().equals(n2.getClass())) {
            Comparable c1 = (Comparable)n1;
            return new Value(new Boolean(c1.compareTo(n2) == 0));
        }
        if (n1 instanceof Integer) {
            if (n2 instanceof Integer) {
                return new Value(new Boolean(((Integer)n1).intValue() == ((Integer)n2).intValue()));
            }
            if (n2 instanceof Long) {
                return new Value(new Boolean((long)((Integer)n1).intValue() == (Long)n2));
            }
            if (n2 instanceof Double) {
                return new Value(new Boolean((double)((Integer)n1).intValue() == (Double)n2));
            }
            if (n2 instanceof Float) {
                return new Value(new Boolean((float)((Integer)n1).intValue() == ((Float)n2).floatValue()));
            }
            ScigolTreeParser.semanticError("type " + TypeSpec.typeName(n2) + " cannot appear on the RHS of binary ==");
        } else if (n1 instanceof Long) {
            if (n2 instanceof Integer) {
                return new Value(new Boolean(((Long)n1).longValue() == ((Integer)n2).longValue()));
            }
            if (n2 instanceof Long) {
                return new Value(new Boolean(((Long)n1).longValue() == ((Long)n2).longValue()));
            }
            if (n2 instanceof Double) {
                return new Value(new Boolean(((Long)n1).longValue() == ((Double)n2).longValue()));
            }
            if (n2 instanceof Float) {
                return new Value(new Boolean(((Long)n1).longValue() == ((Float)n2).longValue()));
            }
            ScigolTreeParser.semanticError("type " + TypeSpec.typeName(n2) + " cannot appear on the RHS of binary ==");
        } else if (n1 instanceof Double) {
            if (n2 instanceof Integer) {
                return new Value(new Boolean(((Double)n1).doubleValue() == ((Integer)n2).doubleValue()));
            }
            if (n2 instanceof Long) {
                return new Value(new Boolean(((Double)n1).doubleValue() == ((Long)n2).doubleValue()));
            }
            if (n2 instanceof Double) {
                return new Value(new Boolean(((Double)n1).doubleValue() == ((Double)n2).doubleValue()));
            }
            if (n2 instanceof Float) {
                return new Value(new Boolean(((Double)n1).doubleValue() == ((Float)n2).doubleValue()));
            }
            ScigolTreeParser.semanticError("type " + TypeSpec.typeName(n2) + " cannot appear on the RHS of binary ==");
        } else if (n1 instanceof Float) {
            if (n2 instanceof Integer) {
                return new Value(new Boolean(((Float)n1).floatValue() == ((Integer)n2).floatValue()));
            }
            if (n2 instanceof Long) {
                return new Value(new Boolean(((Float)n1).floatValue() == ((Long)n2).floatValue()));
            }
            if (n2 instanceof Double) {
                return new Value(new Boolean(((Float)n1).floatValue() == ((Double)n2).floatValue()));
            }
            if (n2 instanceof Float) {
                return new Value(new Boolean(((Float)n1).floatValue() == ((Float)n2).floatValue()));
            }
            ScigolTreeParser.semanticError("type " + TypeSpec.typeName(n2) + " cannot appear on the RHS of binary ==");
        }
        ScigolTreeParser.semanticError("type " + TypeSpec.typeName(n1) + " cannot appear on the LHS of binary ==");
        return null;
    }

    public static Value inequality(Value v1, Value v2) {
        Value ov = Math.callOverloadedOperator(v1, v2, "operator!=");
        if (ov != null) {
            return ov;
        }
        Object n1 = v1.getValue();
        Object n2 = v2.getValue();
        if (n1 instanceof Comparable && n1.getClass().equals(n2.getClass())) {
            Comparable c1 = (Comparable)n1;
            return new Value(new Boolean(c1.compareTo(n2) != 0));
        }
        Value eq = Math.equality(v1, v2);
        return new Value(new Boolean((Boolean)eq.getValue() == false));
    }

    public static int compareTo(Value v1, Value v2) {
        TypeSpec t2;
        TypeSpec t1 = TypeSpec.typeOf(v1);
        if (t1.isConvertableTo(t2 = TypeSpec.typeOf(v2))) {
            v1 = TypeSpec.convertTo(t2, v1);
            t1 = t2;
        } else if (t2.isConvertableTo(t1)) {
            v2 = TypeSpec.convertTo(t1, v2);
            t2 = t1;
        } else {
            ScigolTreeParser.semanticError("can't compare objects of type '" + t1 + "' and '" + t2 + "'.");
        }
        Object o1 = v1.getValue();
        Object o2 = v2.getValue();
        if (o1 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o2 instanceof Comparable) {
            Comparable c2 = (Comparable)o2;
            return -c2.compareTo(o1);
        }
        ScigolTreeParser.semanticError("can't compare objects of type '" + t1 + "' and '" + t2 + "'.");
        return 0;
    }

    public static boolean isLogicalTrue(Value v) {
        TypeSpec boolType;
        if (v.getValue() instanceof Boolean) {
            return (Boolean)v.getValue();
        }
        TypeSpec ot = TypeSpec.typeOf(v);
        if (!TypeManager.existsImplicitConversion(ot, boolType = new TypeSpec(TypeSpec.boolType), v)) {
            ScigolTreeParser.semanticError("can't convert type '" + ot + "' to type 'bool'");
        }
        return (Boolean)TypeManager.performImplicitConversion(ot, boolType, v).getValue();
    }
}

