/*
 * Decompiled with CFR 0.152.
 */
package scigol;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import scigol.Any;
import scigol.Class;
import scigol.Debug;
import scigol.Entry;
import scigol.FuncInfo;
import scigol.LocalScope;
import scigol.ScigolTreeParser;
import scigol.Scope;
import scigol.TypeManager;
import scigol.TypeSpec;
import scigol.Value;

public class Func {
    protected Scope _scope;
    protected FuncType _funcType;
    protected FuncInfo _info;
    protected ScigolTreeParser _treeParser;
    protected AST _expr;
    protected AST _pre;
    protected AST _post;
    protected boolean _isConstructor;
    protected Type _classType;
    protected Member _member;

    public Func(FuncInfo info, Scope outerScope, ScigolTreeParser treeParser, AST body, AST preCondition, AST postCondition) {
        Debug.Assert(info.isFormal(), "can only construct a func value with an info that has formal parameter names");
        Debug.Assert(body == null || outerScope != null, "scope required for local (non-null) funcs");
        this._funcType = FuncType.Local;
        this._info = info;
        this._scope = outerScope;
        this._treeParser = treeParser;
        this._expr = body;
        this._pre = preCondition;
        this._post = postCondition;
        this._isConstructor = false;
    }

    public Func(Type classType, Member member) {
        this._funcType = FuncType.External;
        this._scope = null;
        this._classType = classType;
        this._member = member;
        this._isConstructor = member instanceof Constructor;
    }

    public Scope getOuterScope() {
        return this._scope;
    }

    public FuncInfo getInfo() {
        if (this._funcType == FuncType.Local) {
            return this._info;
        }
        return new FuncInfo(this._member);
    }

    public void setInfo(FuncInfo value) {
        if (this._funcType == FuncType.Local) {
            this._info = value;
        } else {
            Debug.Unimplemented();
        }
    }

    public ScigolTreeParser getParser() {
        return this._treeParser;
    }

    public AST getValue() {
        Debug.Assert(this._funcType == FuncType.Local);
        return this._expr;
    }

    public void setValue(AST value) {
        Debug.Assert(this._funcType == FuncType.Local);
        this._expr = value;
    }

    public boolean isExternal() {
        return this._funcType == FuncType.External;
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }

    public void setIsConstructor(boolean value) {
        this._isConstructor = value;
        Debug.Assert(this._scope.isClassScope(), "func can't be a constructor if it wasn't defined in a class scope!");
    }

    public Object call(Object instance, Object[] args) {
        if (this._funcType == FuncType.Local) {
            LocalScope callScope = new LocalScope(this._scope);
            Scope savedScope = this._treeParser.scope;
            this._treeParser.scope = callScope;
            if (instance != null) {
                Debug.Assert(this._scope.isClassScope(), "can only have instances of classes");
                callScope.addEntry("this", TypeSpec.typeOf(instance), instance, null, EnumSet.of(TypeSpec.Modifier.Public));
            }
            String[] pnames = this._info.getParamNames();
            TypeSpec[] ptypes = this._info.getParamTypes();
            int numArgs = args == null ? 0 : args.length;
            Debug.Assert(numArgs == this._info.numArgs(), "call must have correct args");
            int a = 0;
            while (a < this._info.numArgs()) {
                callScope.addEntry(pnames[a], ptypes[a], args[a], null, EnumSet.of(TypeSpec.Modifier.Public));
                ++a;
            }
            TypeSpec boolType = new TypeSpec(TypeSpec.boolType);
            if (this._pre != null) {
                boolean pre;
                TypeSpec t;
                Value preValue = null;
                try {
                    preValue = this._treeParser.expressionList(this._pre, false);
                }
                catch (RecognitionException e) {
                    ScigolTreeParser.semanticError("error evaluating pre-condition in func " + this._info + " - " + e.getMessage(), (Exception)((Object)e));
                }
                if (!(preValue instanceof Value)) {
                    preValue = new Value(preValue);
                }
                if (!TypeManager.existsImplicitConversion(t = TypeSpec.typeOf((Object)preValue), boolType, preValue)) {
                    ScigolTreeParser.semanticError("a precondition expression must evaluate to type 'bool' (in func " + this._info + ")");
                }
                if (!(pre = ((Boolean)TypeManager.performImplicitConversion(t, boolType, preValue).getValue()).booleanValue())) {
                    ScigolTreeParser.semanticError("unmet pre-condition in func " + this._info);
                }
            }
            Object retValue = new Any(null);
            if (this._expr != null) {
                retValue = null;
                try {
                    retValue = this._treeParser.expressionList(this._expr, false);
                }
                catch (RecognitionException e) {
                    ScigolTreeParser.semanticError("error in function " + this._info + " - " + e.getMessage(), (Exception)((Object)e));
                }
                if (retValue instanceof Value) {
                    retValue = ((Value)retValue).getValue();
                }
                if (this._isConstructor) {
                    retValue = instance;
                } else if (this._info.getReturnType() == null) {
                    retValue = null;
                } else if (retValue != null && !TypeManager.existsImplicitConversion(TypeSpec.typeOf(retValue), this._info.getReturnType(), new Value(retValue))) {
                    ScigolTreeParser.semanticError("func " + this._info + " evaluated to a value of type '" + TypeSpec.typeOf(retValue) + "' when the return type '" + this._info.getReturnType() + "' was expected");
                }
            }
            if (this._post != null) {
                Entry[] entries;
                boolean post;
                TypeSpec t;
                Value value = new Value(retValue);
                callScope.addEntry("value", TypeSpec.typeOf(value), retValue, null, EnumSet.of(TypeSpec.Modifier.Public));
                Value postValue = null;
                try {
                    postValue = this._treeParser.expressionList(this._post, false);
                }
                catch (RecognitionException e) {
                    ScigolTreeParser.semanticError("error evaluating post-condition in func " + this._info + " - " + e.getMessage(), (Exception)((Object)e));
                }
                if (!(postValue instanceof Value)) {
                    postValue = new Value(postValue);
                }
                if (!TypeManager.existsImplicitConversion(t = TypeSpec.typeOf((Object)postValue), boolType, postValue)) {
                    ScigolTreeParser.semanticError("a postcondition expression must evaluate to type 'bool' (in func " + this._info + ")");
                }
                if (!(post = ((Boolean)TypeManager.performImplicitConversion(t, boolType, postValue).getValue()).booleanValue())) {
                    ScigolTreeParser.semanticError("unmet post-condition in func " + this._info);
                }
                Debug.Assert((entries = ((Scope)callScope).getEntries("value", null)).length == 1, "should be just one 'value' in the local callScope!");
                retValue = entries[0].getStaticValue();
            }
            this._treeParser.scope = savedScope;
            return retValue;
        }
        Object retValue = null;
        if (instance instanceof Class) {
            instance = ((Class)instance).getSysValue();
        }
        int i = 0;
        while (i < args.length) {
            Class c;
            if (args[i] instanceof Class && (c = (Class)args[i]).isExternal()) {
                args[i] = c.getSysValue();
            }
            ++i;
        }
        try {
            retValue = this._member instanceof Method ? ((Method)this._member).invoke(instance, args) : (Object)((Constructor)this._member).newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                ScigolTreeParser.semanticError("error invoking method or constructor - " + e.getCause().getMessage());
            }
            ScigolTreeParser.semanticError("error invoking method or constructor - " + e.getMessage());
        }
        catch (InstantiationException instantiationException) {
            ScigolTreeParser.semanticError("cannnot instantiate abstract class " + this._member.getDeclaringClass().getName());
        }
        catch (IllegalAccessException e) {
            ScigolTreeParser.semanticError("access error invoking method or constructor - " + e.getMessage());
        }
        return retValue;
    }

    public Object call(Object instance, ArrayList args) {
        Object[] aargs = new Object[args.size()];
        int a = 0;
        while (a < aargs.length) {
            aargs[a] = args.get(a);
            ++a;
        }
        return this.call(instance, aargs);
    }

    public String toString() {
        String s = this.getInfo().toString();
        s = this._funcType == FuncType.Local ? (this._expr != null ? String.valueOf(s) + " {...}" : String.valueOf(s) + " {null}") : (this._member != null ? String.valueOf(s) + " {...}" : String.valueOf(s) + " {null}");
        return s;
    }

    public String toStringArgs(Object[] args) {
        String s = this.getInfo().toStringArgs(args);
        s = this._funcType == FuncType.Local ? (this._expr != null ? String.valueOf(s) + " {...}" : String.valueOf(s) + " {null}") : (this._member != null ? String.valueOf(s) + " {...}" : String.valueOf(s) + " {null}");
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FuncType {
        Local,
        External;

    }
}

