/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.FormatAdapter;
import jalview.ResidueProperties;
import jalview.Sequence;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class TreeScore {
    Vector score;
    int start;
    int end;
    int step;
    int window;
    Vector selseq;
    Vector selcol;
    Sequence[] s;
    double[][] od1;
    double[][] od2;
    int oldstart1 = -1000;
    int oldstart2 = -1000;
    int oldend1 = -1000;
    int oldend2 = -1000;

    public TreeScore(Sequence[] s, int start, int end, int step, int window, Vector selseq, Vector selcol) {
        this.s = s;
        this.start = start;
        this.end = end;
        this.step = step;
        this.window = window;
        this.selseq = selseq;
        this.selcol = selcol;
        int nocols = this.countCols(selcol);
        int cfr_ignored_0 = (nocols - window) / step;
        int endi = this.findEndi();
        this.score = new Vector();
        int i = 0;
        while (i < endi) {
            System.out.println("Calculating score for position " + i);
            this.score.addElement(this.calcScore(i));
            i += step;
        }
    }

    public Vector calcScore(int start) {
        Vector<Double> out = new Vector<Double>();
        int split = start + this.window / 2 - 1;
        double[][] d1 = this.calcDistances(start, split, this.od1, this.oldstart1, this.oldend1);
        double[][] d2 = this.calcDistances(split + 1, start + this.window - 1, this.od2, this.oldstart2, this.oldend2);
        int i = 0;
        while (i < this.s.length) {
            double tmp = this.dotProd(d1[i], d2[i], this.s.length);
            out.addElement(new Double(tmp));
            ++i;
        }
        this.od1 = d1;
        this.od2 = d2;
        this.oldstart1 = start;
        this.oldend1 = split;
        this.oldstart2 = split + 1;
        this.oldend2 = start + this.window - 1;
        return out;
    }

    public double[][] calcDistances(int start, int end) {
        double[][] out = new double[this.s.length][this.s.length];
        int i = 0;
        while (i < this.s.length) {
            int j = 0;
            while (j < this.s.length) {
                out[i][j] = 0.0;
                int k = start;
                while (k <= end) {
                    double[] dArray = out[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)ResidueProperties.getBLOSUM62(this.s[i].sequence.substring(k, k + 1), this.s[j].sequence.substring(k, k + 1));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return out;
    }

    public double[][] calcDistances(int start, int end, double[][] dold, int oldstart, int oldend) {
        if (oldend > start) {
            int i = 0;
            while (i < this.s.length) {
                int j = 0;
                while (j < this.s.length) {
                    int k = oldstart;
                    while (k < start) {
                        double[] dArray = dold[i];
                        int n = j;
                        dArray[n] = dArray[n] - (double)ResidueProperties.getBLOSUM62(this.s[i].sequence.substring(k, k + 1), this.s[j].sequence.substring(k, k + 1));
                        ++k;
                    }
                    k = oldend + 1;
                    while (k <= end) {
                        double[] dArray = dold[i];
                        int n = j;
                        dArray[n] = dArray[n] + (double)ResidueProperties.getBLOSUM62(this.s[i].sequence.substring(k, k + 1), this.s[j].sequence.substring(k, k + 1));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            dold = this.calcDistances(start, end);
        }
        return dold;
    }

    public double dotProd(double[] d1, double[] d2, int m) {
        double tmp = 0.0;
        double meanx = 0.0;
        double meany = 0.0;
        double sumxy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        int j = 0;
        while (j < m) {
            meanx += d1[j];
            meany += d2[j];
            ++j;
        }
        meanx /= (double)m;
        meany /= (double)m;
        double tmp2 = 0.0;
        int j2 = 0;
        while (j2 < m) {
            sumxy += (d1[j2] - meanx) * (d2[j2] - meany);
            tmp2 += d1[j2] * d2[j2];
            ++j2;
        }
        j2 = 0;
        while (j2 < m) {
            sumx2 += (d1[j2] - meanx) * (d1[j2] - meanx);
            ++j2;
        }
        sumx2 = Math.sqrt(sumx2);
        j2 = 0;
        while (j2 < m) {
            sumy2 += (d2[j2] - meany) * (d2[j2] - meany);
            ++j2;
        }
        sumy2 = Math.sqrt(sumy2);
        tmp = sumx2 == 0.0 || sumy2 == 0.0 ? 1.0 : sumxy / (sumx2 * sumy2);
        if (tmp > 1.0) {
            tmp = 1.0;
        }
        return tmp * 100.0;
    }

    public int findEndi() {
        if (this.selcol == null) {
            return this.s[0].sequence.length() - this.window;
        }
        return this.s[0].sequence.length() - this.window;
    }

    public int countCols(Vector sel) {
        if (sel == null || sel.size() == 0) {
            return this.s[0].sequence.length();
        }
        return this.s[0].sequence.length();
    }

    public static void main(String[] args) {
        Sequence[] s = FormatAdapter.read(args[0], "File", args[1]);
        TreeScore ts = new TreeScore(s, 0, s[0].sequence.length() - 1, Integer.parseInt(args[2]), Integer.parseInt(args[3]), null, null);
        try {
            PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[4])));
            if (ts.score != null && ts.score.size() > 0) {
                int i = 0;
                while (i < ts.score.size()) {
                    if (ts.score.elementAt(i) instanceof Vector) {
                        Vector tmp = (Vector)ts.score.elementAt(i);
                        int j = 0;
                        while (j < tmp.size()) {
                            int tmp2 = ((Double)tmp.elementAt(j)).intValue();
                            Format.print(ps, "%8d ", tmp2);
                            ++j;
                        }
                        ps.println();
                    }
                    ++i;
                }
            }
            ps.close();
        }
        catch (IOException ex) {
            System.out.println("Exception : " + ex);
        }
    }
}

