/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.Sequence;
import java.awt.Color;
import java.awt.Graphics;

public class SequenceFeature {
    int start;
    int end;
    String type;
    String description;
    Color color;
    Sequence sequence;
    public static int CHAIN = 0;
    public static int DOMAIN = 1;
    public static int TRANSMEM = 2;
    public static int SIGNAL = 3;
    public static int HELIX = 4;
    public static int TURN = 5;
    public static int SHEET = 6;
    public static int CARBOHYD = 7;
    public static int ACT_SITE = 8;
    public static int TRANSIT = 9;
    public static int VARIANT = 10;
    public static int BINDING = 11;

    public SequenceFeature(Sequence sequence, String type, int start, int end, String description) {
        this.sequence = sequence;
        this.type = type;
        this.start = start;
        this.end = end;
        this.description = description;
        this.setColor();
    }

    public void setColor() {
        this.color = this.type.equals("CHAIN") ? Color.white : (this.type.equals("DOMAIN") ? Color.white : (this.type.equals("TRANSMEM") ? Color.red.darker() : (this.type.equals("SIGNAL") ? Color.cyan : (this.type.equals("HELIX") ? Color.magenta : (this.type.equals("TURN") ? Color.cyan : (this.type.equals("SHEET") ? Color.yellow : (this.type.equals("STRAND") ? Color.yellow : (this.type.equals("CARBOHYD") ? Color.pink : (this.type.equals("ACT_SITE") ? Color.red : (this.type.equals("TRANSIT") ? Color.orange : (this.type.equals("VARIANT") ? Color.orange.darker() : (this.type.equals("BINDING") ? Color.blue : (this.type.equals("DISULFID") ? Color.yellow.darker() : (this.type.equals("NP_BIND") ? Color.red : (this.type.indexOf("BIND") > 0 ? Color.red : Color.lightGray)))))))))))))));
    }

    public String print() {
        String tmp = new Format("%15s").form(this.type);
        tmp = String.valueOf(tmp) + new Format("%6d").form(this.start);
        tmp = String.valueOf(tmp) + new Format("%6d").form(this.end);
        tmp = String.valueOf(tmp) + " " + this.description;
        return tmp;
    }

    public void draw(Graphics g, int fstart, int fend, int x1, int y1, int width, int height) {
        g.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
        int xstart = this.start;
        int xend = this.end;
        long tstart = System.currentTimeMillis();
        if (xend >= fstart || xstart <= fend) {
            if (xstart > fstart) {
                x1 += (xstart - fstart) * width;
                fstart = xstart;
            }
            if (xend < fend) {
                fend = xend;
            }
            int i = fstart;
            while (i <= fend) {
                String s = this.sequence.sequence.substring(i, i + 1);
                if (!(s.equals(".") || s.equals("-") || s.equals(" "))) {
                    g.fillRect(x1 + (i - fstart) * width, y1, width, height);
                } else {
                    g.drawString("-", x1 + (i - fstart) * width, y1 + height);
                }
                ++i;
            }
        }
        long tend = System.currentTimeMillis();
        System.out.println("Time = " + (tend - tstart) + "ms");
    }
}

