/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import java.awt.Color;

public class ScoreColourScheme
extends ResidueColourScheme {
    public double min;
    public double max;
    public double[] scores;

    public ScoreColourScheme(double[] scores, double min, double max) {
        this.scores = scores;
        this.min = min;
        this.max = max;
    }

    public void setColours(DrawableSequence seq2, int j) {
        Color c = Color.white;
        String s = seq2.getSequence().substring(j, j + 1);
        try {
            if (this.colourThreshold > 0 && this.cons != null) {
                if (this.aboveThreshold(seq2, j, this.colourThreshold)) {
                    c = this.findColour(seq2, s, j);
                }
            } else {
                c = !(s.equals("-") || s.equals(".") || s.equals(" ")) ? this.findColour(seq2, s, j) : Color.white;
            }
        }
        catch (Exception exception) {
            c = Color.white;
        }
        seq2.setResidueBoxColour(j, c);
    }

    public Color findColour(DrawableSequence seq2, String s, int j) {
        float red = (float)(this.scores[(Integer)ResidueProperties.aaHash.get(s)] - (double)((float)this.min)) / (float)(this.max - this.min);
        if (red > 1.0f) {
            red = 1.0f;
        }
        if (red < 0.0f) {
            red = 0.0f;
        }
        return this.makeColour(red);
    }

    public Color makeColour(float c) {
        return new Color(c, 0.0f, 1.0f - c);
    }
}

