/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.OutputGenerator;
import jalview.PostscriptPopup;
import jalview.PostscriptProperties;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class PostscriptFilePopup
extends PostscriptPopup {
    Button b;

    public PostscriptFilePopup(Frame parent, String title, OutputGenerator og) {
        super(parent, title, og);
    }

    public void createInterface() {
        this.tf = new TextField(40);
        this.tfLabel = new Label("Filename : ");
        this.b = new Button("Browse..");
        this.fontLabel = new Label("Font");
        this.font = new Choice();
        this.font.addItem("Times-Roman");
        this.font.addItem("Courier");
        this.font.addItem("Helvetica");
        this.fontsizeLabel = new Label("Font size");
        this.fontSize = new Choice();
        this.fontSize.addItem("1");
        this.fontSize.addItem("2");
        this.fontSize.addItem("4");
        this.fontSize.addItem("6");
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("20");
        this.fontSize.addItem("24");
        this.fontSize.select(new Integer(8).toString());
        this.orientLabel = new Label("Orientation");
        this.orient = new Choice();
        this.orient.addItem("Portrait");
        this.orient.addItem("Landscape");
        this.sizeLabel = new Label("Paper size");
        this.size = new Choice();
        this.size.addItem("A4");
        this.size.addItem("US letter");
        this.size.addItem("US letter small");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 3, 1);
        this.add(this.b, this.gb, this.gbc, 4, 0, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 5, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 6, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 6, 1, 1);
        this.add(this.fontLabel, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.font, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.fontsizeLabel, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.fontSize, this.gb, this.gbc, 1, 2, 1, 1);
        this.add(this.orientLabel, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.orient, this.gb, this.gbc, 1, 3, 1, 1);
        this.add(this.sizeLabel, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.size, this.gb, this.gbc, 1, 4, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            String fileStr = this.tf.getText();
            try {
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileStr)));
                this.status.setText("Saving file...");
                this.status.validate();
                this.og.getPostscriptProperties().font = this.font.getSelectedItem();
                this.og.getPostscriptProperties().fsize = Integer.valueOf(this.fontSize.getSelectedItem());
                this.og.getPostscriptProperties().orientation = this.orient.getSelectedItem().equals("Landscape") ? PostscriptProperties.LANDSCAPE : PostscriptProperties.PORTRAIT;
                if (this.size.getSelectedItem().equals("US letter")) {
                    this.og.getPostscriptProperties().width = 576;
                    this.og.getPostscriptProperties().height = 776;
                } else if (this.size.getSelectedItem().equals("US letter small")) {
                    this.og.getPostscriptProperties().width = 552;
                    this.og.getPostscriptProperties().height = 730;
                }
                this.og.getPostscript(ps);
                ps.close();
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                this.status.setText("done");
                this.status.validate();
                this.hide();
                this.dispose();
            }
            catch (IOException iOException) {
                this.status.setText("ERROR: Can't open file");
            }
            return true;
        }
        if (e.target == this.b && e.id == 1001) {
            FileDialog fd = new FileDialog(this.parent, "Save postscript file", 0);
            fd.show();
            String dir = "";
            String file = "";
            if (fd.getDirectory() != null && !fd.getDirectory().equals("./")) {
                dir = fd.getDirectory();
            }
            if (fd.getFile() != null) {
                file = fd.getFile();
            }
            this.tf.setText(String.valueOf(dir) + file);
            return true;
        }
        return super.handleEvent(e);
    }
}

