/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ClustalFile;
import jalview.FileParse;
import jalview.Format;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PfamFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector ids;
    Vector words = new Vector();
    long start;
    long end;

    public PfamFile(String inStr) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        this.readLines(inStr);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public PfamFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        int i = 0;
        i = 0;
        while (i < this.noLines) {
            if (this.lineArray.elementAt(i).toString().indexOf(" ") != 0 && this.lineArray.elementAt(i).toString().indexOf("#") != 0) {
                StringTokenizer str = new StringTokenizer(this.lineArray.elementAt(i).toString(), " ");
                String id = "";
                if (str.hasMoreTokens()) {
                    id = str.nextToken();
                    StringBuffer tempseq = new StringBuffer();
                    if (this.myHash.containsKey(id)) {
                        tempseq = new StringBuffer(this.myHash.get(id).toString());
                    }
                    if (!this.headers.contains(id)) {
                        this.headers.addElement(id);
                    }
                    tempseq.append(str.nextToken());
                    this.myHash.put(id, tempseq.toString());
                }
            }
            ++i;
        }
        this.noSeqs = this.headers.size();
        i = 0;
        while (i < this.headers.size()) {
            if (this.myHash.get(this.headers.elementAt(i)) != null) {
                Sequence newSeq;
                if (this.maxLength < this.myHash.get(this.headers.elementAt(i)).toString().length()) {
                    this.maxLength = this.myHash.get(this.headers.elementAt(i)).toString().length();
                }
                String head = this.headers.elementAt(i).toString();
                int start = 1;
                int end = this.myHash.get(this.headers.elementAt(i)).toString().length();
                if (head.indexOf("/") > 0) {
                    StringTokenizer st = new StringTokenizer(head, "/");
                    if (st.countTokens() == 2) {
                        this.ids.addElement(st.nextToken());
                        String tmp = st.nextToken();
                        st = new StringTokenizer(tmp, "-");
                        if (st.countTokens() == 2) {
                            start = Integer.valueOf(st.nextToken());
                            end = Integer.valueOf(st.nextToken());
                        } else {
                            start = -1;
                            end = -1;
                        }
                    } else {
                        this.ids.addElement(this.headers.elementAt(i));
                    }
                } else {
                    this.ids.addElement(this.headers.elementAt(i));
                }
                if (start != -1 && end != -1) {
                    newSeq = new Sequence(this.ids.elementAt(i).toString(), this.myHash.get(this.headers.elementAt(i).toString()).toString(), start, end);
                    this.seqs.addElement(newSeq);
                } else {
                    newSeq = new Sequence(this.ids.elementAt(i).toString(), this.myHash.get(this.headers.elementAt(i).toString()).toString(), 1, this.myHash.get(this.headers.elementAt(i).toString()).toString().length());
                    this.seqs.addElement(newSeq);
                }
            } else {
                System.out.println("Can't find sequence for " + this.headers.elementAt(i));
            }
            ++i;
        }
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
    }

    public static String print(Sequence[] s) {
        StringBuffer out = new StringBuffer("");
        int max = 0;
        int maxid = 0;
        int i = 0;
        while (i < s.length && s[i] != null) {
            String tmp = String.valueOf(s[i].getName()) + "/" + s[i].start + "-" + s[i].end;
            if (s[i].getSequence().length() > max) {
                max = s[i].getSequence().length();
            }
            if (tmp.length() > maxid) {
                maxid = tmp.length();
            }
            ++i;
        }
        if (maxid < 15) {
            maxid = 15;
        }
        int j = 0;
        while (j < s.length && s[j] != null) {
            out.append(String.valueOf(new Format("%-" + maxid + "s").form(String.valueOf(s[j].getName()) + "/" + s[j].start + "-" + s[j].end)) + " ");
            out.append(String.valueOf(s[j].getSequence()) + "\n");
            ++j;
        }
        out.append("\n");
        return out.toString();
    }

    public static void main(String[] args) {
        String inStr = "CLUSTAL\n\nt1  GTGASAAATGGNNTGATTCTGTACCTTGTGGAGACTGGCGTGATGTGCAG\nt2  AAATGATTCTGTACCTTGTGGATGGACTGGCGTGATGTGCAGCAACTATT\n\nt1  CAACTATTCGANNGTGATCCAGTGGTTTTGTCGTTGAATCTGTCTTCGAT\nt2  CGAGTGATCCAGAGGTTTTGTCCTTGAATCTGTCTTCGATGGTTCTCTCG\n\nt1  GGTTCTCGGGTAAGCTATCACCAAGCATAGGTGGATTGGTTCATCTGAAG\nt2  GGTAAGATCCACCAAGCATATGCTAGCT\n ";
        ClustalFile msf = new ClustalFile(inStr);
        Sequence[] s = new Sequence[msf.seqs.size() + 1];
        int i = 0;
        while (i < msf.seqs.size()) {
            s[i] = (Sequence)msf.seqs.elementAt(i);
            ++i;
        }
        String outStr = ClustalFile.print(s);
        System.out.println(outStr);
    }
}

