/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.AlignSeq;
import jalview.DrawableSequence;
import jalview.Format;
import jalview.PairAlignFrame;
import jalview.Sequence;
import java.awt.Font;

public final class PairAlignThread
extends Thread {
    AlignFrame af;

    public PairAlignThread(AlignFrame af) {
        this.af = af;
    }

    public void run() {
        float[][] scores = new float[this.af.ap.seqPanel.align.size()][this.af.ap.seqPanel.align.size()];
        double totscore = 0.0;
        int count = this.af.ap.sel.size();
        if (count == 1) {
            this.af.status.setText("ERROR: only 1 sequence selected");
        } else if (count == 0) {
            this.af.status.setText("ERROR: no sequences selected");
        } else {
            int j;
            PairAlignFrame tf = new PairAlignFrame("Pairwise alignments", 25, 73, "");
            tf.setTextFont(new Font("Courier", 0, 12));
            tf.resize(550, 550);
            tf.show();
            int acount = 0;
            int i = 1;
            while (i < count) {
                j = 0;
                while (j < i) {
                    AlignSeq as = new AlignSeq((Sequence)this.af.ap.sel.elementAt(i), (Sequence)this.af.ap.sel.elementAt(j), "pep");
                    tf.status.setText("Aligning " + as.s1.getName() + " and " + as.s2.getName() + " (" + ++acount + "/" + count * (count - 1) / 2 + ")");
                    as.calcScoreMatrix();
                    as.traceAlignment();
                    as.printAlignment();
                    scores[i][j] = (float)as.maxscore / (float)as.aseq1.length;
                    totscore += (double)scores[i][j];
                    tf.setText(String.valueOf(tf.getText()) + as.output);
                    tf.ta.setCaretPosition(tf.ta.getText().length());
                    tf.addSequence(new DrawableSequence(as.s1.getName(), as.astr1, 0, 0));
                    tf.addSequence(new DrawableSequence(as.s2.getName(), as.astr2, 0, 0));
                    ++j;
                }
                ++i;
            }
            this.af.status.setText("done");
            System.out.println();
            if (count > 2) {
                System.out.print("      ");
                i = 0;
                while (i < count) {
                    j = 0;
                    while (j < i) {
                        Format.print(System.out, "%7.3f", (double)scores[i][j] / totscore);
                        ++j;
                    }
                    System.out.println();
                    ++i;
                }
            }
        }
    }
}

