/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.JnetFile;
import jalview.MSFfile;
import jalview.ScoreSequence;
import jalview.SecondaryColourScheme;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class JnetCGI
extends CGI {
    Sequence[] sequence;
    Object parent;

    public JnetCGI(String server, int port, String location, Sequence[] sequence, PrintStream statout, Object parent) {
        super(server, port, location, statout);
        this.sequence = sequence;
        this.variables = this.makeVariables();
        this.parent = parent;
    }

    public Hashtable makeVariables() {
        String seq2 = MSFfile.print(this.sequence);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("sequence", seq2);
        return h;
    }

    public void insertGaps(Sequence s1, Sequence s2) {
        int i = 0;
        while (i < s1.sequence.length()) {
            String s = s1.sequence.substring(i, i + 1);
            if (s.equals("-") || s.equals(".") || s.equals(" ")) {
                System.out.println(String.valueOf(i) + " " + s2.sequence.length());
                s2.insertCharAt(i, '-', false);
            }
            ++i;
        }
    }

    public DrawableSequence copySequence(DrawableSequence ds) {
        DrawableSequence ds2 = new DrawableSequence(ds.name, ds.sequence, ds.start, ds.end);
        int i = 0;
        while (i < ds.score.length && ds.score[i] != null) {
            ds2.score[i] = (Vector)ds.score[i].clone();
            ++i;
        }
        return ds2;
    }

    public void readInput(DataInputStream in) {
        String aln = "";
        String outstr = "";
        try {
            while ((aln = in.readLine()) != null) {
                outstr = String.valueOf(outstr) + aln + "\n";
            }
            this.statout.print("Prediction finished. Displaying output...");
            Sequence[] ds = FormatAdapter.toDrawableSequence(FormatAdapter.read("JNET", outstr));
            this.insertGaps(this.sequence[0], ds[0]);
            this.insertGaps(this.sequence[0], ds[1]);
            System.out.println("ds0 " + ds[0].sequence);
            System.out.println("ds1 " + ds[1].sequence);
            String out = JnetFile.print(ds);
            System.out.println(out);
            ((DrawableSequence)ds[0]).name = this.sequence[0].name;
            ((DrawableSequence)ds[0]).start = this.sequence[0].start;
            ((DrawableSequence)ds[0]).end = this.sequence[0].end;
            ((DrawableSequence)ds[1]).name = this.sequence[0].name;
            ((DrawableSequence)ds[1]).start = this.sequence[0].start;
            ((DrawableSequence)ds[1]).end = this.sequence[0].end;
            DrawableSequence[] s = new DrawableSequence[5];
            s[0] = ds[1];
            SecondaryColourScheme sc = new SecondaryColourScheme();
            sc.setColours(s[0]);
            s[1] = new ScoreSequence(this.copySequence((DrawableSequence)ds[1]), 0, 50, 50, 255);
            s[1].name = String.valueOf(s[1].name) + ".conf";
            s[2] = new ScoreSequence(this.copySequence((DrawableSequence)ds[1]), 1, 255, 50, 255);
            s[2].name = String.valueOf(s[2].name) + ".helix";
            s[3] = new ScoreSequence(this.copySequence((DrawableSequence)ds[1]), 2, 255, 255, 50);
            s[3].name = String.valueOf(s[3].name) + ".sheet";
            s[4] = new ScoreSequence(this.copySequence((DrawableSequence)ds[1]), 3, 50, 255, 255);
            s[4].name = String.valueOf(s[4].name) + ".turn";
            s[0].name = String.valueOf(s[0].name) + ".pred";
            AlignFrame af = null;
            af = this.parent instanceof AlignFrame ? (AlignFrame)this.parent : new AlignFrame((Object)"Null", (DrawableSequence[])ds);
            if (af != null && af.bp.scorePanel != null) {
                af.bp.scorePanel.seqPanel.align.addSequence(s);
                af.updateFont();
            }
        }
        catch (IOException ioex) {
            if (this.parent instanceof AlignFrame) {
                AlignFrame af = (AlignFrame)this.parent;
                af.error("ERROR: IOException when contacting Jnet server", true);
            }
            System.out.println("Exception " + ioex);
        }
    }

    public static void main(String[] args) {
        Sequence[] seqs = FormatAdapter.toDrawableSequence(FormatAdapter.read(args[0], "File", args[1]));
        JnetCGI cwcgi = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", seqs, System.out, null);
        cwcgi.run();
    }
}

