/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.CommandThread;
import jalview.FormatAdapter;
import jalview.ProgressFrame;
import jalview.Sequence;
import jalview.TextAreaPrintStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;

public class ClustalwThread
extends CommandThread {
    String inFile;
    String outFile;
    PrintStream ps;

    public ClustalwThread(String inFile, String outFile) {
        super((String)null);
        this.inFile = inFile;
        this.outFile = outFile;
        new File(inFile);
        new File(outFile);
        System.out.println("OS = " + System.getProperty("os.name"));
        this.command = System.getProperty("os.name").equals("Windows 95") ? "clustalw /inFile=" + inFile + " /outFile=" + outFile + " /outorder=input" : "clustalw -inFile=" + inFile + " -outFile=" + outFile + " /outorder=input";
    }

    public ClustalwThread(Sequence[] s) {
        try {
            long seed = 12L;
            Random rnums = new Random(seed);
            File tmpout = null;
            File tmpnew = null;
            String prefix = "";
            if (System.getProperty("os.name").equals("Windows 95")) {
                prefix = "c:\\windows\\temp\\";
            }
            do {
                String r1str;
                int r1;
                if ((r1 = rnums.nextInt()) < 0) {
                    r1 = -r1;
                }
                if ((r1str = String.valueOf(r1)).length() > 4) {
                    r1str = r1str.substring(0, 4);
                }
                this.inFile = String.valueOf(prefix) + "pog" + r1str + ".msf";
                this.outFile = String.valueOf(prefix) + "pog" + r1str + ".aln";
                tmpout = new File(this.inFile);
                tmpnew = new File(this.outFile);
            } while (tmpout.exists() || tmpnew.exists());
            System.out.println(this.inFile);
            System.out.println(this.outFile);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.inFile));
            String outStr = FormatAdapter.get("MSF", s);
            byte[] fileBytes = outStr.getBytes();
            int i = 0;
            while (i < fileBytes.length) {
                bos.write(fileBytes[i]);
                ++i;
            }
            bos.flush();
            bos.close();
            System.out.println("OS = " + System.getProperty("os.name"));
            this.command = System.getProperty("os.name").equals("Windows 95") ? "clustalw /inFile=" + this.inFile + " /outFile=" + this.outFile + " /outorder=input" : "clustalw -inFile=" + this.inFile + " -outFile=" + this.outFile + " -outorder=input";
            System.out.println("Command = " + this.command);
            ProgressFrame pf = new ProgressFrame("Clustalw progress", this, null);
            TextAreaPrintStream taps = new TextAreaPrintStream((OutputStream)System.out, pf.ta);
            this.ps = taps;
            pf.show();
            Thread t = new Thread(pf.pp);
            pf.pp.ct = this;
            t.start();
        }
        catch (Exception e) {
            System.out.println("Exception in clustalwThread " + e);
        }
    }

    public void run() {
        System.out.println("Running command: " + this.command);
        try {
            this.p = Runtime.getRuntime().exec(this.command);
            BufferedInputStream is = new BufferedInputStream(this.p.getInputStream());
            int len = 0;
            byte[] buf = new byte[1000];
            while ((len = is.read(buf)) != -1) {
                String str = new String(buf, 0, 0, len);
                if (str.indexOf("CLUSTAL-Alignment file created") >= 0) break;
                System.out.println(str);
                this.ps.print(str);
            }
            System.out.println("Command thread is done");
        }
        catch (EOFException eof) {
            System.out.println("Exception : " + eof);
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
        this.done = true;
    }
}

