/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.ColourAdapter;
import jalview.DrawableSequence;
import jalview.FastaFile;
import jalview.FormatAdapter;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class ClustalwCGI
extends CGI {
    Sequence[] sequence;

    public ClustalwCGI(String server, int port, String location, Sequence[] sequence, PrintStream statout) {
        super(server, port, location, statout);
        this.sequence = sequence;
        this.variables = this.makeVariables();
    }

    public Hashtable makeVariables() {
        String seq2 = FastaFile.print(this.sequence, 72);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("sequence", seq2);
        h.put("newseq", "poggy");
        return h;
    }

    public void readInput(DataInputStream in) {
        String aln = "";
        boolean start = false;
        String outstr = "";
        try {
            while ((aln = in.readLine()) != null) {
                if (aln.indexOf("CLUSTAL") == 0) {
                    start = true;
                }
                if (start) {
                    outstr = String.valueOf(outstr) + aln + "\n";
                    continue;
                }
                this.statout.println(aln);
            }
            this.statout.print(outstr);
            DrawableSequence[] ds = FormatAdapter.toDrawableSequence(FormatAdapter.read("CLUSTAL", outstr));
            AlignFrame af = new AlignFrame((Object)"Null", ds);
            af.ap.seqPanel.align.percentIdentity();
            af.cons = af.ap.seqPanel.align.cons;
            af.ap.seqPanel.align.setColourScheme(ColourAdapter.get(2));
            af.resize(700, 500);
            af.show();
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
    }

    public static void main(String[] args) {
        try {
            FastaFile ff = new FastaFile("hth2.fa", "File");
            Sequence[] seqs = new Sequence[ff.seqs.size()];
            int i = 0;
            while (i < ff.seqs.size()) {
                seqs[i] = (Sequence)ff.seqs.elementAt(i);
                ++i;
            }
            ClustalwCGI cwcgi = new ClustalwCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runclustal", seqs, System.out);
            cwcgi.run();
        }
        catch (IOException ie) {
            System.out.println("Exception " + ie);
        }
    }
}

