/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.ClustalxColourScheme;
import jalview.ColourAdapter;
import jalview.ColourScheme;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.SequenceGroup;
import jalview.TaylorColourScheme;
import java.applet.Applet;
import java.util.StringTokenizer;

public class AlignApplet
extends Applet {
    String input;
    String type;
    AlignFrame af;
    String fontSize = "10";
    String format = "MSF";
    int noGroups;
    String consString = "*";
    String local = "";
    ConsThread ct;
    String mailServer;
    String clustalServer;
    String srsServer;
    String database;

    public void init() {
        this.input = this.getParameter("input");
        this.type = this.getParameter("type");
        this.fontSize = this.getParameter("fontsize");
        this.mailServer = this.getParameter("mailServer");
        this.clustalServer = this.getParameter("clustalServer");
        this.srsServer = this.getParameter("srsServer");
        this.database = this.getParameter("database");
        this.local = this.getParameter("local");
        try {
            this.noGroups = Integer.valueOf(this.getParameter("groups"));
            System.out.println("Number of groups = " + this.noGroups);
        }
        catch (Exception exception) {}
        this.format = this.getParameter("format");
        if (this.format == null || this.format.equals("")) {
            this.format = "MSF";
        }
        this.format = this.format.toUpperCase();
        System.out.println("Format = " + this.format);
        this.consString = this.getParameter("Consensus");
        if (this.consString == null) {
            this.consString = "*";
        }
        this.componentInit();
    }

    public void componentInit() {
        this.makeFrame();
    }

    public void makeFrame() {
        try {
            int i;
            this.getParameter("numseqs");
            if (this.getParameter("numseqs") == null) {
                this.af = new AlignFrame(this, this.input, this.type, this.format);
            } else {
                int num = Integer.valueOf(this.getParameter("numseqs"));
                i = 0;
                int count = 0;
                DrawableSequence[] seqs = new DrawableSequence[num];
                while (i < num) {
                    String s2 = this.getParameter("seq" + (i + 1));
                    if (s2 != null) {
                        String id = this.getParameter("id" + (i + 1));
                        if (id == null) {
                            id = "Seq_" + i;
                        }
                        seqs[count] = new DrawableSequence(id, s2, 1, s2.length());
                        ++count;
                    } else {
                        System.out.println("Can't read sequence " + (i + 1));
                    }
                    ++i;
                }
                if (count > 0) {
                    this.af = new AlignFrame(this, seqs);
                } else {
                    System.out.println("No sequences found");
                    this.stop();
                }
            }
            this.af.setTitle("Jalview alignment editor");
            if (this.mailServer != null) {
                this.af.mp.server = !this.mailServer.equals("") ? this.mailServer : "";
            }
            if (this.srsServer != null && !this.srsServer.equals("")) {
                if (!this.srsServer.substring(this.srsServer.length() - 1).equals("/")) {
                    this.srsServer = String.valueOf(this.srsServer) + "/";
                }
                this.af.srsServer = this.srsServer;
                System.out.println("Srs server = " + this.af.srsServer);
            }
            if (this.database != null && !this.database.equals("")) {
                this.af.database = this.database;
                System.out.println("Srs database = " + this.af.database);
            }
            try {
                int fs = Integer.valueOf(this.fontSize);
                this.af.ap.seqPanel.seqCanvas.setFont(0, fs);
            }
            catch (Exception ex) {
                System.out.println("Exception in font size : " + ex);
                this.af.ap.seqPanel.seqCanvas.setFont(0, 10);
            }
            System.out.println("Consensus string " + this.consString);
            if (this.consString.equals("*")) {
                this.af.ap.selectAll(true);
            } else {
                int[] seqs = this.selectSeqs(this.consString);
                i = 0;
                this.af.ap.selectAll(false);
                while (i < seqs.length && seqs[i] != -1) {
                    this.af.ap.sel.addElement(this.af.ap.seqPanel.align.sequences[seqs[i]]);
                    ++i;
                }
            }
            this.af.status.setText("Calculating consensus...");
            this.af.ap.seqPanel.align.percentIdentity(this.af.ap.sel);
            this.af.ap.seqPanel.align.percentIdentity2();
            this.af.ap.seqPanel.align.findQuality();
            this.af.cons = this.af.ap.seqPanel.align.cons;
            this.af.status.setText("done");
            if (this.noGroups > 0) {
                int i2 = 0;
                while (i2 < this.noGroups) {
                    this.af.status.setText("Parsing group " + (i2 + 1));
                    String gs = this.getParameter("group" + (i2 + 1));
                    System.out.println("Group = " + gs);
                    this.parseGroup(this.af.ap.seqPanel.align, gs);
                    ++i2;
                }
            } else {
                this.af.status.setText("Setting colour scheme...");
                ClustalxColourScheme pidcs = new ClustalxColourScheme(this.af.ap.seqPanel.align.cons2, this.af.ap.seqPanel.align.size());
                this.af.ap.seqPanel.align.setColourScheme(pidcs);
            }
            this.af.status.setText("done");
            this.af.updateFont();
            this.af.ap.selectAll(false);
            this.af.ap.idPanel.idCanvas.paintFlag = true;
            this.af.ap.idPanel.idCanvas.repaint();
        }
        catch (Exception ex) {
            System.out.println("Exception in applet : " + ex);
        }
    }

    public void parseGroup(Alignment al, String gs) {
        boolean boxes = true;
        boolean text = true;
        boolean colourText = false;
        StringTokenizer st = new StringTokenizer(gs, ":");
        try {
            ColourScheme cs;
            int[] seqs = this.selectSeqs(st.nextToken());
            String tmp = st.nextToken();
            tmp.toUpperCase();
            System.out.println(tmp);
            if (tmp.equals("SECONDARY")) {
                tmp = "Secondary structure";
            }
            if (tmp.equals("ZAPPO")) {
                tmp = "Zappo";
            }
            if (tmp.equals("TAYLOR")) {
                tmp = "Taylor";
            }
            if (tmp.equals("HYDROPHOBIC")) {
                tmp = "Hydrophobic";
            }
            if (tmp.equals("USERDEFINED")) {
                tmp = "User defined";
            }
            if (tmp.equals("HELIX")) {
                tmp = "Helix";
            }
            if (tmp.equals("STRAND")) {
                tmp = "Strand";
            }
            if (tmp.equals("TURN")) {
                tmp = "Turn";
            }
            if (tmp.equals("CLUSTALX")) {
                tmp = "Clustalx";
            }
            if ((cs = ColourAdapter.get(tmp)) == null) {
                cs = new TaylorColourScheme();
            }
            System.out.println("Colour scheme = " + cs);
            tmp = st.nextToken();
            tmp = tmp.toUpperCase();
            if (tmp.equals("TRUE")) {
                boxes = true;
            } else if (tmp.equals("FALSE")) {
                boxes = false;
            }
            tmp = st.nextToken();
            tmp = tmp.toUpperCase();
            if (tmp.equals("TRUE")) {
                text = true;
            } else if (tmp.equals("FALSE")) {
                text = false;
            }
            tmp = st.nextToken();
            tmp = tmp.toUpperCase();
            if (tmp.equals("TRUE")) {
                colourText = true;
            } else if (tmp.equals("FALSE")) {
                colourText = false;
            }
            System.out.println("boxes = " + boxes);
            System.out.println("text = " + text);
            SequenceGroup sg = new SequenceGroup(cs, true, boxes, text, colourText, true);
            System.out.println("Sequence group " + sg);
            this.af.ap.seqPanel.align.addGroup(sg);
            int i = 0;
            while (seqs[i] != -1) {
                if (this.af.ap.seqPanel.align.sequences[seqs[i]] != null) {
                    if (this.af.ap.seqPanel.align.findGroup(seqs[i]) != null) {
                        this.af.ap.seqPanel.align.removeFromGroup(this.af.ap.seqPanel.align.findGroup(seqs[i]), this.af.ap.seqPanel.align.sequences[seqs[i]]);
                    }
                    sg.addSequence(this.af.ap.seqPanel.align.sequences[seqs[i]]);
                }
                ++i;
            }
            System.out.println("Colourscheme is " + cs);
            if (this.af.cons != null && cs instanceof ResidueColourScheme) {
                System.out.println("Setting colour scheme " + cs);
                ((ResidueColourScheme)sg.colourScheme).cons = this.af.cons;
            }
            if (this.af.cons != null && cs instanceof ClustalxColourScheme) {
                System.out.println("Setting colour scheme " + cs);
                ((ClustalxColourScheme)sg.colourScheme).cons = this.af.cons;
                System.out.println("Consensus is" + this.af.cons);
            }
            this.af.ap.seqPanel.align.displayText(sg);
            this.af.ap.seqPanel.align.displayBoxes(sg);
            this.af.ap.seqPanel.align.colourText(sg);
            this.af.ap.seqPanel.align.setColourScheme(sg);
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }

    public int[] selectSeqs(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int[] seqs = new int[2000];
        int count = 0;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (tmp.equals("*")) {
                int i = 0;
                while (i < this.af.ap.seqPanel.align.sequences.length) {
                    seqs[i] = i;
                    ++i;
                }
                continue;
            }
            if (tmp.indexOf("-") >= 0) {
                try {
                    StringTokenizer st2 = new StringTokenizer(tmp, "-");
                    int start = Integer.valueOf(st2.nextToken());
                    int end = Integer.valueOf(st2.nextToken());
                    if (end <= start) continue;
                    int i = start;
                    while (i <= end) {
                        seqs[count] = i - 1;
                        ++count;
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception : " + e);
                }
                continue;
            }
            try {
                seqs[count] = Integer.valueOf(tmp) - 1;
                System.out.println("Adding " + seqs[count] + " to group");
                ++count;
            }
            catch (Exception e) {
                System.out.println("Exception : " + e);
            }
        }
        seqs[count] = -1;
        return seqs;
    }
}

