/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.DNA;
import bilab.RNA;
import bilab.Sophistication;
import bilab.Summary;
import bilab.protein;
import bilab.seq;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.NCBISequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.utils.ChangeVetoException;
import scigol.Any;
import scigol.List;
import scigol.Map;
import scigol.TypeSpec;
import scigol.accessor;

@Summary(value="a sequence database")
public class seqdb
extends Map {
    protected SequenceDBLite db;

    @Summary(value="create an empty seq database")
    public seqdb() {
        this.db = new HashSequenceDB();
    }

    @Summary(value="create a seq database from a given database source & database (e.g. \"NCBI\",\"nucleotide\" ")
    @Sophistication(value=2)
    public seqdb(String sourceName, String databaseName) {
        if (sourceName.equals("NCBI")) {
            if (databaseName.equals("nucleotide")) {
                this.db = new NCBISequenceDB("nucleotide", (SequenceFormat)new GenbankFormat());
            } else if (databaseName.equals("protein")) {
                this.db = new NCBISequenceDB("protein", (SequenceFormat)new GenbankFormat());
            }
        } else {
            throw new BilabException("unsupported database source:" + sourceName);
        }
    }

    @Summary(value="add a seq to the database (generating a new unique id)")
    public void add(seq s) {
        this.add(null, s);
    }

    @Summary(value="add an id -> seq mapping to the database")
    public void add(String id, seq s) {
        this.add(id, s);
    }

    @Sophistication(value=2)
    public void add(Object key, Object value) {
        block8: {
            try {
                key = TypeSpec.unwrapAnyOrNum(key);
                value = TypeSpec.unwrapAnyOrNum(value);
                if (key != null && !(key instanceof String)) {
                    throw new BilabException("seqdb key must be a string (id)");
                }
                if (!(value instanceof seq)) {
                    throw new BilabException("can only add seq to a seqdb");
                }
                if (this.db instanceof HashSequenceDB) {
                    ((HashSequenceDB)this.db).addSequence((String)key, this.getSeq((seq)value));
                    break block8;
                }
                if (key == null) {
                    this.db.addSequence(this.getSeq((seq)value));
                    break block8;
                }
                throw new BilabException("this kind of seqdb doesn't support seq addition");
            }
            catch (BilabException e) {
                throw e;
            }
            catch (ChangeVetoException e) {
                throw new BilabException("change to underlying biojava Sequence vetoed:" + e.getMessage(), e);
            }
            catch (BioException e) {
                throw new BilabException("biojava error:" + e.getMessage(), e);
            }
        }
    }

    @Sophistication(value=2)
    public Object put(Object key, Object value) {
        this.add(key, value);
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Sophistication(value=2)
    public Object get(Object key) {
        key = TypeSpec.unwrapAnyOrNum(key);
        List seqList = new List();
        if (!(key instanceof List)) {
            List list = new List();
            list.add(key);
            key = list;
        }
        List giList = (List)key;
        int i = 0;
        while (i < giList.get_size()) {
            String gi;
            Object giObj = TypeSpec.unwrapAnyOrNum(giList.get(i));
            if (giObj instanceof String) {
                gi = (String)giObj;
            } else if (giObj instanceof Integer) {
                gi = "" + (Integer)giObj;
            } else {
                throw new BilabException("seqdb keys must be a string or int GI number (or a list of GI numbers)");
            }
            try {
                void var6_6;
                Sequence sequence = this.db.getSequence((String)var6_6);
                seqList.add(seq.seqFromSequence(sequence));
            }
            catch (IllegalIDException illegalIDException) {
                throw new BilabException("seqdb doesn't contain a seq with key '" + key + "'");
            }
            catch (BioException e) {
                throw new BilabException("biojava error:" + e.getMessage(), e);
            }
            ++i;
        }
        if (seqList.get_size() == 1) {
            return TypeSpec.unwrapAnyOrNum(seqList.get(0));
        }
        return seqList;
    }

    @Sophistication(value=2)
    public int size() {
        if (this.db instanceof SequenceDB) {
            return ((SequenceDB)this.db).ids().size();
        }
        throw new BilabException("unable to determine size of this kind of seqdb");
    }

    public boolean contains(Object key) {
        if (!(key instanceof String)) {
            throw new BilabException("seqdb key must be a string (id)");
        }
        try {
            key = TypeSpec.unwrapAnyOrNum(key);
            this.db.getSequence((String)key);
            return true;
        }
        catch (IllegalIDException illegalIDException) {
        }
        catch (BioException e) {
            throw new BilabException("biojava error:" + e.getMessage(), e);
        }
        return false;
    }

    @Sophistication(value=2)
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            throw new BilabException("seqdb key must be a string (id)");
        }
        Sequence sequence = null;
        try {
            key = TypeSpec.unwrapAnyOrNum(key);
            sequence = this.db.getSequence((String)key);
            this.db.removeSequence((String)key);
        }
        catch (IllegalIDException illegalIDException) {
            throw new BilabException("seqdb doesn't contain a seq with key '" + key + "'");
        }
        catch (ChangeVetoException e) {
            throw new BilabException("change to underlying biojava Sequence vetoed:" + e.getMessage(), e);
        }
        catch (BioException e) {
            throw new BilabException("biojava error:" + e.getMessage(), e);
        }
        return seq.seqFromSequence(sequence);
    }

    @accessor
    public Any get_Item(Object key) {
        key = TypeSpec.unwrapAnyOrNum(key);
        return new Any(this.get(key));
    }

    @accessor
    public void set_Item(Object key, Any value) {
        key = TypeSpec.unwrapAnyOrNum(key);
        this.put(key, TypeSpec.unwrapAnyOrNum(value));
    }

    public static int op_Card(seqdb db) {
        return db.size();
    }

    public String toString() {
        if (this.db instanceof SequenceDB) {
            SequenceDB sdb = (SequenceDB)this.db;
            String s = "[\n";
            Set ids = sdb.ids();
            for (Object id : ids) {
                String key = (String)id;
                Object value = this.get(key);
                s = String.valueOf(s) + " " + key.toString() + " -> " + (value != null ? value.toString() : "null") + "\n";
            }
            s = String.valueOf(s) + "]";
            return s;
        }
        if (this.db.getName() != null && this.db.getName().length() > 0) {
            return "<seqdb " + this.db.getName() + "> [...]";
        }
        return "<seqdb> [...]";
    }

    protected Sequence getSeq(seq s) {
        if (s instanceof DNA) {
            return ((DNA)s).seq;
        }
        if (s instanceof RNA) {
            return ((RNA)s).seq;
        }
        if (s instanceof protein) {
            return ((protein)s).seq;
        }
        throw new BilabException("expecting DNA, RNA or protein");
    }
}

