/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.MoleculeImpl;
import bilab.Notify;
import bilab.Sophistication;
import bilab.Summary;
import bilab.seq;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.MassCalc;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import scigol.Any;
import scigol.List;
import scigol.Map;
import scigol.Range;
import scigol.TypeSpec;
import scigol.accessor;

@Summary(value="A protein sequence molecule")
public class protein
extends seq
implements Cloneable {
    @Summary(value="The underlying biojava Sequence representing this protein")
    @Sophistication(value=2)
    public Sequence seq;

    public protein() {
        this.seq = null;
    }

    public protein(Sequence s) {
        this.seq = s;
    }

    public protein(String seq2) {
        try {
            this.seq = ProteinTools.createProteinSequence((String)seq2, (String)"protein");
        }
        catch (BioException e) {
            throw new BilabException("biojava error:" + e.getMessage(), e);
        }
    }

    public Object clone() {
        Notify.devWarning(this, "clone(): features not cloned");
        protein copy = null;
        try {
            copy = (protein)super.clone();
            copy.seq = ProteinTools.createProteinSequence((String)this.seq.seqString(), (String)this.seq.getName());
            protein.addAnnotationsToSequence(copy.seq, this.get_annotations());
        }
        catch (IllegalSymbolException illegalSymbolException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return copy;
    }

    @accessor
    public protein get_Item(Range r) {
        r = r.normalize(this.seq.length());
        return new protein(this.seq.subStr(r.start + 1, r.end + 1));
    }

    @accessor
    public Any get_Item(int i) {
        try {
            Symbol sym = this.seq.symbolAt(i + 1);
            Alphabet alpha = sym.getMatches();
            List mols = new List();
            if (alpha.contains((Symbol)ProteinTools.ala())) {
                mols.add(MoleculeImpl.Ala);
            }
            if (alpha.contains((Symbol)ProteinTools.cys())) {
                mols.add(MoleculeImpl.Cys);
            }
            if (alpha.contains((Symbol)ProteinTools.asp())) {
                mols.add(MoleculeImpl.Asp);
            }
            if (alpha.contains((Symbol)ProteinTools.glu())) {
                mols.add(MoleculeImpl.Glu);
            }
            if (alpha.contains((Symbol)ProteinTools.phe())) {
                mols.add(MoleculeImpl.Phe);
            }
            if (alpha.contains((Symbol)ProteinTools.gly())) {
                mols.add(MoleculeImpl.Gly);
            }
            if (alpha.contains((Symbol)ProteinTools.his())) {
                mols.add(MoleculeImpl.His);
            }
            if (alpha.contains((Symbol)ProteinTools.ile())) {
                mols.add(MoleculeImpl.Ile);
            }
            if (alpha.contains((Symbol)ProteinTools.lys())) {
                mols.add(MoleculeImpl.Lys);
            }
            if (alpha.contains((Symbol)ProteinTools.leu())) {
                mols.add(MoleculeImpl.Leu);
            }
            if (alpha.contains((Symbol)ProteinTools.met())) {
                mols.add(MoleculeImpl.Met);
            }
            if (alpha.contains((Symbol)ProteinTools.asn())) {
                mols.add(MoleculeImpl.Asn);
            }
            if (alpha.contains((Symbol)ProteinTools.pro())) {
                mols.add(MoleculeImpl.Pro);
            }
            if (alpha.contains((Symbol)ProteinTools.gln())) {
                mols.add(MoleculeImpl.Gln);
            }
            if (alpha.contains((Symbol)ProteinTools.arg())) {
                mols.add(MoleculeImpl.Arg);
            }
            if (alpha.contains((Symbol)ProteinTools.ser())) {
                mols.add(MoleculeImpl.Ser);
            }
            if (alpha.contains((Symbol)ProteinTools.thr())) {
                mols.add(MoleculeImpl.Thr);
            }
            if (alpha.contains((Symbol)ProteinTools.val())) {
                mols.add(MoleculeImpl.Val);
            }
            if (alpha.contains((Symbol)ProteinTools.trp())) {
                mols.add(MoleculeImpl.Trp);
            }
            if (alpha.contains((Symbol)ProteinTools.tyr())) {
                mols.add(MoleculeImpl.Tyr);
            }
            if (mols.get_size() == 1) {
                return mols.get_head();
            }
            return new Any(mols);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BilabException("index must be in range 0.." + (this.seq.length() - 1) + ", not " + i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @accessor
    public void set_Item(int i, Any value) {
        Object item = TypeSpec.unwrapAny(value);
        try {
            if (item instanceof MoleculeImpl) {
                MoleculeImpl mol = (MoleculeImpl)item;
                int s = 63;
                if (mol == MoleculeImpl.Ala) {
                    s = 65;
                }
                if (mol == MoleculeImpl.Cys) {
                    s = 67;
                }
                if (mol == MoleculeImpl.Asp) {
                    s = 68;
                }
                if (mol == MoleculeImpl.Glu) {
                    s = 69;
                }
                if (mol == MoleculeImpl.Phe) {
                    s = 70;
                }
                if (mol == MoleculeImpl.Gly) {
                    s = 71;
                }
                if (mol == MoleculeImpl.His) {
                    s = 72;
                }
                if (mol == MoleculeImpl.Ile) {
                    s = 73;
                }
                if (mol == MoleculeImpl.Lys) {
                    s = 75;
                }
                if (mol == MoleculeImpl.Leu) {
                    s = 76;
                }
                if (mol == MoleculeImpl.Met) {
                    s = 77;
                }
                if (mol == MoleculeImpl.Asn) {
                    s = 78;
                }
                if (mol == MoleculeImpl.Pro) {
                    s = 80;
                }
                if (mol == MoleculeImpl.Gln) {
                    s = 81;
                }
                if (mol == MoleculeImpl.Arg) {
                    s = 82;
                }
                if (mol == MoleculeImpl.Ser) {
                    s = 83;
                }
                if (mol == MoleculeImpl.Thr) {
                    s = 84;
                }
                if (mol == MoleculeImpl.Val) {
                    s = 86;
                }
                if (mol == MoleculeImpl.Trp) {
                    s = 87;
                }
                if (mol == MoleculeImpl.Tyr) {
                    s = 89;
                }
                if (s == 63) throw new BilabException("unable to add given molecule to proetin");
                String seqStr = this.seq.seqString();
                char[] seqChars = seqStr.toCharArray();
                seqChars[i] = s;
                Sequence newseq = ProteinTools.createProteinSequence((String)new String(seqChars), (String)this.seq.getAlphabet().getName());
                this.copyAnnotation(this.seq.getAnnotation(), newseq.getAnnotation());
                this.seq = newseq;
            } else if (TypeSpec.typeOf(item).isChar()) {
                String seqStr = this.seq.seqString();
                char[] seqChars = seqStr.toCharArray();
                seqChars[i] = ((Character)item).charValue();
                Sequence newseq = ProteinTools.createProteinSequence((String)new String(seqChars), (String)this.seq.getAlphabet().getName());
                this.copyAnnotation(this.seq.getAnnotation(), newseq.getAnnotation());
                this.seq = newseq;
            } else {
                if (!(item instanceof String)) throw new BilabException("unable to add an element of type " + TypeSpec.typeOf(item) + " to a protein sequence");
                String seqStr = this.seq.seqString();
                String newStr = String.valueOf(seqStr.substring(0, i)) + (String)item + seqStr.substring(i + 1, seqStr.length());
                Sequence newseq = ProteinTools.createProteinSequence((String)newStr, (String)this.seq.getAlphabet().getName());
                this.copyAnnotation(this.seq.getAnnotation(), newseq.getAnnotation());
                this.seq = newseq;
            }
            this.seq.getAnnotation().setProperty((Object)"edited", (Object)"true; sequence edited from original");
            return;
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BilabException("illegal symbol");
        }
        catch (BioError bioError) {
            throw new BilabException("biojava error adding an element of type " + TypeSpec.typeOf(item) + " to a protein sequence");
        }
        catch (Exception exception) {
            throw new BilabException("exception adding an element of type " + TypeSpec.typeOf(item) + " to a protein sequence");
        }
    }

    @accessor
    public double get_avgIsoMass() {
        try {
            MassCalc mc = new MassCalc("avgMass", false);
            return mc.getMass((SymbolList)this.seq);
        }
        catch (BioException e) {
            throw new BilabException("biojava error", e);
        }
    }

    @accessor
    public double get_MonoIsotopicMass() {
        try {
            return MassCalc.getMass((SymbolList)this.seq, (String)"SymbolPropertyTable.MONO_MASS", (boolean)false);
        }
        catch (BioException e) {
            throw new BilabException("biojava error", e);
        }
    }

    public static protein op_Addition(protein p1, protein p2) {
        String seq1 = p1.get_rawsequence();
        String seq2 = p2.get_rawsequence();
        return new protein(String.valueOf(seq1) + seq2);
    }

    public static int op_Card(protein p) {
        return p.seq.length();
    }

    @accessor
    public String get_name() {
        return this.seq.getName();
    }

    @accessor
    public String get_ShortText() {
        return this.get_name();
    }

    @accessor
    public String get_DetailText() {
        return this.get_ShortText();
    }

    @Summary(value="get sequence as a string of letters formatted into columns")
    public String get_sequence() {
        return protein.formatSeqString(this.seq.seqString());
    }

    @Summary(value="get sequence as a string of continous letters")
    public String get_rawsequence() {
        return this.seq.seqString().toUpperCase();
    }

    public Map get_annotations() {
        Map m = new Map();
        for (Object key : this.seq.getAnnotation().keys()) {
            m.add(((String)key).toLowerCase(), this.seq.getAnnotation().getProperty(key));
        }
        return m;
    }

    protected void copyAnnotation(Annotation from, Annotation to) {
        try {
            for (Object key : from.keys()) {
                to.setProperty(key, from.getProperty(key));
            }
        }
        catch (ChangeVetoException changeVetoException) {}
    }
}

