/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.parts;

import bilab.Notify;
import bilab.notebook.model.EllipticalGraphic;
import bilab.notebook.model.Graphic;
import bilab.notebook.model.GraphicsDiagram;
import bilab.notebook.model.ModelElement;
import bilab.notebook.model.RectangularGraphic;
import bilab.notebook.model.commands.GraphicCreateCommand;
import bilab.notebook.model.commands.GraphicSetConstraintCommand;
import bilab.notebook.parts.GraphicEditPart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

class DiagramEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    DiagramEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        XYLayout layout = (XYLayout)this.getContentPane().getLayoutManager();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy(layout));
        this.installEditPolicy("Selection Feedback", null);
    }

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        return f;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private GraphicsDiagram getCastedModel() {
        return (GraphicsDiagram)this.getModel();
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("ShapesDiagram.ChildAdded".equals(prop) || "ShapesDiagram.ChildRemoved".equals(prop)) {
            this.refreshChildren();
        }
    }

    private class ShapesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        ShapesXYLayoutEditPolicy(XYLayout layout) {
            if (layout == null) {
                throw new IllegalArgumentException();
            }
            this.setXyLayout(layout);
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            Notify.unimplemented((Object)this);
            return null;
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof GraphicEditPart && constraint instanceof Rectangle) {
                return new GraphicSetConstraintCommand((Graphic)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            Notify.unimplemented((Object)this);
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object childClass = request.getNewObjectType();
            if (childClass == EllipticalGraphic.class || childClass == RectangularGraphic.class) {
                return new GraphicCreateCommand(DiagramEditPart.this.getCastedModel(), request);
            }
            return null;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }
}

