/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook;

import java.io.IOException;
import java.net.URISyntaxException;

public interface INotebookStore {
    public static final String NOTEBOOK_TITLE = "NotebookTitle";
    public static final String NOTEBOOK_VERSION = "NotebookVersion";
    public static final String SECTION_NAME = "SectionName";
    public static final String CREATION_DATE = "CreationDate";
    public static final String LAST_MODIFIED_DATETIME = "LastModDateTime";
    public static final String LAST_ACCESS_DATETIME = "LastAccessDateTime";
    public static final String AUTHOR_NAME = "AuthorName";
    public static final String AUTHOR_ID = "AuthorID";
    public static final String NOTARIZATIONS = "Notarizations";
    public static final String EDIT_HISTORY = "EditHistory";
    public static final String CURRENT = "current";

    public String createNotebook(String var1, String var2) throws URISyntaxException, IOException;

    public boolean existsNotebook(String var1);

    public String snapshotNotebookAsVersion(String var1, String var2) throws URISyntaxException, IOException;

    public String[] listNotebookVersionURIs(String var1) throws URISyntaxException, IOException;

    public String[] listNotebookVersionNames(String var1) throws URISyntaxException, IOException;

    public String getCurrentNotebookVersion(String var1) throws URISyntaxException;

    public void deleteNotebookAll(String var1) throws URISyntaxException, IOException;

    public String[] listNotebookSectionURIs(String var1) throws URISyntaxException, IOException;

    public String[] listNotebookSectionNames(String var1) throws URISyntaxException, IOException;

    public String createSection(String var1, String var2, String var3) throws URISyntaxException, IOException;

    public int getSectionCount(String var1) throws URISyntaxException, IOException;

    public String getSectionURI(String var1, int var2) throws URISyntaxException, IOException;

    public int repositionSection(String var1, String var2, String var3) throws URISyntaxException, IOException;

    public void deleteSection(String var1) throws URISyntaxException, IOException;

    public String renameSection(String var1, String var2) throws URISyntaxException, IOException;

    public String createPage(String var1, String var2) throws URISyntaxException, IOException;

    public int getPageCount(String var1) throws URISyntaxException, IOException;

    public String getPageURI(String var1, int var2) throws URISyntaxException, IOException;

    public String getContainingSection(String var1) throws URISyntaxException, IOException;

    public String repositionPage(String var1, String var2, String var3) throws URISyntaxException, IOException;

    public void deletePage(String var1) throws URISyntaxException, IOException;

    public void setPageContent(String var1, byte[] var2) throws URISyntaxException, IOException;

    public byte[] getPageContent(String var1) throws URISyntaxException, IOException;

    public void addPageResource(String var1, String var2, byte[] var3) throws URISyntaxException, IOException;

    public byte[] getPageResource(String var1, String var2) throws URISyntaxException, IOException;

    public void setProperty(String var1, String var2, String var3) throws URISyntaxException, IOException;

    public String getProperty(String var1, String var2) throws URISyntaxException, IOException;

    public String[] getProperties(String var1) throws URISyntaxException, IOException;
}

