/*
 * Decompiled with CFR 0.152.
 */
package bilab.io;

import bilab.Util;
import bilab.io.IFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LocalFileSystem
implements IFileSystem {
    private File localRoot;
    private String currentDirectory = ".";

    public LocalFileSystem() {
        this.localRoot = new File("/");
    }

    public LocalFileSystem(String rootDir) throws IOException {
        this.localRoot = new File(Util.toNativePathSeparator(rootDir));
        if (!this.localRoot.isDirectory()) {
            throw new IOException("local rootDir '" + rootDir + "' must be a directory");
        }
    }

    protected File localPath(String path) {
        if (path.equals("/")) {
            return this.localRoot;
        }
        boolean containsDriveLetter = path.length() >= 3 && path.substring(1, 3).equals(":/") || path.length() >= 4 && path.charAt(0) == '/' && path.substring(2, 4).equals(":/");
        boolean isAbsolute = path.charAt(0) == '/' || containsDriveLetter;
        File local = null;
        if (isAbsolute) {
            if (!containsDriveLetter) {
                local = new File(this.localRoot.getAbsolutePath(), Util.toNativePathSeparator(path.substring(1)));
            } else {
                String newPath;
                if (!this.localRoot.equals(new File(File.separator))) {
                    throw new IllegalArgumentException("invalid path " + path + " for filesystem rooted in the local filesystem directory '" + this.localRoot + "'");
                }
                String string = newPath = path.charAt(0) == '/' ? path.substring(1) : path;
                if (newPath.substring(1, 3).equals(":/")) {
                    newPath = newPath.substring(3);
                }
                local = new File(this.localRoot.getAbsolutePath(), Util.toNativePathSeparator(newPath));
            }
        } else {
            String fullPath = this.currentDirectory.equals(".") ? path : String.valueOf(this.currentDirectory) + "/" + path;
            local = new File(this.localRoot.getAbsolutePath(), Util.toNativePathSeparator(fullPath));
        }
        return local;
    }

    public String getLocalPath(String path) {
        return this.localPath(path).getAbsolutePath().toString();
    }

    public boolean exists(String path) {
        return this.localPath(path).exists();
    }

    public boolean isDirectory(String path) {
        return this.localPath(path).isDirectory();
    }

    public String currentDir() {
        String cwd = null;
        cwd = this.currentDirectory.equals(".") ? Util.toForwardPathSeparator(this.localRoot.getAbsolutePath().toString()) : (this.localRoot.equals(new File(File.separator)) ? String.valueOf(Util.toForwardPathSeparator(this.localRoot.getAbsolutePath().toString())) + this.currentDirectory : String.valueOf(Util.toForwardPathSeparator(this.localRoot.getAbsolutePath().toString())) + "/" + this.currentDirectory);
        if (cwd.charAt(0) != '/') {
            cwd = "/" + cwd;
        }
        return cwd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean changeDir(String subdirName) {
        if (subdirName.equals(".")) {
            return true;
        }
        if (subdirName.equals("/")) {
            this.currentDirectory = ".";
        }
        if (subdirName.equals("..")) {
            if (this.currentDirectory.equals(".")) {
                return true;
            }
            File parent = new File(Util.toNativePathSeparator(this.currentDirectory)).getParentFile();
            if (parent == null) return false;
            this.currentDirectory = Util.toForwardPathSeparator(parent.getPath());
        } else {
            File local;
            String newDir = subdirName;
            if (!subdirName.startsWith("/")) {
                String string = newDir = this.currentDirectory.equals(".") ? "/" + subdirName : String.valueOf(this.currentDirectory) + "/" + subdirName;
            }
            if (!(local = this.localPath(newDir)).exists()) return false;
            this.currentDirectory = newDir;
        }
        if (this.currentDirectory.charAt(0) == '/') {
            this.currentDirectory = this.currentDirectory.substring(1);
        }
        if (this.currentDirectory.length() < 3 || !this.currentDirectory.substring(1, 3).equals(":/")) return true;
        this.currentDirectory = this.currentDirectory.substring(3);
        return true;
    }

    public String[] listDirectoryContents(String directory) throws IOException {
        if (!this.exists(directory)) {
            throw new IOException("directory '" + directory + "' not found");
        }
        File localDir = this.localPath(directory);
        return localDir.list();
    }

    public InputStream readFile(String file) throws FileNotFoundException {
        try {
            if (this.exists(file)) {
                return new FileInputStream(this.localPath(file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        throw new FileNotFoundException("not found '" + file + "'");
    }

    public void makeDirectory(String dirName) throws IOException {
        if (this.exists(dirName)) {
            return;
        }
        File local = this.localPath(dirName);
        if (!local.mkdir()) {
            throw new IOException("unable to create new directory '" + dirName + "'.");
        }
    }

    public OutputStream writeFile(String file, boolean append) throws IOException {
        if (append && !this.exists(file)) {
            throw new FileNotFoundException("can't append to non-existent file '" + file + "'.");
        }
        try {
            return new FileOutputStream(this.localPath(file), append);
        }
        catch (IOException e) {
            throw new IOException("unable to write to file '" + file + "' - " + e.getMessage());
        }
    }

    public void delete(String path, boolean recursive) throws IOException {
        if (this.exists(path)) {
            if (!recursive || !this.isDirectory(path)) {
                this.localPath(path).delete();
            } else {
                String[] contents;
                String[] stringArray = contents = this.listDirectoryContents(path);
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String item = stringArray[n];
                    this.delete(String.valueOf(path) + "/" + item, true);
                    ++n;
                }
                this.delete(path, false);
            }
        }
    }
}

