/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.Doc;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Summary;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scigol.Any;
import scigol.Entry;
import scigol.Map;
import scigol.NamespaceScope;
import scigol.ScigolAnnotation;
import scigol.TypeSpec;
import scigol.Value;
import scigol.Vector;

public class Util {
    static final String spaces = "                                                                                               ";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    @Summary(value="find and read in a file containing any type of supported data of the given type (which may be \"unknown\")")
    public static Any readResource(String resourceName, String resourceType) {
        try {
            ResourceManager rm = BilabPlugin.getResourceManager();
            URL url = rm.findResource(resourceName);
            String fullResourceName = url.toString();
            Object obj = null;
            obj = Util.extension(fullResourceName).equals("html") || Util.extension(fullResourceName).equals("htm") ? url : rm.instantiateObjectFromResource(fullResourceName, resourceType);
            if (obj != null) {
                if (obj instanceof Any) {
                    return (Any)obj;
                }
                return new Any(obj);
            }
        }
        catch (IOException e) {
            throw new BilabException("unable to find or open resource " + resourceName + " - IO error " + e);
        }
        catch (BilabException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BilabException("unable to read resource " + resourceName + " - " + e);
        }
        throw new BilabException("unrecognised or unsupported data format in resource " + resourceName);
    }

    public static String extension(String resourceName) {
        int dotIndex = resourceName.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        String end = resourceName.substring(dotIndex + 1, resourceName.length());
        if (end.indexOf(47) == -1 && end.indexOf(92) == -1) {
            return end;
        }
        return "";
    }

    public static String name(String resourceName) {
        String name = resourceName;
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String toNativePathSeparator(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < path.length()) {
            if (path.charAt(c) != '/') {
                sb.append(path.charAt(c));
            } else {
                sb.append('\\');
            }
            ++c;
        }
        String npath = sb.toString();
        if (npath.length() > 2 && npath.charAt(0) == '\\' && npath.charAt(2) == ':') {
            return npath.substring(1);
        }
        return npath;
    }

    public static String toForwardPathSeparator(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < path.length()) {
            if (path.charAt(c) != '\\') {
                sb.append(path.charAt(c));
            } else {
                sb.append('/');
            }
            ++c;
        }
        return sb.toString();
    }

    public static Double mean(Vector v) {
        int d = v.get_size();
        double t = 0.0;
        int i = 0;
        while (i < d) {
            t += (double)((Integer)v.get_Item((int)i).value).intValue();
            ++i;
        }
        return new Double(t / (double)d);
    }

    public static Map resourceTypesMap() {
        return BilabPlugin.getResourceManager().resourceTypesMap();
    }

    public static Any help(String command) {
        StringBuilder sb = new StringBuilder();
        if (command.equals(".help")) {
            sb.append("Type '.show quickstart' for a quick-start guide\n");
            sb.append(".list                 - list functions and types in the current scope\n");
            sb.append(".ls [<pattern>] or .dir [<pattern>] - list files in current directory\n");
            sb.append(".cd <directory>       - change the current directory\n");
            sb.append(".pwd                  - print (show) current working directory\n");
            sb.append(".help [<func>|<type>] - get help on a specific function or type\n");
            sb.append(".typeof <value>       - shows the actual type of the given value\n");
            sb.append(".run <resource>       - executes a Scigol source resource (e.g. a file)\n");
            sb.append(".using <namespace>    - make definitions in <namespace>'s scope available in the current scope\n");
            sb.append(".show <value>         - show <value> in the value view frame (i.e. default is lower right frame)\n");
            return new Any(sb.toString());
        }
        if (command.startsWith(".help ")) {
            String helpTarget = command.substring(6);
            NamespaceScope globalScope = BilabPlugin.getDefault().getGlobalScope();
            TypeSpec summaryAnnotationType = new TypeSpec((Type)((Object)Summary.class));
            TypeSpec docAnnotationType = new TypeSpec((Type)((Object)Doc.class));
            Entry[] entries = globalScope.getEntries(helpTarget, null);
            if (entries.length > 0) {
                Entry entry = entries[0];
                String name = entry.name;
                Annotation docAnnot = entry.getAnnotation(docAnnotationType);
                if (docAnnot != null) {
                    String doc = null;
                    if (docAnnot instanceof ScigolAnnotation) {
                        Value v = (Value)((ScigolAnnotation)docAnnot).getMembers().get(0);
                        doc = (String)v.getValue();
                    } else {
                        doc = ((Doc)docAnnot).value();
                    }
                    if (!doc.startsWith("file:") && !doc.startsWith("http:")) {
                        sb.append(String.valueOf(name) + ":\n" + doc);
                    } else {
                        String URLString = doc;
                        try {
                            URL url = null;
                            url = URLString.startsWith("file:") ? BilabPlugin.getResourceManager().findResource(URLString.substring(5)) : new URL(URLString);
                            Notify.devInfo(Util.class, "Help URL " + URLString);
                            return new Any(url);
                        }
                        catch (MalformedURLException malformedURLException) {
                            sb.append(doc);
                        }
                        catch (IOException e) {
                            throw new BilabException("error reading help resource " + URLString + " - " + e);
                        }
                    }
                    return new Any(sb.toString());
                }
                String typeString = entry.type.toString();
                Annotation summaryAnnot = entry.getAnnotation(summaryAnnotationType);
                if (summaryAnnot != null) {
                    String summary = null;
                    if (summaryAnnot instanceof ScigolAnnotation) {
                        Value v = (Value)((ScigolAnnotation)summaryAnnot).getMembers().get(0);
                        summary = (String)v.getValue();
                    } else {
                        summary = ((Summary)summaryAnnot).value();
                    }
                    sb.append(String.valueOf(name) + ": " + typeString + "\n" + summary);
                    return new Any(sb.toString());
                }
                sb.append(String.valueOf(name) + ": " + typeString + "\n");
            }
        }
        sb.append("no help available.\n");
        return new Any(sb.toString());
    }

    private static File[] getFilteredFileList(String path, String arg) {
        File fpath;
        String nativePath;
        boolean isPattern = arg.contains("?") || arg.contains("*");
        String pattern = ".*";
        if (isPattern) {
            pattern = arg;
            pattern = pattern.replace("+", "\\+");
            pattern = pattern.replace(".", "\\.");
            pattern = pattern.replace("^", "\\^");
            pattern = pattern.replace("$", "\\$");
            pattern = pattern.replace("(", "\\(");
            pattern = pattern.replace(")", "\\)");
            pattern = pattern.replace("[", "\\[");
            pattern = pattern.replace("{", "\\{");
            pattern = pattern.replace("|", "\\|");
            pattern = pattern.replace("*", ".*");
            pattern = pattern.replace("?", ".{1}");
            arg = "";
        }
        if (arg.length() > 0) {
            path = arg.charAt(0) == '/' ? arg : String.valueOf(path) + "/" + arg;
        }
        if (path.length() == 2 && path.charAt(0) == '/' && Character.isLetter(path.charAt(1))) {
            path = String.valueOf(path) + "/";
        }
        if ((nativePath = Util.toNativePathSeparator(path)).length() > 2 && nativePath.charAt(0) == '\\' && nativePath.charAt(2) == '\\' && Character.isLetter(nativePath.charAt(1))) {
            nativePath = "\\" + nativePath.substring(1, 2) + ":\\" + nativePath.substring(3);
        }
        if (!(fpath = new File(nativePath)).isDirectory()) {
            return null;
        }
        RegexFilenameFilter filter = new RegexFilenameFilter(pattern);
        return fpath.listFiles(filter);
    }

    public static String fileList(String path, String arg) {
        File[] files = Util.getFilteredFileList(path, arg);
        if (files == null) {
            throw new BilabException("path is not a directory");
        }
        if (arg.length() > 0) {
            path = arg.charAt(0) == '/' ? arg : String.valueOf(path) + "/" + arg;
        }
        boolean isPattern = arg.contains("?") || arg.contains("*");
        boolean showHidden = isPattern && arg.equals(".*");
        int col = 0;
        StringBuilder sb = new StringBuilder();
        StringBuilder line = new StringBuilder();
        sb.append("Directory of " + path + "\n");
        File[] fileArray = files;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            boolean isHidden;
            File f = fileArray[n];
            boolean bl = isHidden = f.isHidden() || f.getName().charAt(0) == '.';
            if (!isHidden || showHidden) {
                line.append(f.getName());
                if (f.isDirectory()) {
                    line.append("/");
                }
                if (++col == 3) {
                    col = 0;
                    sb.append(String.valueOf(line.toString()) + "\n");
                    line = new StringBuilder();
                } else {
                    int pad = 20 - line.length() % 20;
                    line.append(spaces.substring(0, pad));
                }
            }
            ++n;
        }
        return sb.toString();
    }

    public static String changeDirectory(String path, String arg) {
        File[] files;
        if (arg.length() == 0) {
            return path;
        }
        if (arg.equals("..")) {
            if (path.equals("/") || path.equals("\\") || path.length() == 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
                return path;
            }
            File pwd = new File(Util.toNativePathSeparator(path));
            String newpath = Util.toForwardPathSeparator(pwd.getParent());
            if ((newpath = newpath.replace(":", "")).charAt(0) != '/') {
                newpath = "/" + newpath;
            }
            return newpath;
        }
        if (arg.equals("/") || arg.equals("\\")) {
            return "/";
        }
        if (arg.length() == 2) {
            if ((arg.charAt(0) == '/' || arg.charAt(0) == '\\') && Character.isLetter(arg.charAt(1))) {
                return arg;
            }
            if (arg.charAt(1) == ':' && Character.isLetter(arg.charAt(0))) {
                return "/" + arg.charAt(0);
            }
        } else if (arg.length() == 3) {
            if (arg.charAt(0) == '/' && arg.charAt(2) == ':' && Character.isLetter(arg.charAt(1))) {
                return "/" + arg.charAt(1);
            }
            if (arg.endsWith(":\\") && Character.isLetter(arg.charAt(0))) {
                return "/" + arg.charAt(0);
            }
        }
        File[] fileArray = files = Util.getFilteredFileList(path, "");
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File f = fileArray[n];
            if (f.getName().equals(arg)) {
                String newpath = Util.toForwardPathSeparator(f.getAbsolutePath());
                if ((newpath = newpath.replace(":", "")).charAt(0) != '/') {
                    newpath = "/" + newpath;
                }
                return newpath;
            }
            ++n;
        }
        throw new BilabException("directory not found");
    }

    public static String list() {
        NamespaceScope globalScope = BilabPlugin.getDefault().getGlobalScope();
        TypeSpec summaryAnnotationType = new TypeSpec((Type)((Object)Summary.class));
        Entry[] entries = globalScope.getEntries(null, null);
        StringBuilder sb = new StringBuilder();
        Entry[] entryArray = entries;
        int n = 0;
        int n2 = entryArray.length;
        while (n < n2) {
            Entry entry = entryArray[n];
            Annotation summaryAnnot = entry.getAnnotation(summaryAnnotationType);
            if (summaryAnnot != null) {
                String summary = null;
                if (summaryAnnot instanceof ScigolAnnotation) {
                    Value v = (Value)((ScigolAnnotation)summaryAnnot).getMembers().get(0);
                    summary = (String)v.getValue();
                } else {
                    summary = ((Summary)summaryAnnot).value();
                }
                sb.append(String.valueOf(entry.name) + " - " + summary + "\n");
            }
            ++n;
        }
        return sb.toString();
    }

    public static void throwBilabException(String message) {
        throw new BilabException(message);
    }

    public static class RegexFilenameFilter
    implements FilenameFilter {
        private Pattern pattern;

        public RegexFilenameFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(File dir, String name) {
            Matcher m = this.pattern.matcher(name);
            return m.matches();
        }
    }
}

