/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.IResourceIOProvider;
import bilab.Notify;
import bilab.Util;
import bilab.ViewerBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import scigol.Debug;
import scigol.Map;
import scigol.TypeSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    private int uniqueIDCount = 0;
    private Plugin plugin;
    private String resourceBundleName;
    private ResourceBundle resourceBundle = null;
    private java.util.Map<String, ResourceTypeInfo> resTypeRegistry;
    private java.util.Map<String, List<String>> resExtRegistry;
    private java.util.Map<String, List<TypeSpec>> resImporterRegistry;
    private java.util.Map<String, List<TypeSpec>> resExporterRegistry;
    private LinkedList<RegistryPair> viewerRegistry;
    protected static final String exeSuffix = ResourceManager.platformOS().equals("win") ? ".exe" : "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ResourceManager(Plugin plugin, String resourceBundleName) {
        this.plugin = plugin;
        this.resourceBundleName = resourceBundleName;
        this.viewerRegistry = new LinkedList();
        this.resTypeRegistry = new HashMap<String, ResourceTypeInfo>();
        this.resExtRegistry = new HashMap<String, List<String>>();
        this.resImporterRegistry = new HashMap<String, List<TypeSpec>>();
        this.resExporterRegistry = new HashMap<String, List<TypeSpec>>();
    }

    public ResourceBundle getPluginResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
        }
        return this.resourceBundle;
    }

    public String getStringResource(String key) {
        try {
            return this.getPluginResourceBundle() != null ? this.getPluginResourceBundle().getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getPluginFilesystemRoot() throws IOException {
        Bundle bundle = this.plugin.getBundle();
        URL libsURL = Platform.find((Bundle)bundle, (IPath)new Path("libs"));
        String libsPath = Platform.resolve((URL)libsURL).getFile();
        String rootPath = String.valueOf(libsPath) + "/../..";
        File rootAbsPath = new File(rootPath);
        return rootAbsPath.getCanonicalPath();
    }

    public URL findResource(String resourceName) throws IOException {
        Path path;
        if (resourceName.startsWith("/")) {
            return Platform.resolve((URL)new URL("file:" + resourceName));
        }
        if (resourceName.startsWith("file:") || resourceName.startsWith("http:")) {
            return Platform.resolve((URL)new URL(resourceName));
        }
        Bundle bundle = this.plugin.getBundle();
        URL resURL = Platform.find((Bundle)bundle, (IPath)(path = new Path(resourceName)));
        if (resURL == null && (resURL = Platform.find((Bundle)bundle, (IPath)(path = new Path("resources/" + resourceName)))) == null && (resURL = Platform.find((Bundle)bundle, (IPath)(path = new Path("libs/" + resourceName)))) == null && (resURL = Platform.find((Bundle)bundle, (IPath)(path = new Path("../" + resourceName)))) == null) {
            throw new IOException("not found");
        }
        return Platform.resolve((URL)resURL);
    }

    public String resourceNameToNativeFileName(String resourceName) {
        try {
            resourceName = resourceName.startsWith("/") ? Platform.resolve((URL)new URL("file:" + resourceName)).getFile() : (resourceName.startsWith("file:") || resourceName.startsWith("http:") ? Platform.resolve((URL)new URL(resourceName)).getFile() : String.valueOf(this.getPluginFilesystemRoot()) + "/resources/" + resourceName);
        }
        catch (IOException iOException) {}
        return Util.toNativePathSeparator(resourceName);
    }

    public List<String> getResourceTypesWithExtension(String extension) {
        if (this.resExtRegistry.containsKey(extension.toLowerCase())) {
            return this.resExtRegistry.get(extension.toLowerCase());
        }
        return new LinkedList<String>();
    }

    public List<String> getResourceTypesWithExtensions(List<String> extensions) {
        LinkedList<String> types = new LinkedList<String>();
        for (String ext : extensions) {
            List<String> typesForExt = this.getResourceTypesWithExtension(ext.toLowerCase());
            for (String type : typesForExt) {
                types.add(type);
            }
        }
        return types;
    }

    public static String resourceURLToFilename(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new BilabException("URL doesn't refer to a local file: " + url);
        }
        return url.getFile();
    }

    public static String filenameToResourceName(String nativeFilename) {
        String resname = nativeFilename;
        if (ResourceManager.platformOS().equals("win") && nativeFilename.length() > 1 && nativeFilename.charAt(1) == ':') {
            resname = "/" + resname;
        }
        resname = Util.toForwardPathSeparator(resname);
        return resname;
    }

    public InputStream findResourceStream(String resourceName) throws IOException {
        InputStream is = BilabPlugin.class.getResourceAsStream(resourceName);
        if (is != null) {
            return is;
        }
        URL url = this.findResource(resourceName);
        return url.openStream();
    }

    public OutputStream createResourceStream(String resourceName) throws IOException {
        String pathName = resourceName;
        if (resourceName.startsWith("file:") || resourceName.startsWith("http:")) {
            URL resURL = new URL(resourceName);
            if (!resURL.getProtocol().equals("file")) {
                throw new BilabException("Resources can only be created using local file: URLs or filesystem paths");
            }
            pathName = resURL.getFile();
        }
        if (!pathName.startsWith("/")) {
            Notify.unimplemented(this, "relative paths for resource creation; path:" + pathName);
            return null;
        }
        String nativePathName = Util.toNativePathSeparator(pathName);
        File file = new File(nativePathName);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }

    public void deleteResource(String resourceName) throws IOException {
        String pathName = resourceName;
        if (resourceName.startsWith("file:") || resourceName.startsWith("http:")) {
            URL resURL = new URL(resourceName);
            if (!resURL.getProtocol().equals("file")) {
                throw new BilabException("Resources can only be deleted using local file: URLs or filesystem paths");
            }
            pathName = resURL.getFile();
        }
        if (!pathName.startsWith("/")) {
            Debug.Unimplemented("relative paths for resource deletion");
        } else {
            String nativePathName = Util.toNativePathSeparator(pathName);
            File file = new File(nativePathName);
            file.delete();
        }
    }

    public void registerViewer(TypeSpec valueType, TypeSpec viewerType) {
        Debug.Assert(viewerType.isClass());
        this.viewerRegistry.add(new RegistryPair(valueType, viewerType));
    }

    public boolean existsRegisteredViewer(TypeSpec valueType) {
        for (RegistryPair viewerPair : this.viewerRegistry) {
            if (!valueType.isA(viewerPair.valueType)) continue;
            return true;
        }
        return false;
    }

    public ViewerBase instantiateViewer(TypeSpec valueType, Composite parent) {
        for (RegistryPair viewerPair : this.viewerRegistry) {
            if (!valueType.isA(viewerPair.valueType)) continue;
            TypeSpec viewerType = viewerPair.viewerType;
            if (!viewerType.getClassInfo().isExternal()) {
                Debug.Unimplemented("viewers implemented in scigol");
                continue;
            }
            Class viewerClass = (Class)viewerType.getClassInfo().getSysType();
            Class[] argTypes = new Class[]{Composite.class};
            Constructor ctor = null;
            try {
                ctor = viewerClass.getConstructor(argTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Debug.Assert(false, "viewer type doesn't implement required constructor with Composite argument");
            }
            Object[] args = new Object[]{parent};
            try {
                ViewerBase instance = (ViewerBase)((Object)ctor.newInstance(args));
                return instance;
            }
            catch (Exception e) {
                Notify.devWarning(BilabPlugin.class, "failed to instantiate new viewer of type:" + viewerType + " - " + e);
                return null;
            }
        }
        return null;
    }

    public boolean existsViewer(TypeSpec valueType) {
        for (RegistryPair viewerPair : this.viewerRegistry) {
            if (!valueType.isA(viewerPair.valueType)) continue;
            return true;
        }
        return false;
    }

    public void registerResourceType(String resourceTypeName, String description, String extension) {
        List<Object> l;
        ResourceTypeInfo rtinfo = null;
        String[] exts = new String[]{extension.toLowerCase()};
        if (extension == null) {
            exts = new String[]{};
        }
        if (!this.existsResourceType(resourceTypeName)) {
            Notify.logInfo(BilabPlugin.class, "  registering " + resourceTypeName + ": " + description);
            rtinfo = new ResourceTypeInfo(resourceTypeName, description, exts);
            this.resTypeRegistry.put(resourceTypeName, rtinfo);
        } else {
            String ext;
            rtinfo = this.resTypeRegistry.get(resourceTypeName);
            LinkedList<String> newexts = new LinkedList<String>();
            String[] stringArray = rtinfo.extensions;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                ext = stringArray[n];
                newexts.add(ext);
                ++n;
            }
            stringArray = exts;
            n = 0;
            n2 = stringArray.length;
            while (n < n2) {
                ext = stringArray[n];
                if (!newexts.contains(ext)) {
                    newexts.add(ext);
                }
                ++n;
            }
            rtinfo.extensions = newexts.toArray(new String[0]);
        }
        if (!this.resExtRegistry.containsKey(extension.toLowerCase())) {
            l = new LinkedList<String>();
            l.add(resourceTypeName);
            this.resExtRegistry.put(extension.toLowerCase(), l);
        } else {
            l = this.resExtRegistry.get(extension.toLowerCase());
            if (!l.contains(resourceTypeName)) {
                l.add(resourceTypeName);
            }
        }
    }

    public void registerResourceType(String resourceTypeName, String description, String ext1, String ext2) {
        this.registerResourceType(resourceTypeName, description, ext1);
        this.registerResourceType(resourceTypeName, description, ext2);
    }

    public void registerResourceType(String resourceTypeName, String description, String ext1, String ext2, String ext3) {
        this.registerResourceType(resourceTypeName, description, ext1);
        this.registerResourceType(resourceTypeName, description, ext2);
        this.registerResourceType(resourceTypeName, description, ext3);
    }

    public void registerResourceType(String resourceTypeName, String description, String ext1, String ext2, String ext3, String ext4) {
        this.registerResourceType(resourceTypeName, description, ext1);
        this.registerResourceType(resourceTypeName, description, ext2);
        this.registerResourceType(resourceTypeName, description, ext3);
        this.registerResourceType(resourceTypeName, description, ext4);
    }

    public void registerResourceIOProvider(TypeSpec provider) {
        Debug.Assert(provider != null && provider.isClass());
        if (!provider.getClassInfo().isExternal()) {
            Notify.devError(BilabPlugin.class, "scigol IResourceIOProviders unsupported");
            return;
        }
        Debug.Assert(provider.isA(new TypeSpec((Type)((Object)IResourceIOProvider.class))));
        Class sysClass = null;
        try {
            sysClass = (Class)provider.getClassInfo().getSysType();
            Method supportedImportMethod = sysClass.getMethod("getSupportedImportResourceTypes", new Class[0]);
            Method supportedExportMethod = sysClass.getMethod("getSupportedExportResourceTypes", new Class[0]);
            List importTypesSupported = (List)supportedImportMethod.invoke(null, new Object[0]);
            for (String resourceTypeName : importTypesSupported) {
                List<Object> importers;
                if (!this.existsResourceType(resourceTypeName)) {
                    Notify.devError(BilabPlugin.class, "IResourceIOProvider class " + sysClass + " imports resource type '" + resourceTypeName + "' that hasn't been registered");
                }
                if (!this.resImporterRegistry.containsKey(resourceTypeName)) {
                    importers = new LinkedList<TypeSpec>();
                    importers.add(provider);
                    this.resImporterRegistry.put(resourceTypeName, importers);
                    continue;
                }
                importers = this.resImporterRegistry.get(resourceTypeName);
                if (importers.contains(provider)) continue;
                importers.add(provider);
            }
            List exportTypesSupported = (List)supportedExportMethod.invoke(null, new Object[0]);
            for (String resourceTypeName : exportTypesSupported) {
                List<Object> exporters;
                if (!this.existsResourceType(resourceTypeName)) {
                    Notify.devError(BilabPlugin.class, "IResourceIOProvider class " + sysClass + " exports resource type '" + resourceTypeName + "' that hasn't been registered");
                }
                if (!this.resExporterRegistry.containsKey(resourceTypeName)) {
                    exporters = new LinkedList<TypeSpec>();
                    exporters.add(provider);
                    this.resExporterRegistry.put(resourceTypeName, exporters);
                    continue;
                }
                exporters = this.resExporterRegistry.get(resourceTypeName);
                if (exporters.contains(provider)) continue;
                exporters.add(provider);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Notify.devError(BilabPlugin.class, "class " + sysClass + " marked with interace IResourceIOProvider doesn't have required getSupported[Import|Export]ResourceTypes() method.");
        }
        catch (Exception e) {
            Notify.devWarning(BilabPlugin.class, "error registering IResourceIOProvider:" + e);
        }
    }

    public boolean existsResourceType(String resourceTypeName) {
        return this.resTypeRegistry.containsKey(resourceTypeName);
    }

    public List<TypeSpec> getResourceImportersForType(String resourceTypeName) {
        if (this.resImporterRegistry.containsKey(resourceTypeName)) {
            return this.resImporterRegistry.get(resourceTypeName);
        }
        return new LinkedList<TypeSpec>();
    }

    public List<TypeSpec> getResourceExportersForType(String resourceTypeName) {
        if (this.resExporterRegistry.containsKey(resourceTypeName)) {
            return this.resExporterRegistry.get(resourceTypeName);
        }
        return new LinkedList<TypeSpec>();
    }

    public String getResourceTypeDefaultExtension(String resourceType) {
        ResourceTypeInfo rinfo = this.resTypeRegistry.get(resourceType);
        if (rinfo == null) {
            return "dat";
        }
        if (rinfo.extensions.length > 0) {
            return rinfo.extensions[0];
        }
        return "dat";
    }

    public Object instantiateObjectFromResource(TypeSpec importerType, String resourceName, String resourceType) {
        List<String> types;
        String ext;
        if ((resourceType.equals("unknown") || resourceType.length() == 0) && (ext = Util.extension(resourceName)).length() != 0 && (types = this.getResourceTypesWithExtension(ext)).size() == 1) {
            resourceType = types.get(0);
        }
        Object imported = null;
        Class sysClass = null;
        try {
            sysClass = (Class)importerType.getClassInfo().getSysType();
            Class[] argTypes = new Class[3];
            argTypes[0] = ResourceManager.class;
            argTypes[2] = String.class;
            argTypes[1] = String.class;
            Method method = sysClass.getMethod("importResource", argTypes);
            Object[] args = new Object[]{this, resourceName, resourceType};
            imported = method.invoke(null, args);
            return imported;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Notify.devError(BilabPlugin.class, "class " + sysClass + " marked with interace IResourceIOProvider doesn't have the required importResource(String,String) method.");
        }
        catch (InvocationTargetException e) {
            throw new BilabException("error importing resource:" + e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            Notify.devInfo(BilabPlugin.class, "unable to instantiate object from resource via type " + sysClass + " - " + e);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public Object instantiateObjectFromResource(String resourceName, String resourceType) {
        LinkedList<String> resTypes = new LinkedList<String>();
        if (resourceType.equals("unknown") || resourceType.length() == 0) {
            String ext = Util.extension(resourceName);
            if (ext.length() != 0) {
                List<String> extTypes = this.getResourceTypesWithExtension(ext);
                for (String type : extTypes) {
                    resTypes.add(type);
                }
            }
        } else {
            resTypes.add(resourceType);
        }
        Object imported = null;
        for (String resType : resTypes) {
            List<TypeSpec> importerTypes = this.getResourceImportersForType(resType);
            for (TypeSpec importerType : importerTypes) {
                try {
                    imported = this.instantiateObjectFromResource(importerType, resourceName, resType);
                    if (imported == null) continue;
                    return imported;
                }
                catch (BilabException e) {
                    throw e;
                }
                catch (Exception e) {
                    Notify.devWarning(BilabPlugin.class, "failed to instantiate object for resource of type '" + resType + "' via type '" + importerType + "' - " + e);
                }
            }
            if (!resType.equals("TEXT")) continue;
            InputStream istream = null;
            try {
                istream = this.findResourceStream(resourceName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                do {
                    if ((line = reader.readLine()) == null) continue;
                    sb.append(String.valueOf(line) + "\n");
                } while (line != null);
                istream.close();
                String string = sb.toString();
                try {
                    if (istream != null) {
                        istream.close();
                    }
                }
                catch (IOException iOException) {}
                return string;
            }
            catch (IOException iOException) {
                {
                    catch (Throwable throwable) {
                        try {
                            if (istream != null) {
                                istream.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
            }
            try {
                if (istream == null) continue;
                istream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public List<TypeSpec> getResourceImportersForTypes(List<String> resourceTypeNames) {
        LinkedList<TypeSpec> importers = new LinkedList<TypeSpec>();
        for (String resourceTypeName : resourceTypeNames) {
            List<TypeSpec> imps = this.getResourceImportersForType(resourceTypeName);
            for (TypeSpec importer : imps) {
                importers.add(importer);
            }
        }
        Debug.WL("importer types for resource types " + resourceTypeNames + " - " + importers);
        return importers;
    }

    public void exportObjectToResource(Object value, String resourceType, String resourceName) {
        List<TypeSpec> exporterTypes = this.getResourceExportersForType(resourceType);
        if (exporterTypes.size() == 0) {
            throw new BilabException("no registered exporters for resource type '" + resourceType + "'");
        }
        if (!(exporterTypes.get(0).getSysType() instanceof Class)) {
            Notify.devError(this, "Scigol IResourceIOProviers unsupported");
        }
        Class sysClass = (Class)exporterTypes.get(0).getSysType();
        Method method = null;
        boolean done = false;
        Class<?> vtype = value.getClass();
        while (method == null && !done) {
            Class[] argTypes = new Class[4];
            argTypes[0] = ResourceManager.class;
            argTypes[1] = vtype;
            argTypes[3] = String.class;
            argTypes[2] = String.class;
            try {
                method = sysClass.getMethod("exportResource", argTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) continue;
            if (vtype.getSuperclass() == null) {
                done = true;
                continue;
            }
            vtype = vtype.getSuperclass();
        }
        if (method == null) {
            Notify.devError(this, "class '" + sysClass + "' marked as implementing interface 'IResourceIOProvider' has no exportResource(...) method as required");
        }
        try {
            Object[] args = new Object[]{this, value, resourceName, resourceType};
            method.invoke(null, args);
        }
        catch (BilabException bilabException) {
        }
        catch (IllegalAccessException e) {
            Notify.devError(this, "illegal access exception invoking " + sysClass + ".exportResource(...):" + e.getCause().getMessage());
        }
        catch (InvocationTargetException e) {
            throw new BilabException("error exporting resource:" + e.getCause().getMessage(), e.getCause());
        }
    }

    public Map resourceTypesMap() {
        Map map = new Map();
        for (String key : this.resTypeRegistry.keySet()) {
            ResourceTypeInfo rtinfo = this.resTypeRegistry.get(key);
            String exts = "; exts:";
            String[] stringArray = rtinfo.extensions;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String ext = stringArray[n];
                exts = String.valueOf(exts) + " " + ext;
                ++n;
            }
            map.put(key, String.valueOf(rtinfo.description) + exts);
        }
        return map;
    }

    public String uniqueTemporaryResourceName(String resourceType) {
        String extension = this.getResourceTypeDefaultExtension(resourceType);
        String name = "temp";
        ++this.uniqueIDCount;
        return "/tmp/" + name + this.uniqueIDCount + "." + extension;
    }

    public static String platformOS() {
        if (File.separatorChar == '/') {
            return "unix";
        }
        return "win";
    }

    public static String platformUSerHomeDir() {
        String absHomePath = Util.toForwardPathSeparator(System.getProperty("user.home"));
        if (absHomePath.charAt(0) != '/') {
            absHomePath = "/" + absHomePath;
        }
        absHomePath = absHomePath.replace(":", "");
        return absHomePath;
    }

    static final class ResourceTypeInfo {
        public String type;
        public String description;
        public String[] extensions;

        public ResourceTypeInfo(String resourceType, String desc, String[] exts) {
            this.type = resourceType;
            this.description = desc;
            this.extensions = exts;
        }
    }

    static final class RegistryPair {
        public TypeSpec valueType;
        public TypeSpec viewerType;

        public RegistryPair(TypeSpec valType, TypeSpec viewType) {
            this.valueType = valType;
            this.viewerType = viewType;
        }
    }
}

