/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.DNA;
import bilab.Notify;
import bilab.ResourceManager;
import bilab.Util;
import bilab.alignment;
import bilab.protein;
import bilab.seq;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import scigol.TypeSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalApps {
    protected static final String exeSuffix = ResourceManager.platformOS().equals("win") ? ".exe" : "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String RNAll(seq sequence, boolean nonOverlapping, boolean terminatorPrediction, int windowSize, double energyThreashold, double symMapThreashold, int loopSize, double tweight, double hybridEnergy, boolean produceCTFile) {
        try {
            String line;
            boolean existingResourceAvailable = ExternalApps.isInputResourceAvailable(sequence, "FASTA");
            String resourceName = ExternalApps.getInputResource(sequence, "FASTA");
            String pluginRoot = BilabPlugin.getResourceManager().getPluginFilesystemRoot();
            String RNAllRoot = String.valueOf(pluginRoot) + '/' + "RNAll";
            String outputResourceName = BilabPlugin.getResourceManager().uniqueTemporaryResourceName("TEXT");
            LinkedList<String> args = new LinkedList<String>();
            args.add("-i");
            args.add(Util.toNativePathSeparator(resourceName));
            args.add("-o");
            args.add(Util.toNativePathSeparator(outputResourceName));
            args.add("-g");
            if (nonOverlapping) {
                args.add("-f");
            }
            if (terminatorPrediction) {
                args.add("-t");
            }
            args.add("-w");
            args.add("" + windowSize);
            args.add("-e");
            args.add("" + energyThreashold);
            args.add("-s");
            args.add("" + symMapThreashold);
            args.add("-l");
            args.add("" + loopSize);
            args.add("-u");
            args.add("" + tweight);
            args.add("-h");
            args.add("" + hybridEnergy);
            if (produceCTFile) {
                args.add("-c");
            }
            ExternalApps.exec("RNAll", RNAllRoot, args);
            try {
                if (!existingResourceAvailable) {
                    BilabPlugin.getResourceManager().deleteResource(resourceName);
                }
            }
            catch (IOException iOException) {}
            InputStream rnallStructFile = BilabPlugin.getResourceManager().findResourceStream(outputResourceName);
            BufferedReader rnallStructReader = new BufferedReader(new InputStreamReader(rnallStructFile));
            StringBuilder structString = new StringBuilder();
            do {
                if ((line = rnallStructReader.readLine()) == null) continue;
                structString.append(String.valueOf(line) + "\n");
            } while (line != null);
            rnallStructFile.close();
            try {
                BilabPlugin.getResourceManager().deleteResource(outputResourceName);
            }
            catch (IOException iOException) {}
            return structString.toString();
        }
        catch (IOException e) {
            throw new BilabException("IO error during RNAll invocation - " + e);
        }
    }

    public static alignment clustalw(scigol.List sequences) {
        if (sequences.get_size() < 2) {
            throw new BilabException("the sequences:list must contain at least 2 sequences (DNA or protein)");
        }
        if (!(sequences.get_head().value instanceof DNA) && !(sequences.get_head().value instanceof protein)) {
            throw new BilabException("the sequences:list elements must must be either all DNA or all protein");
        }
        TypeSpec eltType = TypeSpec.typeOf(sequences.get_head().value);
        int i = 0;
        while (i < sequences.get_size()) {
            seq s = (seq)sequences.get_Item((int)i).value;
            TypeSpec sType = TypeSpec.typeOf(s);
            if (!sType.equals(eltType)) {
                throw new BilabException("the sequences:list elements must must be either all DNA or all protein");
            }
            ++i;
        }
        boolean nucleotide = eltType.equals(new TypeSpec((Type)((Object)DNA.class)));
        String inputResourceName = BilabPlugin.getResourceManager().uniqueTemporaryResourceName("FASTA");
        OutputStream fastaOut = null;
        try {
            try {
                fastaOut = BilabPlugin.getResourceManager().createResourceStream(inputResourceName);
                int i2 = 0;
                while (i2 < sequences.get_size()) {
                    seq s = (seq)sequences.get_Item((int)i2).value;
                    seq.exportResource(BilabPlugin.getResourceManager(), s, fastaOut, "FASTA");
                    ++i2;
                }
            }
            catch (Exception e) {
                throw new BilabException("unable to convert sequence list to multi-sequence FASTA format - " + e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fastaOut != null) {
                    fastaOut.flush();
                    fastaOut.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fastaOut != null) {
                fastaOut.flush();
                fastaOut.close();
            }
        }
        catch (Exception exception) {}
        try {
            String outputResourceName = BilabPlugin.getResourceManager().uniqueTemporaryResourceName("CLUSTALW");
            String pluginRoot = BilabPlugin.getResourceManager().getPluginFilesystemRoot();
            String clustalWRoot = String.valueOf(pluginRoot) + '/' + "ClustalW";
            LinkedList<String> args = new LinkedList<String>();
            args.add("-INFILE=" + Util.toNativePathSeparator(inputResourceName));
            args.add("-TYPE=" + (nucleotide ? "DNA" : "PROTEIN"));
            args.add("-OUTFILE=" + Util.toNativePathSeparator(outputResourceName));
            ExternalApps.exec("clustalw", clustalWRoot, args);
            try {
                BilabPlugin.getResourceManager().deleteResource(inputResourceName);
            }
            catch (IOException iOException) {}
            alignment aln = (alignment)Util.readResource((String)outputResourceName, (String)"CLUSTALW").value;
            try {
                BilabPlugin.getResourceManager().deleteResource(outputResourceName);
            }
            catch (IOException iOException) {}
            return aln;
        }
        catch (IOException e) {
            throw new BilabException("IO error during clustalw execution - " + e);
        }
    }

    protected static String exec(String commandName, String commandDir, List<String> args) {
        try {
            LinkedList<String> cmdline = new LinkedList<String>();
            cmdline.add(String.valueOf(commandDir) + '/' + commandName + exeSuffix);
            cmdline.addAll(args);
            StringBuilder cmdlineStr = new StringBuilder();
            for (String s : cmdline) {
                cmdlineStr.append(String.valueOf(s) + " ");
            }
            Notify.logInfo(ExternalApps.class, "invoking external command:" + cmdlineStr.toString());
            ProcessBuilder pb = new ProcessBuilder(cmdline);
            pb.directory(new File(commandDir));
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream cmdResultStream = process.getInputStream();
            InputStreamReader cmdResultReader = new InputStreamReader(cmdResultStream);
            StringBuilder str = new StringBuilder();
            int c = cmdResultReader.read();
            while (c != -1) {
                str.append((char)c);
                c = cmdResultReader.read();
            }
            process.waitFor();
            cmdResultStream.close();
            return str.toString();
        }
        catch (Exception e) {
            throw new BilabException("unable to execute command (external command invocation failed) - " + e);
        }
    }

    protected static boolean isInputResourceAvailable(seq sequence, String requiredResourceFormat) {
        String resourceName = sequence.get_AssociatedResource();
        if (resourceName == null) {
            return false;
        }
        List<String> typesForExtension = BilabPlugin.getResourceManager().getResourceTypesWithExtension(Util.extension(resourceName));
        if (typesForExtension.size() == 0) {
            return false;
        }
        if (typesForExtension.size() > 1) {
            return false;
        }
        return typesForExtension.contains(requiredResourceFormat);
    }

    protected static String getInputResource(seq sequence, String requiredResourceType) {
        try {
            if (ExternalApps.isInputResourceAvailable(sequence, requiredResourceType)) {
                return new URL(sequence.get_AssociatedResource()).getFile();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        List<String> supportedResourceTypes = seq.getSupportedExportResourceTypes();
        if (!supportedResourceTypes.contains(requiredResourceType)) {
            throw new BilabException("the supplied sequence cannot be converted into a format suitable for input into the requested function");
        }
        String resourceName = BilabPlugin.getResourceManager().uniqueTemporaryResourceName(requiredResourceType);
        seq.exportResource(BilabPlugin.getResourceManager(), sequence, resourceName, requiredResourceType);
        return resourceName;
    }
}

