/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabException;
import bilab.MoleculeImpl;
import bilab.Notify;
import bilab.RNA;
import bilab.Sophistication;
import bilab.Summary;
import bilab.seq;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import scigol.Any;
import scigol.Debug;
import scigol.List;
import scigol.Map;
import scigol.Range;
import scigol.accessor;

@Summary(value="A DNA sequence molecule")
public class DNA
extends seq
implements Cloneable {
    @Summary(value="The underlying biojava Sequence representing this DNA")
    @Sophistication(value=2)
    public Sequence seq;

    public DNA() {
        try {
            this.seq = DNATools.createDNASequence((String)"", (String)"dna");
        }
        catch (BioException bioException) {
            Debug.Assert(false, "biojava error");
        }
    }

    @Sophistication(value=2)
    public DNA(Sequence s) {
        this.seq = s;
    }

    @Summary(value="create a DNA sequence from a string.  For example \"atggccat\".")
    public DNA(String seq2) {
        try {
            this.seq = DNATools.createDNASequence((String)seq2, (String)"dna");
        }
        catch (BioException e) {
            throw new BilabException("biojava error", e);
        }
    }

    public Object clone() {
        Notify.devWarning(this, "clone(): features not cloned");
        DNA copy = null;
        try {
            copy = (DNA)super.clone();
            copy.seq = DNATools.createDNASequence((String)this.seq.seqString(), (String)this.seq.getName());
            DNA.addAnnotationsToSequence(copy.seq, this.get_annotations());
        }
        catch (IllegalSymbolException illegalSymbolException) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return copy;
    }

    @accessor
    public DNA get_Item(Range r) {
        r = r.normalize(this.seq.length());
        return new DNA(this.seq.subStr(r.start + 1, r.end + 1));
    }

    @accessor
    public Any get_Item(int i) {
        try {
            Symbol sym = this.seq.symbolAt(i + 1);
            Alphabet alpha = sym.getMatches();
            List mols = new List();
            if (alpha.contains((Symbol)DNATools.a())) {
                mols.add(MoleculeImpl.A);
            }
            if (alpha.contains((Symbol)DNATools.c())) {
                mols.add(MoleculeImpl.C);
            }
            if (alpha.contains((Symbol)DNATools.g())) {
                mols.add(MoleculeImpl.G);
            }
            if (alpha.contains((Symbol)DNATools.t())) {
                mols.add(MoleculeImpl.T);
            }
            if (mols.get_size() == 1) {
                return mols.get_head();
            }
            return new Any(mols);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BilabException("index must be in range 0.." + (this.seq.length() - 1) + ", not " + i);
        }
    }

    @accessor
    public void set_Item(int i, Any value) {
        Debug.Unimplemented();
    }

    @Summary(value="Transcribe DNA into RNA")
    public static RNA transcribe(DNA dna) {
        return dna.get_transcription();
    }

    @accessor
    @Summary(value="Transcription into RNA")
    public RNA get_transcription() {
        try {
            return new RNA((Sequence)new SimpleSequence(RNATools.transcribe((SymbolList)this.seq), String.valueOf(this.seq.getURN()) + "|transcription", String.valueOf(this.seq.getName()) + " transcription", this.seq.getAnnotation()));
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BilabException("Cannot transcribe DNA with alphabet '" + this.seq.getAlphabet().getName() + "'");
        }
    }

    @Summary(value="Reverse compliment of DNA")
    public static DNA op_UnaryNegation(DNA dna) {
        return dna.get_Compliment();
    }

    @accessor
    @Summary(value="Reverse compliment")
    public DNA get_Compliment() {
        try {
            return new DNA((Sequence)new SimpleSequence(DNATools.reverseComplement((SymbolList)this.seq), String.valueOf(this.seq.getURN()) + "|compliment", String.valueOf(this.seq.getName()) + " compliment", this.seq.getAnnotation()));
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BilabException("Cannot reverse compliment DNA with alphabet '" + this.seq.getAlphabet().getName() + "'");
        }
    }

    public static DNA op_Addition(DNA dna1, DNA dna2) {
        String seq1 = dna1.get_rawsequence();
        String seq2 = dna2.get_rawsequence();
        return new DNA(String.valueOf(seq1) + seq2);
    }

    public static int op_Card(DNA dna) {
        return dna.seq.length();
    }

    @accessor
    public String get_name() {
        return this.seq.getName();
    }

    @accessor
    public String get_ShortText() {
        return this.get_name();
    }

    @accessor
    public String get_DetailText() {
        return this.get_ShortText();
    }

    @Summary(value="get sequence as a string of letters formatted into columns")
    public String get_sequence() {
        return DNA.formatSeqString(this.seq.seqString().toUpperCase());
    }

    @Summary(value="get sequence as a string of continous letters")
    public String get_rawsequence() {
        return this.seq.seqString().toUpperCase();
    }

    public Map get_annotations() {
        Map m = new Map();
        for (Object key : this.seq.getAnnotation().keys()) {
            m.add(key, this.seq.getAnnotation().getProperty(key));
        }
        return m;
    }

    public String toString() {
        return super.toString().toUpperCase();
    }
}

