/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import antlr.ANTLRException;
import bilab.BilabException;
import bilab.BilabPlugin;
import bilab.ISourceExecutor;
import bilab.ResourceManager;
import bilab.SizedComposite;
import bilab.Util;
import bilab.ValueSelection;
import bilab.ValueViewer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scigol.Any;
import scigol.InternalScigolError;
import scigol.NamespaceScope;
import scigol.ScigolException;
import scigol.Symbol;
import scigol.TypeSpec;
import scigol.Utils;
import scigol.Value;

public class ConsoleView
extends ViewPart
implements ISelectionProvider {
    public static final String prompt = ">";
    protected static final int minContentHeight = 1032;
    protected static final int maxContentHeight = 10000;
    protected static final int minContentWidth = 384;
    public static final int userTextColor = 9;
    public static final int fontPixelWidth = 8;
    public static final int fontPixelHeight = 10;
    static ArrayList<ISelectionChangedListener> selectionChangedListeners = new ArrayList();
    Value selectedValue = null;
    NamespaceScope globalScope;
    ISourceExecutor executor;
    ResourceManager rm;
    Display display;
    ScrolledComposite scrolledComposite;
    Composite content;
    FormLayout formLayout;
    ArrayList<Control> controls;
    Text inputControl;
    Font consoleFont;
    ArrayList<String> lineHistory;
    int historyPosition = 0;
    String workingDirectory;

    public ConsoleView() {
        BilabPlugin bilab = BilabPlugin.getDefault();
        this.globalScope = bilab.getGlobalScope();
        this.executor = BilabPlugin.getExecutor();
        this.rm = BilabPlugin.getResourceManager();
        this.workingDirectory = "/";
    }

    public void createPartControl(Composite parent) {
        this.display = Display.getCurrent();
        this.scrolledComposite = new ScrolledComposite(parent, 2560);
        this.scrolledComposite.setAlwaysShowScrollBars(false);
        this.scrolledComposite.setBackground(this.display.getSystemColor(3));
        this.scrolledComposite.setExpandHorizontal(true);
        this.content = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.content);
        this.content.setBackground(this.display.getSystemColor(1));
        this.scrolledComposite.setMinSize(this.content.computeSize(-1, -1, false));
        this.inputControl = new Text(this.content, 16388);
        this.inputControl.setText(prompt);
        this.inputControl.setSelection(prompt.length());
        this.inputControl.setEditable(true);
        FontData fontData = new FontData("Courier New", 10, 0);
        this.consoleFont = new Font((Device)this.display, fontData);
        this.inputControl.setFont(this.consoleFont);
        this.inputControl.setBackground(this.display.getSystemColor(1));
        this.inputControl.setForeground(this.display.getSystemColor(9));
        this.inputControl.addKeyListener((KeyListener)new InputListener(this));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.inputControl.setLayoutData((Object)formData);
        this.formLayout = new FormLayout();
        this.formLayout.marginWidth = 3;
        this.formLayout.marginHeight = 3;
        this.content.setLayout((Layout)this.formLayout);
        this.controls = new ArrayList();
        this.lineHistory = new ArrayList();
        this.append(Utils.get_IntroHeader());
        this.append("type '.help' for help");
        this.scrollToEnd();
        this.setFocus();
        this.workingDirectory = ResourceManager.platformUSerHomeDir();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        this.inputControl.setFocus();
    }

    public Composite getContentParent() {
        return this.content;
    }

    public void append(Value v, String prefix) {
        if (v != null) {
            Value value = TypeSpec.unwrapAnyOrNumValue(v);
            if (value == null) {
                this.append(String.valueOf(prefix) + "null");
            } else {
                Composite container;
                boolean hasPrefix = false;
                if (prefix != null && prefix.length() > 0) {
                    hasPrefix = true;
                    container = new Composite(this.content, 0);
                    container.setBackground(this.display.getSystemColor(1));
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.numColumns = 2;
                    container.setLayout((Layout)gridLayout);
                    Label prefixLabel = new Label(container, 0);
                    prefixLabel.setBackground(this.display.getSystemColor(1));
                    prefixLabel.setText(prefix);
                    GridData gridData = new GridData();
                    gridData.horizontalAlignment = 4;
                    gridData.verticalAlignment = 1;
                    prefixLabel.setLayoutData((Object)gridData);
                } else {
                    container = this.content;
                }
                SizedComposite sized = new SizedComposite(container, 0);
                ValueViewer viewer = new ValueViewer(sized);
                viewer.setInput(value);
                Point viewerPreferedSize = viewer.preferedSize();
                if (viewerPreferedSize.x == -1) {
                    viewerPreferedSize.x = this.currentWidth();
                }
                Point viewerMaximumSize = viewer.maximumSize();
                if (viewerMaximumSize.x == 1024) {
                    viewerMaximumSize.x = this.currentWidth();
                }
                if (viewerMaximumSize.y == 1024) {
                    viewerMaximumSize.y = 5000;
                }
                sized.setPreferedSize(viewerPreferedSize);
                sized.setMinimumSize(50, 24);
                sized.setMaximumSize(viewerMaximumSize.x, Math.min(5000, viewerMaximumSize.y));
                if (hasPrefix) {
                    GridData gridData = new GridData();
                    gridData.horizontalAlignment = 4;
                    gridData.verticalAlignment = 4;
                    gridData.grabExcessHorizontalSpace = true;
                    sized.setLayoutData(gridData);
                    this.append((Control)container);
                } else {
                    this.append((Control)sized);
                }
            }
        }
    }

    protected void append(Control control) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)formData);
        this.controls.add(control);
        int height = 0;
        ArrayList<Control> removeList = new ArrayList<Control>();
        int i = this.controls.size() - 1;
        while (i >= 0) {
            Control c = this.controls.get(i);
            Point s = c.computeSize(-1, -1, false);
            if (height + s.y < 10000) {
                height += s.y;
            } else {
                removeList.add(c);
            }
            --i;
        }
        height = Math.max(1032, height);
        for (Control c : removeList) {
            this.controls.remove(c);
            c.dispose();
        }
        this.setLayoutData();
        this.content.setSize(this.currentWidth(), height);
        this.content.layout(true);
        this.content.redraw();
        this.scrollToEnd();
        this.scrolledComposite.layout(true);
        this.scrolledComposite.redraw();
    }

    protected int currentWidth() {
        int parentWidth = this.scrolledComposite.getClientArea().width;
        return Math.max(parentWidth, 384);
    }

    protected void setLayoutData() {
        if (this.controls.size() == 0) {
            return;
        }
        int c = this.controls.size() - 1;
        while (c >= 0) {
            Control control = this.controls.get(c);
            FormData data = (FormData)control.getLayoutData();
            data.bottom = c < this.controls.size() - 1 ? new FormAttachment(this.controls.get(c + 1)) : new FormAttachment((Control)this.inputControl);
            --c;
        }
    }

    public void append(String lines) {
        this.append(this.splitLines(lines), false, this.display.getSystemColor(2));
    }

    public void appendError(String errorLines) {
        this.append(this.splitLines(errorLines), false, this.display.getSystemColor(3));
    }

    protected String splitLines(String lines) {
        int contentCharWidth = this.currentWidth() / 8 - 1;
        if (lines.length() > contentCharWidth) {
            StringBuilder sb = new StringBuilder();
            int col = 0;
            int c = 0;
            while (c < lines.length()) {
                char ch = lines.charAt(c);
                sb.append(ch);
                ++col;
                if (ch == '\n' || ch == '\r') {
                    col = 0;
                }
                if (col == contentCharWidth) {
                    sb.append("\u25c4\n");
                    col = 0;
                }
                ++c;
            }
            return sb.toString();
        }
        return lines;
    }

    protected void append(String line, boolean addToHistory, Color color) {
        if (addToHistory) {
            this.lineHistory.add(line);
            if (this.lineHistory.size() > 1000) {
                this.lineHistory.remove(this.lineHistory.get(0));
            }
            this.historyPosition = this.lineHistory.size();
        }
        Label l = new Label(this.getContentParent(), 0);
        l.setBackground(this.display.getSystemColor(1));
        l.setText(line);
        l.setFont(this.consoleFont);
        l.setForeground(color);
        this.append((Control)l);
    }

    public void scrollToEnd() {
        ScrollBar vbar = this.scrolledComposite.getVerticalBar();
        vbar.setSelection(vbar.getMaximum());
    }

    public void dispose() {
        this.consoleFont.dispose();
    }

    public Value executeConsoleCommand(String command) {
        boolean supressOutput = command.endsWith(";");
        Value result = null;
        try {
            result = (Value)this.evaluateScigolExpression(command);
            if (this.rm.existsRegisteredViewer(TypeSpec.typeOf(TypeSpec.unwrapAnyOrNum(result)))) {
                String prefix = null;
                if (!supressOutput) {
                    if (result != null && result.isLValue()) {
                        Symbol s = result.getLValue().getSymbol();
                        prefix = !s.getName().equals("operator()") ? String.valueOf(s.getName()) + " = " : " = ";
                    }
                    this.append(result, prefix);
                }
            } else {
                String resultString = null;
                if (result != null) {
                    Object resultValue = result.getValue();
                    String string = resultString = resultValue != null ? resultValue.toString() : "null";
                }
                if (!supressOutput) {
                    String output = "";
                    if (result != null && result.isLValue()) {
                        Symbol s = result.getLValue().getSymbol();
                        output = !s.getName().equals("operator()") ? String.valueOf(output) + s.getName() + " = " : String.valueOf(output) + " = ";
                    }
                    if (resultString != null) {
                        output = String.valueOf(output) + resultString;
                    }
                    this.append(output);
                }
            }
        }
        catch (ScigolException e) {
            this.appendError("error:" + e.getMessage());
            e.printStackTrace();
        }
        catch (BilabException e) {
            this.appendError("error:" + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.appendError("error:" + e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            this.appendError("error:" + e);
            e.printStackTrace();
        }
        return result;
    }

    public Object evaluateScigolExpression(String expr) throws IOException, ANTLRException {
        if (expr.startsWith(".")) {
            return this.evaluateSpecialInteractiveCommand(expr);
        }
        return this.executor.executeSource(expr);
    }

    public Value evaluateSpecialInteractiveCommand(String command) throws ANTLRException {
        if (command.startsWith(".run")) {
            if (command.length() < 5) {
                throw new BilabException("usage: .run <file-name>");
            }
            String resourceName = command.substring(5);
            URL resourceURL = null;
            try {
                resourceURL = this.rm.findResource(resourceName);
            }
            catch (IOException e) {
                this.appendError("unable to find resource: " + resourceName + " - " + e.getMessage());
                return null;
            }
            try {
                InputStream srcStream = resourceURL.openStream();
                this.executor.executeSource(srcStream, resourceName);
                srcStream.close();
                return null;
            }
            catch (IOException e) {
                this.appendError("input/output error with " + resourceName + ":" + e.getMessage());
                e.printStackTrace();
            }
            catch (ANTLRException e) {
                this.appendError("error in " + resourceName + ":" + e.getMessage());
                e.printStackTrace();
            }
            catch (InternalScigolError e) {
                this.appendError("internal scigol error in " + resourceName + ":" + e);
                e.printStackTrace();
            }
            catch (ScigolException e) {
                this.appendError("error in " + resourceName + ":" + e.getMessage());
                e.printStackTrace();
            }
            catch (BilabException e) {
                this.appendError("error in " + resourceName + ":" + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.appendError("error in " + resourceName + ":" + e);
                e.printStackTrace();
            }
            return null;
        }
        if (command.startsWith(".using")) {
            int space = command.indexOf(32);
            if (space == -1) {
                this.appendError("invalid namespace, use .using <namespace>");
            } else {
                String namespaceName = command.substring(space + 1);
                try {
                    this.globalScope.addUsingNamespace(namespaceName);
                }
                catch (ScigolException e) {
                    this.appendError("error using namespace '" + namespaceName + "' - " + e);
                }
            }
            return null;
        }
        if (command.startsWith(".typeof")) {
            int space = command.indexOf(32);
            if (space == -1) {
                this.appendError("invalid name, use .typeof <name>");
            } else {
                String name = command.substring(space + 1);
                try {
                    Value v = (Value)this.evaluateScigolExpression(String.valueOf(name) + ";");
                    if (v.getValue() != null) {
                        TypeSpec type;
                        Object t = v.getValue();
                        if (!(t instanceof TypeSpec)) {
                            t = TypeSpec.unwrapAnyOrNum(t);
                            t = TypeSpec.typeOf(t);
                        }
                        if ((type = (TypeSpec)t).isClass()) {
                            this.append(type.getClassInfo().toStringFull());
                        } else {
                            this.append(type.toString());
                        }
                    } else {
                        this.append("value of " + name + " is null (type 'any')");
                    }
                }
                catch (ScigolException e) {
                    this.appendError("error in type expression: " + e.getMessage());
                }
                catch (ANTLRException e) {
                    this.appendError("error in type expression: " + e.getMessage());
                }
                catch (IOException e) {
                    this.appendError("IO error during expression execution: " + e.getMessage());
                }
            }
            return null;
        }
        if (command.startsWith(".show")) {
            int space = command.indexOf(32);
            if (space == -1) {
                this.appendError("invalid name, use .show <expression>");
            } else {
                String name = command.substring(space + 1);
                try {
                    Value v = (Value)this.evaluateScigolExpression(String.valueOf(name) + ";");
                    if (v.getValue() != null) {
                        this.selectedValue = v;
                        this.fireSelectionChangedListeners();
                    }
                }
                catch (ScigolException e) {
                    this.appendError("error in expression: " + e.getMessage());
                }
                catch (ANTLRException e) {
                    this.appendError("error in expression: " + e.getMessage());
                }
                catch (IOException e) {
                    this.appendError("IO error during expression execution: " + e.getMessage());
                }
            }
            return null;
        }
        if (command.startsWith(".help")) {
            Any v = Util.help(command);
            if (v.value instanceof String) {
                this.append((String)v.value);
                return null;
            }
            return new Value(v);
        }
        if (command.equals(".list")) {
            this.append(Util.list());
            return null;
        }
        if (command.startsWith(".ls")) {
            String result = command.equals(".ls") ? Util.fileList(this.workingDirectory, "") : Util.fileList(this.workingDirectory, command.substring(4));
            this.append(result);
            return null;
        }
        if (command.startsWith(".dir")) {
            String result = command.equals(".dir") ? Util.fileList(this.workingDirectory, "") : Util.fileList(this.workingDirectory, command.substring(5));
            this.append(result);
            return null;
        }
        if (command.startsWith(".cd")) {
            if (command.equals(".cd")) {
                this.workingDirectory = ResourceManager.platformUSerHomeDir();
            } else {
                String arg = command.substring(4);
                this.workingDirectory = Util.changeDirectory(this.workingDirectory, arg);
            }
            this.append("Working directory " + this.workingDirectory);
            return null;
        }
        if (command.equals(".pwd")) {
            this.append("Working directory " + this.workingDirectory);
            return null;
        }
        throw new BilabException("interactive command '" + command + "' not recognised.");
    }

    protected void handleInputKeyEvent(KeyEvent e) {
        if (e.stateMask == 0) {
            if (e.keyCode == 13) {
                String command = this.inputControl.getText().substring(prompt.length());
                if (command.length() > 0) {
                    this.append(this.inputControl.getText(), true, this.display.getSystemColor(9));
                    this.inputControl.setText("");
                    this.executeConsoleCommand(command);
                    this.inputControl.setText(prompt);
                    this.inputControl.setSelection(prompt.length());
                    this.inputControl.setFocus();
                } else {
                    this.append(prompt, false, this.display.getSystemColor(9));
                }
            } else if (e.keyCode == 0x1000001) {
                --this.historyPosition;
                if (this.historyPosition < 0) {
                    this.historyPosition = 0;
                }
                if (this.lineHistory.size() > 0) {
                    this.inputControl.setText(this.lineHistory.get(this.historyPosition));
                    this.inputControl.setSelection(this.inputControl.getText().length());
                }
                e.doit = false;
            } else if (e.keyCode == 0x1000002) {
                ++this.historyPosition;
                if (this.historyPosition > this.lineHistory.size()) {
                    this.historyPosition = this.lineHistory.size();
                }
                if (this.historyPosition == this.lineHistory.size()) {
                    this.inputControl.setText(prompt);
                } else {
                    this.inputControl.setText(this.lineHistory.get(this.historyPosition));
                }
                this.inputControl.setSelection(this.inputControl.getText().length());
                e.doit = false;
            } else if (this.inputControl.getCaretPosition() == prompt.length() && (e.keyCode == 8 || e.keyCode == 0x1000003)) {
                e.doit = false;
            }
        } else if (e.stateMask == 262144) {
            if (e.keyCode == 100 && this.inputControl.getText().length() == 1) {
                PlatformUI.getWorkbench().close();
                e.doit = false;
                return;
            }
            if (e.keyCode == 97) {
                this.inputControl.setSelection(1);
                e.doit = false;
            } else if (e.keyCode == 101) {
                this.inputControl.setSelection(this.inputControl.getText().length());
                e.doit = false;
            }
        }
        this.scrollToEnd();
        this.scrolledComposite.layout();
    }

    protected void fireSelectionChangedListeners() {
        ValueSelection s = new ValueSelection(this.selectedValue);
        for (ISelectionChangedListener l : selectionChangedListeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)s));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return new ValueSelection(this.selectedValue);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected class InputListener
    implements KeyListener {
        ConsoleView console;

        public InputListener(ConsoleView c) {
            this.console = c;
        }

        public void keyPressed(KeyEvent e) {
            this.console.handleInputKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

