/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2x;

import SQLite.Database;
import SQLite.JDBC2x.JDBCConnection;
import SQLite.JDBC2x.JDBCStatement;
import SQLite.StringEncoder;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JDBCPreparedStatement
extends JDBCStatement
implements PreparedStatement {
    private String sql;
    private String[] args;
    private boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCPreparedStatement(JDBCConnection jDBCConnection, String string) {
        super(jDBCConnection);
        this.sql = this.fixup(string);
    }

    private String fixup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                if (bl) {
                    char c2 = '\u0000';
                    if (i + 1 < string.length()) {
                        c2 = string.charAt(i + 1);
                    }
                    if (c2 == '\'') {
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        ++i;
                        continue;
                    }
                    bl = false;
                    stringBuffer.append(c);
                    continue;
                }
                bl = true;
                stringBuffer.append(c);
                continue;
            }
            if (c == '?') {
                if (bl) {
                    stringBuffer.append(c);
                    continue;
                }
                ++n;
                stringBuffer.append(this.nullrepl ? "'%q'" : "%Q");
                continue;
            }
            if (c == ';') {
                if (!bl) break;
                stringBuffer.append(c);
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%%");
                continue;
            }
            stringBuffer.append(c);
        }
        this.args = new String[n];
        try {
            this.clearParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.sql, this.args, false);
    }

    public int executeUpdate() throws SQLException {
        this.executeQuery(this.sql, this.args, true);
        return this.updcnt;
    }

    public void setNull(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = this.nullrepl ? "" : null;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = bl ? "1" : "0";
    }

    public void setByte(int n, byte by) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + by;
    }

    public void setShort(int n, short s) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + s;
    }

    public void setInt(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + n2;
    }

    public void setLong(int n, long l) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + l;
    }

    public void setFloat(int n, float f) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + f;
    }

    public void setDouble(int n, double d) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + d;
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + bigDecimal;
    }

    public void setString(int n, String string) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = string;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = StringEncoder.encode(byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = date.toString();
    }

    public void setTime(int n, Time time) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = time.toString();
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = timestamp.toString();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = this.nullrepl ? "" : null;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = object.toString();
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = object.toString();
    }

    public void setObject(int n, Object object) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = object.toString();
    }

    public boolean execute() throws SQLException {
        return this.executeQuery(this.sql, this.args, false) != null;
    }

    public void addBatch() throws SQLException {
        throw new SQLException("not supported");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public String getString(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("not supported");
    }
}

