/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;

public class ProblemFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_DIALOG_SECTION = "filter";
    private static final String TAG_SELECT_BY_SEVERITY = "selectBySeverity";
    private static final String TAG_SEVERITY = "severity";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    static final boolean DEFAULT_SELECT_BY_SEVERITY = false;
    static final int DEFAULT_SEVERITY = 0;
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final int SEVERITY_INFO = 1;
    private boolean contains;
    private String description;
    private boolean selectBySeverity;
    private int severity;

    public ProblemFilter() {
        super(new String[]{"org.eclipse.core.resources.problemmarker"});
    }

    public boolean selectMarker(ConcreteMarker marker) {
        if (!(marker instanceof ProblemMarker)) {
            return false;
        }
        ProblemMarker problemMarker = (ProblemMarker)marker;
        return !this.isEnabled() || super.selectMarker(problemMarker) && this.selectByDescription(problemMarker) && this.selectBySeverity(problemMarker);
    }

    private boolean selectByDescription(ConcreteMarker item) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String markerDescription = item.getDescription();
        int index = markerDescription.indexOf(this.description);
        return this.contains ? index >= 0 : index < 0;
    }

    private boolean selectBySeverity(ProblemMarker item) {
        if (this.selectBySeverity) {
            int markerSeverity = item.getSeverity();
            if (markerSeverity == 2) {
                return (this.severity & 4) > 0;
            }
            if (markerSeverity == 1) {
                return (this.severity & 2) > 0;
            }
            if (markerSeverity == 0) {
                return (this.severity & 1) > 0;
            }
        }
        return true;
    }

    public boolean getContains() {
        return this.contains;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getSelectBySeverity() {
        return this.selectBySeverity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setContains(boolean contains) {
        this.contains = contains;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSelectBySeverity(boolean selectBySeverity) {
        this.selectBySeverity = selectBySeverity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
        this.selectBySeverity = false;
        this.severity = 0;
    }

    public void restoreState(IDialogSettings dialogSettings) {
        super.restoreState(dialogSettings);
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null) {
            String setting = settings.get(TAG_CONTAINS);
            if (setting != null) {
                this.contains = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_DESCRIPTION)) != null) {
                this.description = new String(setting);
            }
            if ((setting = settings.get(TAG_SELECT_BY_SEVERITY)) != null) {
                this.selectBySeverity = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_SEVERITY)) != null) {
                try {
                    this.severity = Integer.parseInt(setting);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        super.saveState(dialogSettings);
        if (dialogSettings != null) {
            IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
            if (settings == null) {
                settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
            }
            settings.put(TAG_CONTAINS, this.contains);
            settings.put(TAG_DESCRIPTION, this.description);
            settings.put(TAG_SELECT_BY_SEVERITY, this.selectBySeverity);
            settings.put(TAG_SEVERITY, this.severity);
        }
    }
}

