/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import org.openscience.jmol.viewer.JmolViewer;

public class StyleManager {
    JmolViewer viewer;
    public int percentVdwAtom = 20;
    public short marBond = (short)100;
    public byte modeMultipleBond = (byte)2;
    public boolean showMultipleBonds = true;
    public boolean showAtoms = true;
    public boolean showBonds = true;
    public boolean showHydrogens = true;
    public boolean showVectors = true;
    public boolean showMeasurements = true;
    public boolean showMeasurementLabels = true;
    public String measureDistanceUnits = "nanometers";
    public String propertyStyleString = "";
    public boolean wireframeRotation = false;
    public boolean zeroBasedXyzRasmol = false;
    public boolean showFrank;
    public boolean ssbondsBackbone;
    public boolean hbondsBackbone;
    public int pointsLabelFontSize = 13;
    public int labelOffsetX = 4;
    public int labelOffsetY = 4;

    public StyleManager(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public void setPercentVdwAtom(int percentVdwAtom) {
        this.percentVdwAtom = percentVdwAtom;
    }

    public void setMarBond(short marBond) {
        this.marBond = marBond;
    }

    public void setModeMultipleBond(byte modeMultipleBond) {
        this.modeMultipleBond = modeMultipleBond;
    }

    public void setShowMultipleBonds(boolean showMultipleBonds) {
        this.showMultipleBonds = showMultipleBonds;
    }

    public void setShowAtoms(boolean showAtoms) {
        this.showAtoms = showAtoms;
    }

    public void setShowBonds(boolean showBonds) {
        this.showBonds = showBonds;
    }

    public void setShowHydrogens(boolean showHydrogens) {
        this.showHydrogens = showHydrogens;
    }

    public void setShowVectors(boolean showVectors) {
        this.showVectors = showVectors;
    }

    public void setShowMeasurements(boolean showMeasurements) {
        this.showMeasurements = showMeasurements;
    }

    public void setShowMeasurementLabels(boolean showMeasurementLabels) {
        this.showMeasurementLabels = showMeasurementLabels;
    }

    public boolean setMeasureDistanceUnits(String units) {
        if (units.equalsIgnoreCase("angstroms")) {
            this.measureDistanceUnits = "angstroms";
        } else if (units.equalsIgnoreCase("nanometers")) {
            this.measureDistanceUnits = "nanometers";
        } else if (units.equalsIgnoreCase("picometers")) {
            this.measureDistanceUnits = "picometers";
        } else {
            return false;
        }
        return true;
    }

    public void setPropertyStyleString(String s) {
        this.propertyStyleString = s;
    }

    public void setWireframeRotation(boolean wireframeRotation) {
        this.wireframeRotation = wireframeRotation;
    }

    public void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.zeroBasedXyzRasmol = zeroBasedXyzRasmol;
    }

    void setCommonDefaults() {
        this.viewer.zoomToPercent(100);
        this.viewer.setPercentVdwAtom(20);
        this.viewer.setWireframeRotation(false);
        this.viewer.setPerspectiveDepth(true);
        this.viewer.setBondTolerance(0.45f);
        this.viewer.setMinBondDistance(0.4f);
        this.viewer.setMarBond((short)150);
    }

    public void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setColorScheme("jmol");
        this.viewer.setAxesOrientationRasmol(false);
        this.setZeroBasedXyzRasmol(false);
    }

    public void setRasmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setColorScheme("rasmol");
        this.viewer.setAxesOrientationRasmol(true);
        this.setZeroBasedXyzRasmol(true);
        this.viewer.setPercentVdwAtom(0);
        this.viewer.setMarBond((short)1);
    }

    public void setShowFrank(boolean showFrank) {
        this.showFrank = showFrank;
    }

    public void setSsbondsBackbone(boolean ssbondsBackbone) {
        this.ssbondsBackbone = ssbondsBackbone;
    }

    public void setHbondsBackbone(boolean hbondsBackbone) {
        this.hbondsBackbone = hbondsBackbone;
    }

    public void setLabelFontSize(int points) {
        this.pointsLabelFontSize = points <= 0 ? 13 : points;
    }

    public void setLabelOffset(int offsetX, int offsetY) {
        this.labelOffsetX = offsetX;
        this.labelOffsetY = offsetY;
    }
}

