/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import java.awt.Color;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Frame;

public class ColorManager {
    JmolViewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    public byte paletteDefault = 0;
    public Color colorSelection = Color.orange;
    public short colixSelection = (short)2;
    public Color colorRubberband = Color.pink;
    public short colixRubberband = (short)3;
    public boolean isBondAtomColor = true;
    public Color colorBond = null;
    public short colixBond = 0;
    public Color colorHbond = null;
    public short colixHbond = 0;
    public Color colorSsbond = null;
    public short colixSsbond = 0;
    public Color colorLabel = Color.black;
    public short colixLabel = 1;
    public short colixDotsConvex = 0;
    public short colixDotsConcave = 0;
    public short colixDotsSaddle = 0;
    public Color colorDistance = Color.white;
    public short colixDistance = (short)5;
    public Color colorAngle = Color.white;
    public short colixAngle = (short)5;
    public Color colorTorsion = Color.white;
    public short colixTorsion = (short)5;
    public Color colorBackground = Color.white;
    public short colixBackground = (short)5;
    public Color colorAxes = new Color(128, 128, 0);
    public short colixAxes = (short)14;
    public Color colorAxesText = this.colorAxes;
    public short colixAxesText = (short)14;
    public Color colorVector = Color.black;
    public short colixVector = 1;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    final Vector3f vNormal = new Vector3f();
    final Vector3f vRotated = new Vector3f();

    public ColorManager(JmolViewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
    }

    public void setColorScheme(String colorScheme) {
        System.out.println("setting color scheme to:" + colorScheme);
        if (colorScheme.equals("jmol")) {
            this.argbsCpk = JmolConstants.argbsCpk;
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(Color.white);
            this.viewer.setColorLabel(Color.white);
            this.viewer.setShapeColorProperty(7, null);
        } else if (colorScheme.equals("rasmol")) {
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            this.argbsCpk = new int[JmolConstants.argbsCpk.length];
            int i = JmolConstants.argbsCpk.length;
            while (--i >= 0) {
                this.argbsCpk[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argb >> 24;
                this.argbsCpk[atomNo] = argb |= 0xFF000000;
                this.g3d.changeColixArgb((short)atomNo, argb);
            }
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(Color.white);
            this.viewer.setColorLabel(null);
            this.viewer.setShapeColorProperty(7, null);
        } else {
            System.out.println("unrecognized color scheme");
            return;
        }
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
    }

    public void setPaletteDefault(byte palette) {
        this.paletteDefault = palette;
    }

    public byte getPaletteDefault() {
        return this.paletteDefault;
    }

    public void setColorSelection(Color c) {
        this.colorSelection = c;
        this.colixSelection = this.g3d.getColix(c);
    }

    public Color getColorSelection() {
        return this.colorSelection;
    }

    public short getColixSelection() {
        return this.colixSelection;
    }

    public Color getColorRubberband() {
        return this.colorRubberband;
    }

    public short getColixRubberband() {
        return this.colixRubberband;
    }

    public void setIsBondAtomColor(boolean isBondAtomColor) {
        this.isBondAtomColor = isBondAtomColor;
    }

    public void setColorBond(Color c) {
        this.colorBond = c;
        this.colixBond = this.g3d.getColix(c);
    }

    public void setColorHbond(Color c) {
        this.colorHbond = c;
        this.colixHbond = this.g3d.getColix(c);
    }

    public void setColorSsbond(Color c) {
        this.colorSsbond = c;
        this.colixSsbond = this.g3d.getColix(c);
    }

    public void setColorLabel(Color color) {
        this.colorLabel = color;
        this.colixLabel = this.g3d.getColix(color);
    }

    public void setColorDotsConvex(Color color) {
        this.colixDotsConvex = this.g3d.getColix(color);
    }

    public void setColorDotsConcave(Color color) {
        this.colixDotsConcave = this.g3d.getColix(color);
    }

    public void setColorDotsSaddle(Color color) {
        this.colixDotsSaddle = this.g3d.getColix(color);
    }

    public void setColorDistance(Color c) {
        this.colorDistance = c;
        this.colixDistance = this.g3d.getColix(c);
    }

    public void setColorAngle(Color c) {
        this.colorAngle = c;
        this.colixAngle = this.g3d.getColix(c);
    }

    public void setColorTorsion(Color c) {
        this.colorTorsion = c;
        this.colixTorsion = this.g3d.getColix(c);
    }

    public void setColorMeasurement(Color c) {
        this.colorAngle = this.colorTorsion = c;
        this.colorDistance = this.colorTorsion;
        this.colixAngle = this.colixTorsion = this.g3d.getColix(c);
        this.colixDistance = this.colixTorsion;
    }

    public void setColorBackground(Color bg) {
        this.colorBackground = bg == null ? Color.getColor("colorBackground") : bg;
        this.colixBackground = this.g3d.getColix(this.colorBackground);
        this.g3d.setBackground(this.colixBackground);
    }

    public void setColorAxes(Color color) {
        this.colorAxes = color;
        this.colixAxes = this.g3d.getColix(color);
    }

    public void setColorAxesText(Color color) {
        this.colorAxesText = color;
        this.colixAxesText = this.g3d.getColix(color);
    }

    public void setColorVector(Color c) {
        this.colorVector = c;
        this.colixVector = this.g3d.getColix(c);
    }

    public Color getColorVector() {
        return this.colorVector;
    }

    public void setColorBackground(String colorName) {
        if (colorName != null && colorName.length() > 0) {
            this.setColorBackground(this.viewer.getColorFromString(colorName));
        }
    }

    public short getColixAtom(Atom atom) {
        return this.getColixAtomPalette(atom, this.paletteDefault);
    }

    public short getColixAtomPalette(Atom atom, byte palette) {
        int argb = 0;
        switch (palette) {
            case 0: {
                short id = atom.elementNumber;
                return this.g3d.getChangableColix(id, this.argbsCpk[id]);
            }
            case 6: {
                int index = this.quantize(-1.0f, 1.0f, atom.getPartialCharge(), JmolConstants.argbsRwbScale.length);
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 8: 
            case 9: {
                float hi;
                float lo;
                if (palette == 8) {
                    Frame frame = this.viewer.getFrame();
                    lo = frame.getBfactor100Lo();
                    hi = frame.getBfactor100Hi();
                } else {
                    lo = 0.0f;
                    hi = 10000.0f;
                }
                int index = this.quantize(lo, hi, atom.getBfactor100(), JmolConstants.argbsRwbScale.length);
                index = JmolConstants.argbsRwbScale.length - 1 - index;
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 1: {
                int index = atom.getFormalCharge() - -4;
                argb = JmolConstants.argbsCharge[index];
                break;
            }
            case 2: {
                argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 3: {
                short index = atom.getGroupID();
                if (index >= 23) {
                    index = 0;
                }
                argb = JmolConstants.argbsAmino[index];
                break;
            }
            case 4: {
                short index = atom.getGroupID();
                if (index >= 36) {
                    index = 0;
                }
                argb = JmolConstants.argbsShapely[index];
                break;
            }
            case 5: {
                int chain = atom.getChainID() & 0x1F;
                if (chain >= JmolConstants.argbsChainAtom.length) {
                    chain %= JmolConstants.argbsChainAtom.length;
                }
                argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
            }
        }
        if (argb == 0) {
            return 19;
        }
        return this.g3d.getColix(argb);
    }

    int quantize(float lo, float hi, float val, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 0.5f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    public short getColixHbondType(short order) {
        int argbIndex = (order & 0x3C0) >> 6;
        return this.g3d.getColix(JmolConstants.argbsHbondType[argbIndex]);
    }

    public void flushCachedColors() {
    }

    public int calcSurfaceIntensity(Point3f pA, Point3f pB, Point3f pC) {
        int intensity;
        this.vAB.sub(pB, pA);
        this.vAC.sub(pC, pA);
        this.vNormal.cross(this.vAB, this.vAC);
        this.viewer.transformVector(this.vNormal, this.vRotated);
        int n = intensity = this.vRotated.z >= 0.0f ? this.calcIntensity(-this.vRotated.x, -this.vRotated.y, this.vRotated.z) : this.calcIntensity(this.vRotated.x, this.vRotated.y, -this.vRotated.z);
        if (intensity > Graphics3D.intensitySpecularSurfaceLimit) {
            intensity = Graphics3D.intensitySpecularSurfaceLimit;
        }
        return intensity;
    }

    private void flushCaches() {
        this.g3d.flushShadesAndImageCaches();
        this.viewer.refresh();
    }

    public void setSpecular(boolean specular) {
        this.g3d.setSpecular(specular);
        this.flushCaches();
    }

    public boolean getSpecular() {
        return this.g3d.getSpecular();
    }

    public void setSpecularPower(int specularPower) {
        this.g3d.setSpecularPower(specularPower);
        this.flushCaches();
    }

    public void setAmbientPercent(int ambientPercent) {
        this.g3d.setAmbientPercent(ambientPercent);
        this.flushCaches();
    }

    public void setDiffusePercent(int diffusePercent) {
        this.g3d.setDiffusePercent(diffusePercent);
        this.flushCaches();
    }

    public void setSpecularPercent(int specularPercent) {
        this.g3d.setSpecularPercent(specularPercent);
        this.flushCaches();
    }

    public void setLightsourceZ(float dist) {
        this.g3d.setLightsourceZ(dist);
        this.flushCaches();
    }

    public int calcIntensity(float x, float y, float z) {
        return this.g3d.calcIntensity(x, y, z);
    }
}

