/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.Group;
import org.openscience.jmol.viewer.datamodel.Model;

public final class Mmset {
    Frame frame;
    private int modelCount = 0;
    private Model[] models = new Model[1];
    private String[] modelTags = new String[1];
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];

    Mmset(Frame frame) {
        this.frame = frame;
    }

    void defineStructure(String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])Util.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(structureType, startChainID, Group.getSeqcode(startSequenceNumber, startInsertionCode), endChainID, Group.getSeqcode(endSequenceNumber, endInsertionCode));
    }

    void calculateStructures() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calculateStructures();
        }
    }

    void freeze() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].freeze();
        }
        this.propogateSecondaryStructure();
    }

    Model getOrAllocateModel(String modelTag) {
        modelTag = modelTag.intern();
        int i = this.modelCount;
        while (--i >= 0) {
            if (this.modelTags[i] != modelTag) continue;
            return this.models[i];
        }
        if (this.modelCount == this.models.length) {
            this.models = (Model[])Util.doubleLength(this.models);
            this.modelTags = Util.doubleLength(this.modelTags);
        }
        this.modelTags[this.modelCount] = modelTag;
        Model model = new Model(this, this.modelCount, modelTag);
        this.models[this.modelCount++] = model;
        return model;
    }

    int getModelIndex(String modelTag) {
        int i = this.modelCount;
        while (--i >= 0 && !this.modelTags[i].equals(modelTag)) {
        }
        return i;
    }

    private void propogateSecondaryStructure() {
        int i = this.structureCount;
        while (--i >= 0) {
            Structure structure = this.structures[i];
            int j = this.modelCount;
            while (--j >= 0) {
                this.models[j].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
            }
        }
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getChainCount() {
        int chainCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            chainCount += this.models[i].getChainCount();
        }
        return chainCount;
    }

    public int getGroupCount() {
        int groupCount = 0;
        int i = this.modelCount;
        while (--i >= 0) {
            groupCount += this.models[i].getGroupCount();
        }
        return groupCount;
    }

    public void calcHydrogenBonds() {
        int i = this.modelCount;
        while (--i >= 0) {
            this.models[i].calcHydrogenBonds();
        }
    }

    static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;

        Structure(String typeName, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
            this.typeName = typeName;
            this.startChainID = startChainID;
            this.startSeqcode = startSeqcode;
            this.endChainID = endChainID;
            this.endSeqcode = endSeqcode;
            this.type = "helix".equals(typeName) ? (byte)3 : ("sheet".equals(typeName) ? (byte)2 : ("turn".equals(typeName) ? (byte)1 : 0));
        }
    }
}

