/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import org.jmol.api.ModelAdapter;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Bond;
import org.openscience.jmol.viewer.datamodel.Frame;

public final class FrameExportModelAdapter
extends ModelAdapter {
    JmolViewer viewer;
    Frame frame;

    FrameExportModelAdapter(JmolViewer viewer, Frame frame) {
        super("FrameExportModelAdapter", null);
        this.viewer = viewer;
        this.frame = frame;
    }

    public String getModelSetName(Object clientFile) {
        return this.viewer.getModelSetName();
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.frame.atomCount;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return this.frame.notionalUnitcell;
    }

    public ModelAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator();
    }

    public ModelAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator();
    }

    class BondIterator
    extends ModelAdapter.BondIterator {
        int ibond;
        Bond bond;

        BondIterator() {
        }

        public boolean hasNext() {
            if (this.ibond >= FrameExportModelAdapter.this.frame.bondCount) {
                return false;
            }
            this.bond = FrameExportModelAdapter.this.frame.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atom1.atomIndex);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atom2.atomIndex);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends ModelAdapter.AtomIterator {
        int iatom;
        Atom atom;

        AtomIterator() {
        }

        public boolean hasNext() {
            if (this.iatom == FrameExportModelAdapter.this.frame.atomCount) {
                return false;
            }
            this.atom = FrameExportModelAdapter.this.frame.atoms[this.iatom++];
            return true;
        }

        public Object getUniqueID() {
            return new Integer(this.iatom);
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getElementSymbol() {
            return this.atom.getElementSymbol();
        }

        public int getFormalCharge() {
            return this.atom.getFormalCharge();
        }

        public float getPartialCharge() {
            return this.atom.getPartialCharge();
        }

        public float getX() {
            return this.atom.getAtomX();
        }

        public float getY() {
            return this.atom.getAtomY();
        }

        public float getZ() {
            return this.atom.getAtomZ();
        }
    }
}

