/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.BitSet;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.Group;
import org.openscience.jmol.viewer.datamodel.Model;

public final class Chain {
    Frame frame;
    Model model;
    char chainID;
    int groupCount;
    Group[] groups = new Group[16];

    Chain(Frame frame, Model model, char chainID) {
        this.frame = frame;
        this.model = model;
        this.chainID = chainID;
    }

    void freeze() {
        this.groups = (Group[])Util.setLength(this.groups, this.groupCount);
    }

    void addGroup(Group group) {
        if (this.groupCount == this.groups.length) {
            this.groups = (Group[])Util.doubleLength(this.groups);
        }
        this.groups[this.groupCount++] = group;
    }

    Group getGroup(int groupIndex) {
        return this.groups[groupIndex];
    }

    int getGroupCount() {
        return this.groupCount;
    }

    public void selectAtoms(BitSet bs) {
        Frame frame = this.model.mmset.frame;
        Atom[] atoms = frame.getAtoms();
        int i = frame.getAtomCount();
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (atom.getChain() != this) continue;
            bs.set(i);
        }
    }
}

